<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named GetAccountSetting
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetAccountSetting $parameters
     * @return \StructType\GetAccountSettingResponse|bool
     */
    public function GetAccountSetting(\StructType\GetAccountSetting $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetAccountSetting($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetAuthToken
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetAuthToken $parameters
     * @return \StructType\GetAuthTokenResponse|bool
     */
    public function GetAuthToken(\StructType\GetAuthToken $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetAuthToken($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCustomer
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetCustomer $parameters
     * @return \StructType\GetCustomerResponse|bool
     */
    public function GetCustomer(\StructType\GetCustomer $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetCustomer($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCustomerGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetCustomerGroup $parameters
     * @return \StructType\GetCustomerGroupResponse|bool
     */
    public function GetCustomerGroup(\StructType\GetCustomerGroup $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetCustomerGroup($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCustomerGroupXml
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetCustomerGroupXml $parameters
     * @return \StructType\GetCustomerGroupXmlResponse|bool
     */
    public function GetCustomerGroupXml(\StructType\GetCustomerGroupXml $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetCustomerGroupXml($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCustomerTransactionData
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetCustomerTransactionData $parameters
     * @return \StructType\GetCustomerTransactionDataResponse|bool
     */
    public function GetCustomerTransactionData(\StructType\GetCustomerTransactionData $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetCustomerTransactionData($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCustomerV2
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetCustomerV2 $parameters
     * @return \StructType\GetCustomerV2Response|bool
     */
    public function GetCustomerV2(\StructType\GetCustomerV2 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetCustomerV2($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCustomerV2Xml
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetCustomerV2Xml $parameters
     * @return \StructType\GetCustomerV2XmlResponse|bool
     */
    public function GetCustomerV2Xml(\StructType\GetCustomerV2Xml $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetCustomerV2Xml($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCustomerV3
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetCustomerV3 $parameters
     * @return \StructType\GetCustomerV3Response|bool
     */
    public function GetCustomerV3(\StructType\GetCustomerV3 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetCustomerV3($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCustomerV3Xml
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetCustomerV3Xml $parameters
     * @return \StructType\GetCustomerV3XmlResponse|bool
     */
    public function GetCustomerV3Xml(\StructType\GetCustomerV3Xml $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetCustomerV3Xml($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCustomerV4
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetCustomerV4 $parameters
     * @return \StructType\GetCustomerV4Response|bool
     */
    public function GetCustomerV4(\StructType\GetCustomerV4 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetCustomerV4($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCustomerV4Xml
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetCustomerV4Xml $parameters
     * @return \StructType\GetCustomerV4XmlResponse|bool
     */
    public function GetCustomerV4Xml(\StructType\GetCustomerV4Xml $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetCustomerV4Xml($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCustomerV5
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetCustomerV5 $parameters
     * @return \StructType\GetCustomerV5Response|bool
     */
    public function GetCustomerV5(\StructType\GetCustomerV5 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetCustomerV5($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCustomerV5Xml
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetCustomerV5Xml $parameters
     * @return \StructType\GetCustomerV5XmlResponse|bool
     */
    public function GetCustomerV5Xml(\StructType\GetCustomerV5Xml $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetCustomerV5Xml($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCustomerXml
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetCustomerXml $parameters
     * @return \StructType\GetCustomerXmlResponse|bool
     */
    public function GetCustomerXml(\StructType\GetCustomerXml $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetCustomerXml($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetInvoice
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetInvoice $parameters
     * @return \StructType\GetInvoiceResponse|bool
     */
    public function GetInvoice(\StructType\GetInvoice $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetInvoice($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetInvoiceCustomerContact
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetInvoiceCustomerContact $parameters
     * @return \StructType\GetInvoiceCustomerContactResponse|bool
     */
    public function GetInvoiceCustomerContact(\StructType\GetInvoiceCustomerContact $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetInvoiceCustomerContact($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetInvoiceCustomerContactXml
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetInvoiceCustomerContactXml $parameters
     * @return \StructType\GetInvoiceCustomerContactXmlResponse|bool
     */
    public function GetInvoiceCustomerContactXml(\StructType\GetInvoiceCustomerContactXml $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetInvoiceCustomerContactXml($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetInvoiceTransactionData
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetInvoiceTransactionData $parameters
     * @return \StructType\GetInvoiceTransactionDataResponse|bool
     */
    public function GetInvoiceTransactionData(\StructType\GetInvoiceTransactionData $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetInvoiceTransactionData($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetInvoiceV2
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetInvoiceV2 $parameters
     * @return \StructType\GetInvoiceV2Response|bool
     */
    public function GetInvoiceV2(\StructType\GetInvoiceV2 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetInvoiceV2($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetInvoiceV2Xml
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetInvoiceV2Xml $parameters
     * @return \StructType\GetInvoiceV2XmlResponse|bool
     */
    public function GetInvoiceV2Xml(\StructType\GetInvoiceV2Xml $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetInvoiceV2Xml($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetInvoiceV3
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetInvoiceV3 $parameters
     * @return \StructType\GetInvoiceV3Response|bool
     */
    public function GetInvoiceV3(\StructType\GetInvoiceV3 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetInvoiceV3($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetInvoiceV3Xml
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetInvoiceV3Xml $parameters
     * @return \StructType\GetInvoiceV3XmlResponse|bool
     */
    public function GetInvoiceV3Xml(\StructType\GetInvoiceV3Xml $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetInvoiceV3Xml($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetInvoiceV4
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetInvoiceV4 $parameters
     * @return \StructType\GetInvoiceV4Response|bool
     */
    public function GetInvoiceV4(\StructType\GetInvoiceV4 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetInvoiceV4($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetInvoiceV4Xml
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetInvoiceV4Xml $parameters
     * @return \StructType\GetInvoiceV4XmlResponse|bool
     */
    public function GetInvoiceV4Xml(\StructType\GetInvoiceV4Xml $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetInvoiceV4Xml($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetInvoiceV5
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetInvoiceV5 $parameters
     * @return \StructType\GetInvoiceV5Response|bool
     */
    public function GetInvoiceV5(\StructType\GetInvoiceV5 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetInvoiceV5($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetInvoiceV5Xml
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetInvoiceV5Xml $parameters
     * @return \StructType\GetInvoiceV5XmlResponse|bool
     */
    public function GetInvoiceV5Xml(\StructType\GetInvoiceV5Xml $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetInvoiceV5Xml($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetInvoiceV6
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetInvoiceV6 $parameters
     * @return \StructType\GetInvoiceV6Response|bool
     */
    public function GetInvoiceV6(\StructType\GetInvoiceV6 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetInvoiceV6($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetInvoiceV6Xml
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetInvoiceV6Xml $parameters
     * @return \StructType\GetInvoiceV6XmlResponse|bool
     */
    public function GetInvoiceV6Xml(\StructType\GetInvoiceV6Xml $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetInvoiceV6Xml($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetInvoiceV7
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetInvoiceV7 $parameters
     * @return \StructType\GetInvoiceV7Response|bool
     */
    public function GetInvoiceV7(\StructType\GetInvoiceV7 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetInvoiceV7($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetInvoiceXml
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetInvoiceXml $parameters
     * @return \StructType\GetInvoiceXmlResponse|bool
     */
    public function GetInvoiceXml(\StructType\GetInvoiceXml $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetInvoiceXml($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetUnpaidInvoice
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetUnpaidInvoice $parameters
     * @return \StructType\GetUnpaidInvoiceResponse|bool
     */
    public function GetUnpaidInvoice(\StructType\GetUnpaidInvoice $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetUnpaidInvoice($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\GetAccountSettingResponse|\StructType\GetAuthTokenResponse|\StructType\GetCustomerGroupResponse|\StructType\GetCustomerGroupXmlResponse|\StructType\GetCustomerResponse|\StructType\GetCustomerTransactionDataResponse|\StructType\GetCustomerV2Response|\StructType\GetCustomerV2XmlResponse|\StructType\GetCustomerV3Response|\StructType\GetCustomerV3XmlResponse|\StructType\GetCustomerV4Response|\StructType\GetCustomerV4XmlResponse|\StructType\GetCustomerV5Response|\StructType\GetCustomerV5XmlResponse|\StructType\GetCustomerXmlResponse|\StructType\GetInvoiceCustomerContactResponse|\StructType\GetInvoiceCustomerContactXmlResponse|\StructType\GetInvoiceResponse|\StructType\GetInvoiceTransactionDataResponse|\StructType\GetInvoiceV2Response|\StructType\GetInvoiceV2XmlResponse|\StructType\GetInvoiceV3Response|\StructType\GetInvoiceV3XmlResponse|\StructType\GetInvoiceV4Response|\StructType\GetInvoiceV4XmlResponse|\StructType\GetInvoiceV5Response|\StructType\GetInvoiceV5XmlResponse|\StructType\GetInvoiceV6Response|\StructType\GetInvoiceV6XmlResponse|\StructType\GetInvoiceV7Response|\StructType\GetInvoiceXmlResponse|\StructType\GetUnpaidInvoiceResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
