<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfInvoiceV3 ArrayType
 * @subpackage Arrays
 */
class ArrayOfInvoiceV3 extends AbstractStructArrayBase
{
    /**
     * The InvoiceV3
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\InvoiceV3[]
     */
    public $InvoiceV3;
    /**
     * Constructor method for ArrayOfInvoiceV3
     * @uses ArrayOfInvoiceV3::setInvoiceV3()
     * @param \StructType\InvoiceV3[] $invoiceV3
     */
    public function __construct(array $invoiceV3 = array())
    {
        $this
            ->setInvoiceV3($invoiceV3);
    }
    /**
     * Get InvoiceV3 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\InvoiceV3[]|null
     */
    public function getInvoiceV3()
    {
        return isset($this->InvoiceV3) ? $this->InvoiceV3 : null;
    }
    /**
     * This method is responsible for validating the values passed to the setInvoiceV3 method
     * This method is willingly generated in order to preserve the one-line inline validation within the setInvoiceV3 method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateInvoiceV3ForArrayConstraintsFromSetInvoiceV3(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfInvoiceV3InvoiceV3Item) {
            // validation for constraint: itemType
            if (!$arrayOfInvoiceV3InvoiceV3Item instanceof \StructType\InvoiceV3) {
                $invalidValues[] = is_object($arrayOfInvoiceV3InvoiceV3Item) ? get_class($arrayOfInvoiceV3InvoiceV3Item) : sprintf('%s(%s)', gettype($arrayOfInvoiceV3InvoiceV3Item), var_export($arrayOfInvoiceV3InvoiceV3Item, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The InvoiceV3 property can only contain items of type \StructType\InvoiceV3, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set InvoiceV3 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\InvoiceV3[] $invoiceV3
     * @return \ArrayType\ArrayOfInvoiceV3
     */
    public function setInvoiceV3(array $invoiceV3 = array())
    {
        // validation for constraint: array
        if ('' !== ($invoiceV3ArrayErrorMessage = self::validateInvoiceV3ForArrayConstraintsFromSetInvoiceV3($invoiceV3))) {
            throw new \InvalidArgumentException($invoiceV3ArrayErrorMessage, __LINE__);
        }
        if (is_null($invoiceV3) || (is_array($invoiceV3) && empty($invoiceV3))) {
            unset($this->InvoiceV3);
        } else {
            $this->InvoiceV3 = $invoiceV3;
        }
        return $this;
    }
    /**
     * Add item to InvoiceV3 value
     * @throws \InvalidArgumentException
     * @param \StructType\InvoiceV3 $item
     * @return \ArrayType\ArrayOfInvoiceV3
     */
    public function addToInvoiceV3(\StructType\InvoiceV3 $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\InvoiceV3) {
            throw new \InvalidArgumentException(sprintf('The InvoiceV3 property can only contain items of type \StructType\InvoiceV3, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->InvoiceV3[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\InvoiceV3|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\InvoiceV3|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\InvoiceV3|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\InvoiceV3|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\InvoiceV3|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string InvoiceV3
     */
    public function getAttributeName()
    {
        return 'InvoiceV3';
    }
}
