<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfInvoiceTransactionData ArrayType
 * @subpackage Arrays
 */
class ArrayOfInvoiceTransactionData extends AbstractStructArrayBase
{
    /**
     * The InvoiceTransactionData
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\InvoiceTransactionData[]
     */
    public $InvoiceTransactionData;
    /**
     * Constructor method for ArrayOfInvoiceTransactionData
     * @uses ArrayOfInvoiceTransactionData::setInvoiceTransactionData()
     * @param \StructType\InvoiceTransactionData[] $invoiceTransactionData
     */
    public function __construct(array $invoiceTransactionData = array())
    {
        $this
            ->setInvoiceTransactionData($invoiceTransactionData);
    }
    /**
     * Get InvoiceTransactionData value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\InvoiceTransactionData[]|null
     */
    public function getInvoiceTransactionData()
    {
        return isset($this->InvoiceTransactionData) ? $this->InvoiceTransactionData : null;
    }
    /**
     * This method is responsible for validating the values passed to the setInvoiceTransactionData method
     * This method is willingly generated in order to preserve the one-line inline validation within the setInvoiceTransactionData method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateInvoiceTransactionDataForArrayConstraintsFromSetInvoiceTransactionData(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfInvoiceTransactionDataInvoiceTransactionDataItem) {
            // validation for constraint: itemType
            if (!$arrayOfInvoiceTransactionDataInvoiceTransactionDataItem instanceof \StructType\InvoiceTransactionData) {
                $invalidValues[] = is_object($arrayOfInvoiceTransactionDataInvoiceTransactionDataItem) ? get_class($arrayOfInvoiceTransactionDataInvoiceTransactionDataItem) : sprintf('%s(%s)', gettype($arrayOfInvoiceTransactionDataInvoiceTransactionDataItem), var_export($arrayOfInvoiceTransactionDataInvoiceTransactionDataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The InvoiceTransactionData property can only contain items of type \StructType\InvoiceTransactionData, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set InvoiceTransactionData value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\InvoiceTransactionData[] $invoiceTransactionData
     * @return \ArrayType\ArrayOfInvoiceTransactionData
     */
    public function setInvoiceTransactionData(array $invoiceTransactionData = array())
    {
        // validation for constraint: array
        if ('' !== ($invoiceTransactionDataArrayErrorMessage = self::validateInvoiceTransactionDataForArrayConstraintsFromSetInvoiceTransactionData($invoiceTransactionData))) {
            throw new \InvalidArgumentException($invoiceTransactionDataArrayErrorMessage, __LINE__);
        }
        if (is_null($invoiceTransactionData) || (is_array($invoiceTransactionData) && empty($invoiceTransactionData))) {
            unset($this->InvoiceTransactionData);
        } else {
            $this->InvoiceTransactionData = $invoiceTransactionData;
        }
        return $this;
    }
    /**
     * Add item to InvoiceTransactionData value
     * @throws \InvalidArgumentException
     * @param \StructType\InvoiceTransactionData $item
     * @return \ArrayType\ArrayOfInvoiceTransactionData
     */
    public function addToInvoiceTransactionData(\StructType\InvoiceTransactionData $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\InvoiceTransactionData) {
            throw new \InvalidArgumentException(sprintf('The InvoiceTransactionData property can only contain items of type \StructType\InvoiceTransactionData, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->InvoiceTransactionData[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\InvoiceTransactionData|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\InvoiceTransactionData|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\InvoiceTransactionData|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\InvoiceTransactionData|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\InvoiceTransactionData|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string InvoiceTransactionData
     */
    public function getAttributeName()
    {
        return 'InvoiceTransactionData';
    }
}
