<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfInvoicePayment ArrayType
 * @subpackage Arrays
 */
class ArrayOfInvoicePayment extends AbstractStructArrayBase
{
    /**
     * The InvoicePayment
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\InvoicePayment[]
     */
    public $InvoicePayment;
    /**
     * Constructor method for ArrayOfInvoicePayment
     * @uses ArrayOfInvoicePayment::setInvoicePayment()
     * @param \StructType\InvoicePayment[] $invoicePayment
     */
    public function __construct(array $invoicePayment = array())
    {
        $this
            ->setInvoicePayment($invoicePayment);
    }
    /**
     * Get InvoicePayment value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\InvoicePayment[]|null
     */
    public function getInvoicePayment()
    {
        return isset($this->InvoicePayment) ? $this->InvoicePayment : null;
    }
    /**
     * This method is responsible for validating the values passed to the setInvoicePayment method
     * This method is willingly generated in order to preserve the one-line inline validation within the setInvoicePayment method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateInvoicePaymentForArrayConstraintsFromSetInvoicePayment(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfInvoicePaymentInvoicePaymentItem) {
            // validation for constraint: itemType
            if (!$arrayOfInvoicePaymentInvoicePaymentItem instanceof \StructType\InvoicePayment) {
                $invalidValues[] = is_object($arrayOfInvoicePaymentInvoicePaymentItem) ? get_class($arrayOfInvoicePaymentInvoicePaymentItem) : sprintf('%s(%s)', gettype($arrayOfInvoicePaymentInvoicePaymentItem), var_export($arrayOfInvoicePaymentInvoicePaymentItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The InvoicePayment property can only contain items of type \StructType\InvoicePayment, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set InvoicePayment value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\InvoicePayment[] $invoicePayment
     * @return \ArrayType\ArrayOfInvoicePayment
     */
    public function setInvoicePayment(array $invoicePayment = array())
    {
        // validation for constraint: array
        if ('' !== ($invoicePaymentArrayErrorMessage = self::validateInvoicePaymentForArrayConstraintsFromSetInvoicePayment($invoicePayment))) {
            throw new \InvalidArgumentException($invoicePaymentArrayErrorMessage, __LINE__);
        }
        if (is_null($invoicePayment) || (is_array($invoicePayment) && empty($invoicePayment))) {
            unset($this->InvoicePayment);
        } else {
            $this->InvoicePayment = $invoicePayment;
        }
        return $this;
    }
    /**
     * Add item to InvoicePayment value
     * @throws \InvalidArgumentException
     * @param \StructType\InvoicePayment $item
     * @return \ArrayType\ArrayOfInvoicePayment
     */
    public function addToInvoicePayment(\StructType\InvoicePayment $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\InvoicePayment) {
            throw new \InvalidArgumentException(sprintf('The InvoicePayment property can only contain items of type \StructType\InvoicePayment, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->InvoicePayment[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\InvoicePayment|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\InvoicePayment|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\InvoicePayment|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\InvoicePayment|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\InvoicePayment|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string InvoicePayment
     */
    public function getAttributeName()
    {
        return 'InvoicePayment';
    }
}
