<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfCustomerGroup ArrayType
 * @subpackage Arrays
 */
class ArrayOfCustomerGroup extends AbstractStructArrayBase
{
    /**
     * The CustomerGroup
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\CustomerGroup[]
     */
    public $CustomerGroup;
    /**
     * Constructor method for ArrayOfCustomerGroup
     * @uses ArrayOfCustomerGroup::setCustomerGroup()
     * @param \StructType\CustomerGroup[] $customerGroup
     */
    public function __construct(array $customerGroup = array())
    {
        $this
            ->setCustomerGroup($customerGroup);
    }
    /**
     * Get CustomerGroup value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\CustomerGroup[]|null
     */
    public function getCustomerGroup()
    {
        return isset($this->CustomerGroup) ? $this->CustomerGroup : null;
    }
    /**
     * This method is responsible for validating the values passed to the setCustomerGroup method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCustomerGroup method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCustomerGroupForArrayConstraintsFromSetCustomerGroup(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfCustomerGroupCustomerGroupItem) {
            // validation for constraint: itemType
            if (!$arrayOfCustomerGroupCustomerGroupItem instanceof \StructType\CustomerGroup) {
                $invalidValues[] = is_object($arrayOfCustomerGroupCustomerGroupItem) ? get_class($arrayOfCustomerGroupCustomerGroupItem) : sprintf('%s(%s)', gettype($arrayOfCustomerGroupCustomerGroupItem), var_export($arrayOfCustomerGroupCustomerGroupItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The CustomerGroup property can only contain items of type \StructType\CustomerGroup, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CustomerGroup value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\CustomerGroup[] $customerGroup
     * @return \ArrayType\ArrayOfCustomerGroup
     */
    public function setCustomerGroup(array $customerGroup = array())
    {
        // validation for constraint: array
        if ('' !== ($customerGroupArrayErrorMessage = self::validateCustomerGroupForArrayConstraintsFromSetCustomerGroup($customerGroup))) {
            throw new \InvalidArgumentException($customerGroupArrayErrorMessage, __LINE__);
        }
        if (is_null($customerGroup) || (is_array($customerGroup) && empty($customerGroup))) {
            unset($this->CustomerGroup);
        } else {
            $this->CustomerGroup = $customerGroup;
        }
        return $this;
    }
    /**
     * Add item to CustomerGroup value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomerGroup $item
     * @return \ArrayType\ArrayOfCustomerGroup
     */
    public function addToCustomerGroup(\StructType\CustomerGroup $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CustomerGroup) {
            throw new \InvalidArgumentException(sprintf('The CustomerGroup property can only contain items of type \StructType\CustomerGroup, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->CustomerGroup[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\CustomerGroup|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\CustomerGroup|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\CustomerGroup|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\CustomerGroup|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\CustomerGroup|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string CustomerGroup
     */
    public function getAttributeName()
    {
        return 'CustomerGroup';
    }
}
