<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SetExported StructType
 * @subpackage Structs
 */
class SetExported extends AbstractStructBase
{
    /**
     * The invoiceID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $invoiceID;
    /**
     * The exported
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $exported;
    /**
     * The authToken
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $authToken;
    /**
     * Constructor method for SetExported
     * @uses SetExported::setInvoiceID()
     * @uses SetExported::setExported()
     * @uses SetExported::setAuthToken()
     * @param int $invoiceID
     * @param bool $exported
     * @param string $authToken
     */
    public function __construct($invoiceID = null, $exported = null, $authToken = null)
    {
        $this
            ->setInvoiceID($invoiceID)
            ->setExported($exported)
            ->setAuthToken($authToken);
    }
    /**
     * Get invoiceID value
     * @return int
     */
    public function getInvoiceID()
    {
        return $this->invoiceID;
    }
    /**
     * Set invoiceID value
     * @param int $invoiceID
     * @return \StructType\SetExported
     */
    public function setInvoiceID($invoiceID = null)
    {
        // validation for constraint: int
        if (!is_null($invoiceID) && !(is_int($invoiceID) || ctype_digit($invoiceID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($invoiceID, true), gettype($invoiceID)), __LINE__);
        }
        $this->invoiceID = $invoiceID;
        return $this;
    }
    /**
     * Get exported value
     * @return bool
     */
    public function getExported()
    {
        return $this->exported;
    }
    /**
     * Set exported value
     * @param bool $exported
     * @return \StructType\SetExported
     */
    public function setExported($exported = null)
    {
        // validation for constraint: boolean
        if (!is_null($exported) && !is_bool($exported)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($exported, true), gettype($exported)), __LINE__);
        }
        $this->exported = $exported;
        return $this;
    }
    /**
     * Get authToken value
     * @return string|null
     */
    public function getAuthToken()
    {
        return $this->authToken;
    }
    /**
     * Set authToken value
     * @param string $authToken
     * @return \StructType\SetExported
     */
    public function setAuthToken($authToken = null)
    {
        // validation for constraint: string
        if (!is_null($authToken) && !is_string($authToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($authToken, true), gettype($authToken)), __LINE__);
        }
        $this->authToken = $authToken;
        return $this;
    }
}
