<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SetCustomerXml StructType
 * @subpackage Structs
 */
class SetCustomerXml extends AbstractStructBase
{
    /**
     * The authToken
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $authToken;
    /**
     * The customer
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $customer;
    /**
     * Constructor method for SetCustomerXml
     * @uses SetCustomerXml::setAuthToken()
     * @uses SetCustomerXml::setCustomer()
     * @param string $authToken
     * @param string $customer
     */
    public function __construct($authToken = null, $customer = null)
    {
        $this
            ->setAuthToken($authToken)
            ->setCustomer($customer);
    }
    /**
     * Get authToken value
     * @return string|null
     */
    public function getAuthToken()
    {
        return $this->authToken;
    }
    /**
     * Set authToken value
     * @param string $authToken
     * @return \StructType\SetCustomerXml
     */
    public function setAuthToken($authToken = null)
    {
        // validation for constraint: string
        if (!is_null($authToken) && !is_string($authToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($authToken, true), gettype($authToken)), __LINE__);
        }
        $this->authToken = $authToken;
        return $this;
    }
    /**
     * Get customer value
     * @return string|null
     */
    public function getCustomer()
    {
        return $this->customer;
    }
    /**
     * Set customer value
     * @param string $customer
     * @return \StructType\SetCustomerXml
     */
    public function setCustomer($customer = null)
    {
        // validation for constraint: string
        if (!is_null($customer) && !is_string($customer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customer, true), gettype($customer)), __LINE__);
        }
        $this->customer = $customer;
        return $this;
    }
}
