<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SetCustomerV5 StructType
 * @subpackage Structs
 */
class SetCustomerV5 extends AbstractStructBase
{
    /**
     * The authToken
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $authToken;
    /**
     * The customer
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfCustomerV5
     */
    public $customer;
    /**
     * Constructor method for SetCustomerV5
     * @uses SetCustomerV5::setAuthToken()
     * @uses SetCustomerV5::setCustomer()
     * @param string $authToken
     * @param \ArrayType\ArrayOfCustomerV5 $customer
     */
    public function __construct($authToken = null, \ArrayType\ArrayOfCustomerV5 $customer = null)
    {
        $this
            ->setAuthToken($authToken)
            ->setCustomer($customer);
    }
    /**
     * Get authToken value
     * @return string|null
     */
    public function getAuthToken()
    {
        return $this->authToken;
    }
    /**
     * Set authToken value
     * @param string $authToken
     * @return \StructType\SetCustomerV5
     */
    public function setAuthToken($authToken = null)
    {
        // validation for constraint: string
        if (!is_null($authToken) && !is_string($authToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($authToken, true), gettype($authToken)), __LINE__);
        }
        $this->authToken = $authToken;
        return $this;
    }
    /**
     * Get customer value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfCustomerV5|null
     */
    public function getCustomer()
    {
        return isset($this->customer) ? $this->customer : null;
    }
    /**
     * Set customer value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfCustomerV5 $customer
     * @return \StructType\SetCustomerV5
     */
    public function setCustomer(\ArrayType\ArrayOfCustomerV5 $customer = null)
    {
        if (is_null($customer) || (is_array($customer) && empty($customer))) {
            unset($this->customer);
        } else {
            $this->customer = $customer;
        }
        return $this;
    }
}
