<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InvoiceV2 StructType
 * @subpackage Structs
 */
class InvoiceV2 extends AbstractStructBase
{
    /**
     * The InvoiceDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $InvoiceDate;
    /**
     * The InvoiceID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $InvoiceID;
    /**
     * The InvoiceCustomerID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $InvoiceCustomerID;
    /**
     * The TermDays
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $TermDays;
    /**
     * The InvoiceFee
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $InvoiceFee;
    /**
     * The ExpireDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ExpireDate;
    /**
     * The TotalSum
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $TotalSum;
    /**
     * The Printed
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $Printed;
    /**
     * The Exported
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $Exported;
    /**
     * The TotalSumIncVat
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $TotalSumIncVat;
    /**
     * The Rounding
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Rounding;
    /**
     * The VatFreeRows
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $VatFreeRows;
    /**
     * The Balance
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Balance;
    /**
     * The InvoiceEmail
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $InvoiceEmail;
    /**
     * The UnitName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $UnitName;
    /**
     * The EdiReference
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EdiReference;
    /**
     * The InvoiceNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $InvoiceNumber;
    /**
     * The InvoiceCustomerName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $InvoiceCustomerName;
    /**
     * The InvoiceAddress1
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $InvoiceAddress1;
    /**
     * The InvoiceAddress2
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $InvoiceAddress2;
    /**
     * The InvoiceCity
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $InvoiceCity;
    /**
     * The InvoiceZip
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $InvoiceZip;
    /**
     * The InvoiceCountry
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $InvoiceCountry;
    /**
     * The InvoicePhone
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $InvoicePhone;
    /**
     * The InvoiceMobile
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $InvoiceMobile;
    /**
     * The InvoiceOrgNr
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $InvoiceOrgNr;
    /**
     * The InvoiceVatNr
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $InvoiceVatNr;
    /**
     * The ShippingName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ShippingName;
    /**
     * The ShippingAddress1
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ShippingAddress1;
    /**
     * The ShippingAddress2
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ShippingAddress2;
    /**
     * The ShippingCity
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ShippingCity;
    /**
     * The ShippingZip
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ShippingZip;
    /**
     * The CustomerName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CustomerName;
    /**
     * The CustomerAddress1
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CustomerAddress1;
    /**
     * The CustomerAddress2
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CustomerAddress2;
    /**
     * The CustomerCity
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CustomerCity;
    /**
     * The CustomerZip
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CustomerZip;
    /**
     * The CustomerCountry
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CustomerCountry;
    /**
     * The PaymentTerms
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PaymentTerms;
    /**
     * The PoNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PoNumber;
    /**
     * The OurReference
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OurReference;
    /**
     * The CustomerReference
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CustomerReference;
    /**
     * The CustomerNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CustomerNumber;
    /**
     * The InvoiceRow
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\InvoiceRow[]
     */
    public $InvoiceRow;
    /**
     * Constructor method for InvoiceV2
     * @uses InvoiceV2::setInvoiceDate()
     * @uses InvoiceV2::setInvoiceID()
     * @uses InvoiceV2::setInvoiceCustomerID()
     * @uses InvoiceV2::setTermDays()
     * @uses InvoiceV2::setInvoiceFee()
     * @uses InvoiceV2::setExpireDate()
     * @uses InvoiceV2::setTotalSum()
     * @uses InvoiceV2::setPrinted()
     * @uses InvoiceV2::setExported()
     * @uses InvoiceV2::setTotalSumIncVat()
     * @uses InvoiceV2::setRounding()
     * @uses InvoiceV2::setVatFreeRows()
     * @uses InvoiceV2::setBalance()
     * @uses InvoiceV2::setInvoiceEmail()
     * @uses InvoiceV2::setUnitName()
     * @uses InvoiceV2::setEdiReference()
     * @uses InvoiceV2::setInvoiceNumber()
     * @uses InvoiceV2::setInvoiceCustomerName()
     * @uses InvoiceV2::setInvoiceAddress1()
     * @uses InvoiceV2::setInvoiceAddress2()
     * @uses InvoiceV2::setInvoiceCity()
     * @uses InvoiceV2::setInvoiceZip()
     * @uses InvoiceV2::setInvoiceCountry()
     * @uses InvoiceV2::setInvoicePhone()
     * @uses InvoiceV2::setInvoiceMobile()
     * @uses InvoiceV2::setInvoiceOrgNr()
     * @uses InvoiceV2::setInvoiceVatNr()
     * @uses InvoiceV2::setShippingName()
     * @uses InvoiceV2::setShippingAddress1()
     * @uses InvoiceV2::setShippingAddress2()
     * @uses InvoiceV2::setShippingCity()
     * @uses InvoiceV2::setShippingZip()
     * @uses InvoiceV2::setCustomerName()
     * @uses InvoiceV2::setCustomerAddress1()
     * @uses InvoiceV2::setCustomerAddress2()
     * @uses InvoiceV2::setCustomerCity()
     * @uses InvoiceV2::setCustomerZip()
     * @uses InvoiceV2::setCustomerCountry()
     * @uses InvoiceV2::setPaymentTerms()
     * @uses InvoiceV2::setPoNumber()
     * @uses InvoiceV2::setOurReference()
     * @uses InvoiceV2::setCustomerReference()
     * @uses InvoiceV2::setCustomerNumber()
     * @uses InvoiceV2::setInvoiceRow()
     * @param string $invoiceDate
     * @param int $invoiceID
     * @param int $invoiceCustomerID
     * @param int $termDays
     * @param float $invoiceFee
     * @param string $expireDate
     * @param float $totalSum
     * @param bool $printed
     * @param bool $exported
     * @param float $totalSumIncVat
     * @param float $rounding
     * @param bool $vatFreeRows
     * @param float $balance
     * @param string $invoiceEmail
     * @param string $unitName
     * @param string $ediReference
     * @param string $invoiceNumber
     * @param string $invoiceCustomerName
     * @param string $invoiceAddress1
     * @param string $invoiceAddress2
     * @param string $invoiceCity
     * @param string $invoiceZip
     * @param string $invoiceCountry
     * @param string $invoicePhone
     * @param string $invoiceMobile
     * @param string $invoiceOrgNr
     * @param string $invoiceVatNr
     * @param string $shippingName
     * @param string $shippingAddress1
     * @param string $shippingAddress2
     * @param string $shippingCity
     * @param string $shippingZip
     * @param string $customerName
     * @param string $customerAddress1
     * @param string $customerAddress2
     * @param string $customerCity
     * @param string $customerZip
     * @param string $customerCountry
     * @param string $paymentTerms
     * @param string $poNumber
     * @param string $ourReference
     * @param string $customerReference
     * @param string $customerNumber
     * @param \StructType\InvoiceRow[] $invoiceRow
     */
    public function __construct($invoiceDate = null, $invoiceID = null, $invoiceCustomerID = null, $termDays = null, $invoiceFee = null, $expireDate = null, $totalSum = null, $printed = null, $exported = null, $totalSumIncVat = null, $rounding = null, $vatFreeRows = null, $balance = null, $invoiceEmail = null, $unitName = null, $ediReference = null, $invoiceNumber = null, $invoiceCustomerName = null, $invoiceAddress1 = null, $invoiceAddress2 = null, $invoiceCity = null, $invoiceZip = null, $invoiceCountry = null, $invoicePhone = null, $invoiceMobile = null, $invoiceOrgNr = null, $invoiceVatNr = null, $shippingName = null, $shippingAddress1 = null, $shippingAddress2 = null, $shippingCity = null, $shippingZip = null, $customerName = null, $customerAddress1 = null, $customerAddress2 = null, $customerCity = null, $customerZip = null, $customerCountry = null, $paymentTerms = null, $poNumber = null, $ourReference = null, $customerReference = null, $customerNumber = null, array $invoiceRow = array())
    {
        $this
            ->setInvoiceDate($invoiceDate)
            ->setInvoiceID($invoiceID)
            ->setInvoiceCustomerID($invoiceCustomerID)
            ->setTermDays($termDays)
            ->setInvoiceFee($invoiceFee)
            ->setExpireDate($expireDate)
            ->setTotalSum($totalSum)
            ->setPrinted($printed)
            ->setExported($exported)
            ->setTotalSumIncVat($totalSumIncVat)
            ->setRounding($rounding)
            ->setVatFreeRows($vatFreeRows)
            ->setBalance($balance)
            ->setInvoiceEmail($invoiceEmail)
            ->setUnitName($unitName)
            ->setEdiReference($ediReference)
            ->setInvoiceNumber($invoiceNumber)
            ->setInvoiceCustomerName($invoiceCustomerName)
            ->setInvoiceAddress1($invoiceAddress1)
            ->setInvoiceAddress2($invoiceAddress2)
            ->setInvoiceCity($invoiceCity)
            ->setInvoiceZip($invoiceZip)
            ->setInvoiceCountry($invoiceCountry)
            ->setInvoicePhone($invoicePhone)
            ->setInvoiceMobile($invoiceMobile)
            ->setInvoiceOrgNr($invoiceOrgNr)
            ->setInvoiceVatNr($invoiceVatNr)
            ->setShippingName($shippingName)
            ->setShippingAddress1($shippingAddress1)
            ->setShippingAddress2($shippingAddress2)
            ->setShippingCity($shippingCity)
            ->setShippingZip($shippingZip)
            ->setCustomerName($customerName)
            ->setCustomerAddress1($customerAddress1)
            ->setCustomerAddress2($customerAddress2)
            ->setCustomerCity($customerCity)
            ->setCustomerZip($customerZip)
            ->setCustomerCountry($customerCountry)
            ->setPaymentTerms($paymentTerms)
            ->setPoNumber($poNumber)
            ->setOurReference($ourReference)
            ->setCustomerReference($customerReference)
            ->setCustomerNumber($customerNumber)
            ->setInvoiceRow($invoiceRow);
    }
    /**
     * Get InvoiceDate value
     * @return string
     */
    public function getInvoiceDate()
    {
        return $this->InvoiceDate;
    }
    /**
     * Set InvoiceDate value
     * @param string $invoiceDate
     * @return \StructType\InvoiceV2
     */
    public function setInvoiceDate($invoiceDate = null)
    {
        // validation for constraint: string
        if (!is_null($invoiceDate) && !is_string($invoiceDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoiceDate, true), gettype($invoiceDate)), __LINE__);
        }
        $this->InvoiceDate = $invoiceDate;
        return $this;
    }
    /**
     * Get InvoiceID value
     * @return int
     */
    public function getInvoiceID()
    {
        return $this->InvoiceID;
    }
    /**
     * Set InvoiceID value
     * @param int $invoiceID
     * @return \StructType\InvoiceV2
     */
    public function setInvoiceID($invoiceID = null)
    {
        // validation for constraint: int
        if (!is_null($invoiceID) && !(is_int($invoiceID) || ctype_digit($invoiceID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($invoiceID, true), gettype($invoiceID)), __LINE__);
        }
        $this->InvoiceID = $invoiceID;
        return $this;
    }
    /**
     * Get InvoiceCustomerID value
     * @return int
     */
    public function getInvoiceCustomerID()
    {
        return $this->InvoiceCustomerID;
    }
    /**
     * Set InvoiceCustomerID value
     * @param int $invoiceCustomerID
     * @return \StructType\InvoiceV2
     */
    public function setInvoiceCustomerID($invoiceCustomerID = null)
    {
        // validation for constraint: int
        if (!is_null($invoiceCustomerID) && !(is_int($invoiceCustomerID) || ctype_digit($invoiceCustomerID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($invoiceCustomerID, true), gettype($invoiceCustomerID)), __LINE__);
        }
        $this->InvoiceCustomerID = $invoiceCustomerID;
        return $this;
    }
    /**
     * Get TermDays value
     * @return int
     */
    public function getTermDays()
    {
        return $this->TermDays;
    }
    /**
     * Set TermDays value
     * @param int $termDays
     * @return \StructType\InvoiceV2
     */
    public function setTermDays($termDays = null)
    {
        // validation for constraint: int
        if (!is_null($termDays) && !(is_int($termDays) || ctype_digit($termDays))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($termDays, true), gettype($termDays)), __LINE__);
        }
        $this->TermDays = $termDays;
        return $this;
    }
    /**
     * Get InvoiceFee value
     * @return float
     */
    public function getInvoiceFee()
    {
        return $this->InvoiceFee;
    }
    /**
     * Set InvoiceFee value
     * @param float $invoiceFee
     * @return \StructType\InvoiceV2
     */
    public function setInvoiceFee($invoiceFee = null)
    {
        // validation for constraint: float
        if (!is_null($invoiceFee) && !(is_float($invoiceFee) || is_numeric($invoiceFee))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($invoiceFee, true), gettype($invoiceFee)), __LINE__);
        }
        $this->InvoiceFee = $invoiceFee;
        return $this;
    }
    /**
     * Get ExpireDate value
     * @return string
     */
    public function getExpireDate()
    {
        return $this->ExpireDate;
    }
    /**
     * Set ExpireDate value
     * @param string $expireDate
     * @return \StructType\InvoiceV2
     */
    public function setExpireDate($expireDate = null)
    {
        // validation for constraint: string
        if (!is_null($expireDate) && !is_string($expireDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($expireDate, true), gettype($expireDate)), __LINE__);
        }
        $this->ExpireDate = $expireDate;
        return $this;
    }
    /**
     * Get TotalSum value
     * @return float
     */
    public function getTotalSum()
    {
        return $this->TotalSum;
    }
    /**
     * Set TotalSum value
     * @param float $totalSum
     * @return \StructType\InvoiceV2
     */
    public function setTotalSum($totalSum = null)
    {
        // validation for constraint: float
        if (!is_null($totalSum) && !(is_float($totalSum) || is_numeric($totalSum))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($totalSum, true), gettype($totalSum)), __LINE__);
        }
        $this->TotalSum = $totalSum;
        return $this;
    }
    /**
     * Get Printed value
     * @return bool
     */
    public function getPrinted()
    {
        return $this->Printed;
    }
    /**
     * Set Printed value
     * @param bool $printed
     * @return \StructType\InvoiceV2
     */
    public function setPrinted($printed = null)
    {
        // validation for constraint: boolean
        if (!is_null($printed) && !is_bool($printed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($printed, true), gettype($printed)), __LINE__);
        }
        $this->Printed = $printed;
        return $this;
    }
    /**
     * Get Exported value
     * @return bool
     */
    public function getExported()
    {
        return $this->Exported;
    }
    /**
     * Set Exported value
     * @param bool $exported
     * @return \StructType\InvoiceV2
     */
    public function setExported($exported = null)
    {
        // validation for constraint: boolean
        if (!is_null($exported) && !is_bool($exported)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($exported, true), gettype($exported)), __LINE__);
        }
        $this->Exported = $exported;
        return $this;
    }
    /**
     * Get TotalSumIncVat value
     * @return float
     */
    public function getTotalSumIncVat()
    {
        return $this->TotalSumIncVat;
    }
    /**
     * Set TotalSumIncVat value
     * @param float $totalSumIncVat
     * @return \StructType\InvoiceV2
     */
    public function setTotalSumIncVat($totalSumIncVat = null)
    {
        // validation for constraint: float
        if (!is_null($totalSumIncVat) && !(is_float($totalSumIncVat) || is_numeric($totalSumIncVat))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($totalSumIncVat, true), gettype($totalSumIncVat)), __LINE__);
        }
        $this->TotalSumIncVat = $totalSumIncVat;
        return $this;
    }
    /**
     * Get Rounding value
     * @return float
     */
    public function getRounding()
    {
        return $this->Rounding;
    }
    /**
     * Set Rounding value
     * @param float $rounding
     * @return \StructType\InvoiceV2
     */
    public function setRounding($rounding = null)
    {
        // validation for constraint: float
        if (!is_null($rounding) && !(is_float($rounding) || is_numeric($rounding))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($rounding, true), gettype($rounding)), __LINE__);
        }
        $this->Rounding = $rounding;
        return $this;
    }
    /**
     * Get VatFreeRows value
     * @return bool
     */
    public function getVatFreeRows()
    {
        return $this->VatFreeRows;
    }
    /**
     * Set VatFreeRows value
     * @param bool $vatFreeRows
     * @return \StructType\InvoiceV2
     */
    public function setVatFreeRows($vatFreeRows = null)
    {
        // validation for constraint: boolean
        if (!is_null($vatFreeRows) && !is_bool($vatFreeRows)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($vatFreeRows, true), gettype($vatFreeRows)), __LINE__);
        }
        $this->VatFreeRows = $vatFreeRows;
        return $this;
    }
    /**
     * Get Balance value
     * @return float
     */
    public function getBalance()
    {
        return $this->Balance;
    }
    /**
     * Set Balance value
     * @param float $balance
     * @return \StructType\InvoiceV2
     */
    public function setBalance($balance = null)
    {
        // validation for constraint: float
        if (!is_null($balance) && !(is_float($balance) || is_numeric($balance))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($balance, true), gettype($balance)), __LINE__);
        }
        $this->Balance = $balance;
        return $this;
    }
    /**
     * Get InvoiceEmail value
     * @return string|null
     */
    public function getInvoiceEmail()
    {
        return $this->InvoiceEmail;
    }
    /**
     * Set InvoiceEmail value
     * @param string $invoiceEmail
     * @return \StructType\InvoiceV2
     */
    public function setInvoiceEmail($invoiceEmail = null)
    {
        // validation for constraint: string
        if (!is_null($invoiceEmail) && !is_string($invoiceEmail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoiceEmail, true), gettype($invoiceEmail)), __LINE__);
        }
        $this->InvoiceEmail = $invoiceEmail;
        return $this;
    }
    /**
     * Get UnitName value
     * @return string|null
     */
    public function getUnitName()
    {
        return $this->UnitName;
    }
    /**
     * Set UnitName value
     * @param string $unitName
     * @return \StructType\InvoiceV2
     */
    public function setUnitName($unitName = null)
    {
        // validation for constraint: string
        if (!is_null($unitName) && !is_string($unitName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($unitName, true), gettype($unitName)), __LINE__);
        }
        $this->UnitName = $unitName;
        return $this;
    }
    /**
     * Get EdiReference value
     * @return string|null
     */
    public function getEdiReference()
    {
        return $this->EdiReference;
    }
    /**
     * Set EdiReference value
     * @param string $ediReference
     * @return \StructType\InvoiceV2
     */
    public function setEdiReference($ediReference = null)
    {
        // validation for constraint: string
        if (!is_null($ediReference) && !is_string($ediReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ediReference, true), gettype($ediReference)), __LINE__);
        }
        $this->EdiReference = $ediReference;
        return $this;
    }
    /**
     * Get InvoiceNumber value
     * @return string|null
     */
    public function getInvoiceNumber()
    {
        return $this->InvoiceNumber;
    }
    /**
     * Set InvoiceNumber value
     * @param string $invoiceNumber
     * @return \StructType\InvoiceV2
     */
    public function setInvoiceNumber($invoiceNumber = null)
    {
        // validation for constraint: string
        if (!is_null($invoiceNumber) && !is_string($invoiceNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoiceNumber, true), gettype($invoiceNumber)), __LINE__);
        }
        $this->InvoiceNumber = $invoiceNumber;
        return $this;
    }
    /**
     * Get InvoiceCustomerName value
     * @return string|null
     */
    public function getInvoiceCustomerName()
    {
        return $this->InvoiceCustomerName;
    }
    /**
     * Set InvoiceCustomerName value
     * @param string $invoiceCustomerName
     * @return \StructType\InvoiceV2
     */
    public function setInvoiceCustomerName($invoiceCustomerName = null)
    {
        // validation for constraint: string
        if (!is_null($invoiceCustomerName) && !is_string($invoiceCustomerName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoiceCustomerName, true), gettype($invoiceCustomerName)), __LINE__);
        }
        $this->InvoiceCustomerName = $invoiceCustomerName;
        return $this;
    }
    /**
     * Get InvoiceAddress1 value
     * @return string|null
     */
    public function getInvoiceAddress1()
    {
        return $this->InvoiceAddress1;
    }
    /**
     * Set InvoiceAddress1 value
     * @param string $invoiceAddress1
     * @return \StructType\InvoiceV2
     */
    public function setInvoiceAddress1($invoiceAddress1 = null)
    {
        // validation for constraint: string
        if (!is_null($invoiceAddress1) && !is_string($invoiceAddress1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoiceAddress1, true), gettype($invoiceAddress1)), __LINE__);
        }
        $this->InvoiceAddress1 = $invoiceAddress1;
        return $this;
    }
    /**
     * Get InvoiceAddress2 value
     * @return string|null
     */
    public function getInvoiceAddress2()
    {
        return $this->InvoiceAddress2;
    }
    /**
     * Set InvoiceAddress2 value
     * @param string $invoiceAddress2
     * @return \StructType\InvoiceV2
     */
    public function setInvoiceAddress2($invoiceAddress2 = null)
    {
        // validation for constraint: string
        if (!is_null($invoiceAddress2) && !is_string($invoiceAddress2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoiceAddress2, true), gettype($invoiceAddress2)), __LINE__);
        }
        $this->InvoiceAddress2 = $invoiceAddress2;
        return $this;
    }
    /**
     * Get InvoiceCity value
     * @return string|null
     */
    public function getInvoiceCity()
    {
        return $this->InvoiceCity;
    }
    /**
     * Set InvoiceCity value
     * @param string $invoiceCity
     * @return \StructType\InvoiceV2
     */
    public function setInvoiceCity($invoiceCity = null)
    {
        // validation for constraint: string
        if (!is_null($invoiceCity) && !is_string($invoiceCity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoiceCity, true), gettype($invoiceCity)), __LINE__);
        }
        $this->InvoiceCity = $invoiceCity;
        return $this;
    }
    /**
     * Get InvoiceZip value
     * @return string|null
     */
    public function getInvoiceZip()
    {
        return $this->InvoiceZip;
    }
    /**
     * Set InvoiceZip value
     * @param string $invoiceZip
     * @return \StructType\InvoiceV2
     */
    public function setInvoiceZip($invoiceZip = null)
    {
        // validation for constraint: string
        if (!is_null($invoiceZip) && !is_string($invoiceZip)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoiceZip, true), gettype($invoiceZip)), __LINE__);
        }
        $this->InvoiceZip = $invoiceZip;
        return $this;
    }
    /**
     * Get InvoiceCountry value
     * @return string|null
     */
    public function getInvoiceCountry()
    {
        return $this->InvoiceCountry;
    }
    /**
     * Set InvoiceCountry value
     * @param string $invoiceCountry
     * @return \StructType\InvoiceV2
     */
    public function setInvoiceCountry($invoiceCountry = null)
    {
        // validation for constraint: string
        if (!is_null($invoiceCountry) && !is_string($invoiceCountry)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoiceCountry, true), gettype($invoiceCountry)), __LINE__);
        }
        $this->InvoiceCountry = $invoiceCountry;
        return $this;
    }
    /**
     * Get InvoicePhone value
     * @return string|null
     */
    public function getInvoicePhone()
    {
        return $this->InvoicePhone;
    }
    /**
     * Set InvoicePhone value
     * @param string $invoicePhone
     * @return \StructType\InvoiceV2
     */
    public function setInvoicePhone($invoicePhone = null)
    {
        // validation for constraint: string
        if (!is_null($invoicePhone) && !is_string($invoicePhone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoicePhone, true), gettype($invoicePhone)), __LINE__);
        }
        $this->InvoicePhone = $invoicePhone;
        return $this;
    }
    /**
     * Get InvoiceMobile value
     * @return string|null
     */
    public function getInvoiceMobile()
    {
        return $this->InvoiceMobile;
    }
    /**
     * Set InvoiceMobile value
     * @param string $invoiceMobile
     * @return \StructType\InvoiceV2
     */
    public function setInvoiceMobile($invoiceMobile = null)
    {
        // validation for constraint: string
        if (!is_null($invoiceMobile) && !is_string($invoiceMobile)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoiceMobile, true), gettype($invoiceMobile)), __LINE__);
        }
        $this->InvoiceMobile = $invoiceMobile;
        return $this;
    }
    /**
     * Get InvoiceOrgNr value
     * @return string|null
     */
    public function getInvoiceOrgNr()
    {
        return $this->InvoiceOrgNr;
    }
    /**
     * Set InvoiceOrgNr value
     * @param string $invoiceOrgNr
     * @return \StructType\InvoiceV2
     */
    public function setInvoiceOrgNr($invoiceOrgNr = null)
    {
        // validation for constraint: string
        if (!is_null($invoiceOrgNr) && !is_string($invoiceOrgNr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoiceOrgNr, true), gettype($invoiceOrgNr)), __LINE__);
        }
        $this->InvoiceOrgNr = $invoiceOrgNr;
        return $this;
    }
    /**
     * Get InvoiceVatNr value
     * @return string|null
     */
    public function getInvoiceVatNr()
    {
        return $this->InvoiceVatNr;
    }
    /**
     * Set InvoiceVatNr value
     * @param string $invoiceVatNr
     * @return \StructType\InvoiceV2
     */
    public function setInvoiceVatNr($invoiceVatNr = null)
    {
        // validation for constraint: string
        if (!is_null($invoiceVatNr) && !is_string($invoiceVatNr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoiceVatNr, true), gettype($invoiceVatNr)), __LINE__);
        }
        $this->InvoiceVatNr = $invoiceVatNr;
        return $this;
    }
    /**
     * Get ShippingName value
     * @return string|null
     */
    public function getShippingName()
    {
        return $this->ShippingName;
    }
    /**
     * Set ShippingName value
     * @param string $shippingName
     * @return \StructType\InvoiceV2
     */
    public function setShippingName($shippingName = null)
    {
        // validation for constraint: string
        if (!is_null($shippingName) && !is_string($shippingName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shippingName, true), gettype($shippingName)), __LINE__);
        }
        $this->ShippingName = $shippingName;
        return $this;
    }
    /**
     * Get ShippingAddress1 value
     * @return string|null
     */
    public function getShippingAddress1()
    {
        return $this->ShippingAddress1;
    }
    /**
     * Set ShippingAddress1 value
     * @param string $shippingAddress1
     * @return \StructType\InvoiceV2
     */
    public function setShippingAddress1($shippingAddress1 = null)
    {
        // validation for constraint: string
        if (!is_null($shippingAddress1) && !is_string($shippingAddress1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shippingAddress1, true), gettype($shippingAddress1)), __LINE__);
        }
        $this->ShippingAddress1 = $shippingAddress1;
        return $this;
    }
    /**
     * Get ShippingAddress2 value
     * @return string|null
     */
    public function getShippingAddress2()
    {
        return $this->ShippingAddress2;
    }
    /**
     * Set ShippingAddress2 value
     * @param string $shippingAddress2
     * @return \StructType\InvoiceV2
     */
    public function setShippingAddress2($shippingAddress2 = null)
    {
        // validation for constraint: string
        if (!is_null($shippingAddress2) && !is_string($shippingAddress2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shippingAddress2, true), gettype($shippingAddress2)), __LINE__);
        }
        $this->ShippingAddress2 = $shippingAddress2;
        return $this;
    }
    /**
     * Get ShippingCity value
     * @return string|null
     */
    public function getShippingCity()
    {
        return $this->ShippingCity;
    }
    /**
     * Set ShippingCity value
     * @param string $shippingCity
     * @return \StructType\InvoiceV2
     */
    public function setShippingCity($shippingCity = null)
    {
        // validation for constraint: string
        if (!is_null($shippingCity) && !is_string($shippingCity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shippingCity, true), gettype($shippingCity)), __LINE__);
        }
        $this->ShippingCity = $shippingCity;
        return $this;
    }
    /**
     * Get ShippingZip value
     * @return string|null
     */
    public function getShippingZip()
    {
        return $this->ShippingZip;
    }
    /**
     * Set ShippingZip value
     * @param string $shippingZip
     * @return \StructType\InvoiceV2
     */
    public function setShippingZip($shippingZip = null)
    {
        // validation for constraint: string
        if (!is_null($shippingZip) && !is_string($shippingZip)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shippingZip, true), gettype($shippingZip)), __LINE__);
        }
        $this->ShippingZip = $shippingZip;
        return $this;
    }
    /**
     * Get CustomerName value
     * @return string|null
     */
    public function getCustomerName()
    {
        return $this->CustomerName;
    }
    /**
     * Set CustomerName value
     * @param string $customerName
     * @return \StructType\InvoiceV2
     */
    public function setCustomerName($customerName = null)
    {
        // validation for constraint: string
        if (!is_null($customerName) && !is_string($customerName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerName, true), gettype($customerName)), __LINE__);
        }
        $this->CustomerName = $customerName;
        return $this;
    }
    /**
     * Get CustomerAddress1 value
     * @return string|null
     */
    public function getCustomerAddress1()
    {
        return $this->CustomerAddress1;
    }
    /**
     * Set CustomerAddress1 value
     * @param string $customerAddress1
     * @return \StructType\InvoiceV2
     */
    public function setCustomerAddress1($customerAddress1 = null)
    {
        // validation for constraint: string
        if (!is_null($customerAddress1) && !is_string($customerAddress1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerAddress1, true), gettype($customerAddress1)), __LINE__);
        }
        $this->CustomerAddress1 = $customerAddress1;
        return $this;
    }
    /**
     * Get CustomerAddress2 value
     * @return string|null
     */
    public function getCustomerAddress2()
    {
        return $this->CustomerAddress2;
    }
    /**
     * Set CustomerAddress2 value
     * @param string $customerAddress2
     * @return \StructType\InvoiceV2
     */
    public function setCustomerAddress2($customerAddress2 = null)
    {
        // validation for constraint: string
        if (!is_null($customerAddress2) && !is_string($customerAddress2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerAddress2, true), gettype($customerAddress2)), __LINE__);
        }
        $this->CustomerAddress2 = $customerAddress2;
        return $this;
    }
    /**
     * Get CustomerCity value
     * @return string|null
     */
    public function getCustomerCity()
    {
        return $this->CustomerCity;
    }
    /**
     * Set CustomerCity value
     * @param string $customerCity
     * @return \StructType\InvoiceV2
     */
    public function setCustomerCity($customerCity = null)
    {
        // validation for constraint: string
        if (!is_null($customerCity) && !is_string($customerCity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerCity, true), gettype($customerCity)), __LINE__);
        }
        $this->CustomerCity = $customerCity;
        return $this;
    }
    /**
     * Get CustomerZip value
     * @return string|null
     */
    public function getCustomerZip()
    {
        return $this->CustomerZip;
    }
    /**
     * Set CustomerZip value
     * @param string $customerZip
     * @return \StructType\InvoiceV2
     */
    public function setCustomerZip($customerZip = null)
    {
        // validation for constraint: string
        if (!is_null($customerZip) && !is_string($customerZip)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerZip, true), gettype($customerZip)), __LINE__);
        }
        $this->CustomerZip = $customerZip;
        return $this;
    }
    /**
     * Get CustomerCountry value
     * @return string|null
     */
    public function getCustomerCountry()
    {
        return $this->CustomerCountry;
    }
    /**
     * Set CustomerCountry value
     * @param string $customerCountry
     * @return \StructType\InvoiceV2
     */
    public function setCustomerCountry($customerCountry = null)
    {
        // validation for constraint: string
        if (!is_null($customerCountry) && !is_string($customerCountry)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerCountry, true), gettype($customerCountry)), __LINE__);
        }
        $this->CustomerCountry = $customerCountry;
        return $this;
    }
    /**
     * Get PaymentTerms value
     * @return string|null
     */
    public function getPaymentTerms()
    {
        return $this->PaymentTerms;
    }
    /**
     * Set PaymentTerms value
     * @param string $paymentTerms
     * @return \StructType\InvoiceV2
     */
    public function setPaymentTerms($paymentTerms = null)
    {
        // validation for constraint: string
        if (!is_null($paymentTerms) && !is_string($paymentTerms)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentTerms, true), gettype($paymentTerms)), __LINE__);
        }
        $this->PaymentTerms = $paymentTerms;
        return $this;
    }
    /**
     * Get PoNumber value
     * @return string|null
     */
    public function getPoNumber()
    {
        return $this->PoNumber;
    }
    /**
     * Set PoNumber value
     * @param string $poNumber
     * @return \StructType\InvoiceV2
     */
    public function setPoNumber($poNumber = null)
    {
        // validation for constraint: string
        if (!is_null($poNumber) && !is_string($poNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($poNumber, true), gettype($poNumber)), __LINE__);
        }
        $this->PoNumber = $poNumber;
        return $this;
    }
    /**
     * Get OurReference value
     * @return string|null
     */
    public function getOurReference()
    {
        return $this->OurReference;
    }
    /**
     * Set OurReference value
     * @param string $ourReference
     * @return \StructType\InvoiceV2
     */
    public function setOurReference($ourReference = null)
    {
        // validation for constraint: string
        if (!is_null($ourReference) && !is_string($ourReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ourReference, true), gettype($ourReference)), __LINE__);
        }
        $this->OurReference = $ourReference;
        return $this;
    }
    /**
     * Get CustomerReference value
     * @return string|null
     */
    public function getCustomerReference()
    {
        return $this->CustomerReference;
    }
    /**
     * Set CustomerReference value
     * @param string $customerReference
     * @return \StructType\InvoiceV2
     */
    public function setCustomerReference($customerReference = null)
    {
        // validation for constraint: string
        if (!is_null($customerReference) && !is_string($customerReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerReference, true), gettype($customerReference)), __LINE__);
        }
        $this->CustomerReference = $customerReference;
        return $this;
    }
    /**
     * Get CustomerNumber value
     * @return string|null
     */
    public function getCustomerNumber()
    {
        return $this->CustomerNumber;
    }
    /**
     * Set CustomerNumber value
     * @param string $customerNumber
     * @return \StructType\InvoiceV2
     */
    public function setCustomerNumber($customerNumber = null)
    {
        // validation for constraint: string
        if (!is_null($customerNumber) && !is_string($customerNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerNumber, true), gettype($customerNumber)), __LINE__);
        }
        $this->CustomerNumber = $customerNumber;
        return $this;
    }
    /**
     * Get InvoiceRow value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\InvoiceRow[]|null
     */
    public function getInvoiceRow()
    {
        return isset($this->InvoiceRow) ? $this->InvoiceRow : null;
    }
    /**
     * This method is responsible for validating the values passed to the setInvoiceRow method
     * This method is willingly generated in order to preserve the one-line inline validation within the setInvoiceRow method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateInvoiceRowForArrayConstraintsFromSetInvoiceRow(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $invoiceV2InvoiceRowItem) {
            // validation for constraint: itemType
            if (!$invoiceV2InvoiceRowItem instanceof \StructType\InvoiceRow) {
                $invalidValues[] = is_object($invoiceV2InvoiceRowItem) ? get_class($invoiceV2InvoiceRowItem) : sprintf('%s(%s)', gettype($invoiceV2InvoiceRowItem), var_export($invoiceV2InvoiceRowItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The InvoiceRow property can only contain items of type \StructType\InvoiceRow, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set InvoiceRow value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\InvoiceRow[] $invoiceRow
     * @return \StructType\InvoiceV2
     */
    public function setInvoiceRow(array $invoiceRow = array())
    {
        // validation for constraint: array
        if ('' !== ($invoiceRowArrayErrorMessage = self::validateInvoiceRowForArrayConstraintsFromSetInvoiceRow($invoiceRow))) {
            throw new \InvalidArgumentException($invoiceRowArrayErrorMessage, __LINE__);
        }
        if (is_null($invoiceRow) || (is_array($invoiceRow) && empty($invoiceRow))) {
            unset($this->InvoiceRow);
        } else {
            $this->InvoiceRow = $invoiceRow;
        }
        return $this;
    }
    /**
     * Add item to InvoiceRow value
     * @throws \InvalidArgumentException
     * @param \StructType\InvoiceRow $item
     * @return \StructType\InvoiceV2
     */
    public function addToInvoiceRow(\StructType\InvoiceRow $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\InvoiceRow) {
            throw new \InvalidArgumentException(sprintf('The InvoiceRow property can only contain items of type \StructType\InvoiceRow, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->InvoiceRow[] = $item;
        return $this;
    }
}
