<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InvoiceRowV3 StructType
 * @subpackage Structs
 */
class InvoiceRowV3 extends AbstractStructBase
{
    /**
     * The StartDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $StartDate;
    /**
     * The EndDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $EndDate;
    /**
     * The Cost
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $Cost;
    /**
     * The InvoiceRowID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $InvoiceRowID;
    /**
     * The Price
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Price;
    /**
     * The TotalPrice
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $TotalPrice;
    /**
     * The Quantity
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Quantity;
    /**
     * The ObjectID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $ObjectID;
    /**
     * The DiscountPercent
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $DiscountPercent;
    /**
     * The VatPercent
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $VatPercent;
    /**
     * The ExtraFields
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfInvoiceKeyValuePair
     */
    public $ExtraFields;
    /**
     * The ItemNr
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ItemNr;
    /**
     * The CostCenter
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CostCenter;
    /**
     * The Account
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Account;
    /**
     * The ProjectNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ProjectNumber;
    /**
     * The BusinessNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BusinessNumber;
    /**
     * The RowText
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RowText;
    /**
     * Constructor method for InvoiceRowV3
     * @uses InvoiceRowV3::setStartDate()
     * @uses InvoiceRowV3::setEndDate()
     * @uses InvoiceRowV3::setCost()
     * @uses InvoiceRowV3::setInvoiceRowID()
     * @uses InvoiceRowV3::setPrice()
     * @uses InvoiceRowV3::setTotalPrice()
     * @uses InvoiceRowV3::setQuantity()
     * @uses InvoiceRowV3::setObjectID()
     * @uses InvoiceRowV3::setDiscountPercent()
     * @uses InvoiceRowV3::setVatPercent()
     * @uses InvoiceRowV3::setExtraFields()
     * @uses InvoiceRowV3::setItemNr()
     * @uses InvoiceRowV3::setCostCenter()
     * @uses InvoiceRowV3::setAccount()
     * @uses InvoiceRowV3::setProjectNumber()
     * @uses InvoiceRowV3::setBusinessNumber()
     * @uses InvoiceRowV3::setRowText()
     * @param string $startDate
     * @param string $endDate
     * @param float $cost
     * @param int $invoiceRowID
     * @param float $price
     * @param float $totalPrice
     * @param int $quantity
     * @param int $objectID
     * @param int $discountPercent
     * @param int $vatPercent
     * @param \ArrayType\ArrayOfInvoiceKeyValuePair $extraFields
     * @param string $itemNr
     * @param string $costCenter
     * @param string $account
     * @param string $projectNumber
     * @param string $businessNumber
     * @param string $rowText
     */
    public function __construct($startDate = null, $endDate = null, $cost = null, $invoiceRowID = null, $price = null, $totalPrice = null, $quantity = null, $objectID = null, $discountPercent = null, $vatPercent = null, \ArrayType\ArrayOfInvoiceKeyValuePair $extraFields = null, $itemNr = null, $costCenter = null, $account = null, $projectNumber = null, $businessNumber = null, $rowText = null)
    {
        $this
            ->setStartDate($startDate)
            ->setEndDate($endDate)
            ->setCost($cost)
            ->setInvoiceRowID($invoiceRowID)
            ->setPrice($price)
            ->setTotalPrice($totalPrice)
            ->setQuantity($quantity)
            ->setObjectID($objectID)
            ->setDiscountPercent($discountPercent)
            ->setVatPercent($vatPercent)
            ->setExtraFields($extraFields)
            ->setItemNr($itemNr)
            ->setCostCenter($costCenter)
            ->setAccount($account)
            ->setProjectNumber($projectNumber)
            ->setBusinessNumber($businessNumber)
            ->setRowText($rowText);
    }
    /**
     * Get StartDate value
     * @return string
     */
    public function getStartDate()
    {
        return $this->StartDate;
    }
    /**
     * Set StartDate value
     * @param string $startDate
     * @return \StructType\InvoiceRowV3
     */
    public function setStartDate($startDate = null)
    {
        // validation for constraint: string
        if (!is_null($startDate) && !is_string($startDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($startDate, true), gettype($startDate)), __LINE__);
        }
        $this->StartDate = $startDate;
        return $this;
    }
    /**
     * Get EndDate value
     * @return string
     */
    public function getEndDate()
    {
        return $this->EndDate;
    }
    /**
     * Set EndDate value
     * @param string $endDate
     * @return \StructType\InvoiceRowV3
     */
    public function setEndDate($endDate = null)
    {
        // validation for constraint: string
        if (!is_null($endDate) && !is_string($endDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($endDate, true), gettype($endDate)), __LINE__);
        }
        $this->EndDate = $endDate;
        return $this;
    }
    /**
     * Get Cost value
     * @return float
     */
    public function getCost()
    {
        return $this->Cost;
    }
    /**
     * Set Cost value
     * @param float $cost
     * @return \StructType\InvoiceRowV3
     */
    public function setCost($cost = null)
    {
        // validation for constraint: float
        if (!is_null($cost) && !(is_float($cost) || is_numeric($cost))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($cost, true), gettype($cost)), __LINE__);
        }
        $this->Cost = $cost;
        return $this;
    }
    /**
     * Get InvoiceRowID value
     * @return int
     */
    public function getInvoiceRowID()
    {
        return $this->InvoiceRowID;
    }
    /**
     * Set InvoiceRowID value
     * @param int $invoiceRowID
     * @return \StructType\InvoiceRowV3
     */
    public function setInvoiceRowID($invoiceRowID = null)
    {
        // validation for constraint: int
        if (!is_null($invoiceRowID) && !(is_int($invoiceRowID) || ctype_digit($invoiceRowID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($invoiceRowID, true), gettype($invoiceRowID)), __LINE__);
        }
        $this->InvoiceRowID = $invoiceRowID;
        return $this;
    }
    /**
     * Get Price value
     * @return float
     */
    public function getPrice()
    {
        return $this->Price;
    }
    /**
     * Set Price value
     * @param float $price
     * @return \StructType\InvoiceRowV3
     */
    public function setPrice($price = null)
    {
        // validation for constraint: float
        if (!is_null($price) && !(is_float($price) || is_numeric($price))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($price, true), gettype($price)), __LINE__);
        }
        $this->Price = $price;
        return $this;
    }
    /**
     * Get TotalPrice value
     * @return float
     */
    public function getTotalPrice()
    {
        return $this->TotalPrice;
    }
    /**
     * Set TotalPrice value
     * @param float $totalPrice
     * @return \StructType\InvoiceRowV3
     */
    public function setTotalPrice($totalPrice = null)
    {
        // validation for constraint: float
        if (!is_null($totalPrice) && !(is_float($totalPrice) || is_numeric($totalPrice))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($totalPrice, true), gettype($totalPrice)), __LINE__);
        }
        $this->TotalPrice = $totalPrice;
        return $this;
    }
    /**
     * Get Quantity value
     * @return int
     */
    public function getQuantity()
    {
        return $this->Quantity;
    }
    /**
     * Set Quantity value
     * @param int $quantity
     * @return \StructType\InvoiceRowV3
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: int
        if (!is_null($quantity) && !(is_int($quantity) || ctype_digit($quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        $this->Quantity = $quantity;
        return $this;
    }
    /**
     * Get ObjectID value
     * @return int
     */
    public function getObjectID()
    {
        return $this->ObjectID;
    }
    /**
     * Set ObjectID value
     * @param int $objectID
     * @return \StructType\InvoiceRowV3
     */
    public function setObjectID($objectID = null)
    {
        // validation for constraint: int
        if (!is_null($objectID) && !(is_int($objectID) || ctype_digit($objectID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($objectID, true), gettype($objectID)), __LINE__);
        }
        $this->ObjectID = $objectID;
        return $this;
    }
    /**
     * Get DiscountPercent value
     * @return int
     */
    public function getDiscountPercent()
    {
        return $this->DiscountPercent;
    }
    /**
     * Set DiscountPercent value
     * @param int $discountPercent
     * @return \StructType\InvoiceRowV3
     */
    public function setDiscountPercent($discountPercent = null)
    {
        // validation for constraint: int
        if (!is_null($discountPercent) && !(is_int($discountPercent) || ctype_digit($discountPercent))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($discountPercent, true), gettype($discountPercent)), __LINE__);
        }
        $this->DiscountPercent = $discountPercent;
        return $this;
    }
    /**
     * Get VatPercent value
     * @return int
     */
    public function getVatPercent()
    {
        return $this->VatPercent;
    }
    /**
     * Set VatPercent value
     * @param int $vatPercent
     * @return \StructType\InvoiceRowV3
     */
    public function setVatPercent($vatPercent = null)
    {
        // validation for constraint: int
        if (!is_null($vatPercent) && !(is_int($vatPercent) || ctype_digit($vatPercent))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($vatPercent, true), gettype($vatPercent)), __LINE__);
        }
        $this->VatPercent = $vatPercent;
        return $this;
    }
    /**
     * Get ExtraFields value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfInvoiceKeyValuePair|null
     */
    public function getExtraFields()
    {
        return isset($this->ExtraFields) ? $this->ExtraFields : null;
    }
    /**
     * Set ExtraFields value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfInvoiceKeyValuePair $extraFields
     * @return \StructType\InvoiceRowV3
     */
    public function setExtraFields(\ArrayType\ArrayOfInvoiceKeyValuePair $extraFields = null)
    {
        if (is_null($extraFields) || (is_array($extraFields) && empty($extraFields))) {
            unset($this->ExtraFields);
        } else {
            $this->ExtraFields = $extraFields;
        }
        return $this;
    }
    /**
     * Get ItemNr value
     * @return string|null
     */
    public function getItemNr()
    {
        return $this->ItemNr;
    }
    /**
     * Set ItemNr value
     * @param string $itemNr
     * @return \StructType\InvoiceRowV3
     */
    public function setItemNr($itemNr = null)
    {
        // validation for constraint: string
        if (!is_null($itemNr) && !is_string($itemNr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itemNr, true), gettype($itemNr)), __LINE__);
        }
        $this->ItemNr = $itemNr;
        return $this;
    }
    /**
     * Get CostCenter value
     * @return string|null
     */
    public function getCostCenter()
    {
        return $this->CostCenter;
    }
    /**
     * Set CostCenter value
     * @param string $costCenter
     * @return \StructType\InvoiceRowV3
     */
    public function setCostCenter($costCenter = null)
    {
        // validation for constraint: string
        if (!is_null($costCenter) && !is_string($costCenter)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($costCenter, true), gettype($costCenter)), __LINE__);
        }
        $this->CostCenter = $costCenter;
        return $this;
    }
    /**
     * Get Account value
     * @return string|null
     */
    public function getAccount()
    {
        return $this->Account;
    }
    /**
     * Set Account value
     * @param string $account
     * @return \StructType\InvoiceRowV3
     */
    public function setAccount($account = null)
    {
        // validation for constraint: string
        if (!is_null($account) && !is_string($account)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($account, true), gettype($account)), __LINE__);
        }
        $this->Account = $account;
        return $this;
    }
    /**
     * Get ProjectNumber value
     * @return string|null
     */
    public function getProjectNumber()
    {
        return $this->ProjectNumber;
    }
    /**
     * Set ProjectNumber value
     * @param string $projectNumber
     * @return \StructType\InvoiceRowV3
     */
    public function setProjectNumber($projectNumber = null)
    {
        // validation for constraint: string
        if (!is_null($projectNumber) && !is_string($projectNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($projectNumber, true), gettype($projectNumber)), __LINE__);
        }
        $this->ProjectNumber = $projectNumber;
        return $this;
    }
    /**
     * Get BusinessNumber value
     * @return string|null
     */
    public function getBusinessNumber()
    {
        return $this->BusinessNumber;
    }
    /**
     * Set BusinessNumber value
     * @param string $businessNumber
     * @return \StructType\InvoiceRowV3
     */
    public function setBusinessNumber($businessNumber = null)
    {
        // validation for constraint: string
        if (!is_null($businessNumber) && !is_string($businessNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($businessNumber, true), gettype($businessNumber)), __LINE__);
        }
        $this->BusinessNumber = $businessNumber;
        return $this;
    }
    /**
     * Get RowText value
     * @return string|null
     */
    public function getRowText()
    {
        return $this->RowText;
    }
    /**
     * Set RowText value
     * @param string $rowText
     * @return \StructType\InvoiceRowV3
     */
    public function setRowText($rowText = null)
    {
        // validation for constraint: string
        if (!is_null($rowText) && !is_string($rowText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rowText, true), gettype($rowText)), __LINE__);
        }
        $this->RowText = $rowText;
        return $this;
    }
}
