<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InvoiceCustomerContact StructType
 * @subpackage Structs
 */
class InvoiceCustomerContact extends AbstractStructBase
{
    /**
     * The InvoiceID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $InvoiceID;
    /**
     * The CustomerContactID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CustomerContactID;
    /**
     * The CustomerID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CustomerID;
    /**
     * The PublicGroup
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $PublicGroup;
    /**
     * The CanLogin
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $CanLogin;
    /**
     * The PurchaseOrderNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PurchaseOrderNumber;
    /**
     * The ContactReference
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ContactReference;
    /**
     * The Country
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Country;
    /**
     * The ContactNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ContactNumber;
    /**
     * The ContactName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ContactName;
    /**
     * The Address1
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Address1;
    /**
     * The Address2
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Address2;
    /**
     * The Zip
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Zip;
    /**
     * The City
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $City;
    /**
     * The Phone
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Phone;
    /**
     * The Mobile
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Mobile;
    /**
     * The Fax
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Fax;
    /**
     * The Email
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Email;
    /**
     * The Position
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Position;
    /**
     * The Loginpass
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Loginpass;
    /**
     * The Notes
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Notes;
    /**
     * The CustomerGroupName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CustomerGroupName;
    /**
     * The CivicRegistrationNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CivicRegistrationNumber;
    /**
     * The Attribute
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Attribute[]
     */
    public $Attribute;
    /**
     * Constructor method for InvoiceCustomerContact
     * @uses InvoiceCustomerContact::setInvoiceID()
     * @uses InvoiceCustomerContact::setCustomerContactID()
     * @uses InvoiceCustomerContact::setCustomerID()
     * @uses InvoiceCustomerContact::setPublicGroup()
     * @uses InvoiceCustomerContact::setCanLogin()
     * @uses InvoiceCustomerContact::setPurchaseOrderNumber()
     * @uses InvoiceCustomerContact::setContactReference()
     * @uses InvoiceCustomerContact::setCountry()
     * @uses InvoiceCustomerContact::setContactNumber()
     * @uses InvoiceCustomerContact::setContactName()
     * @uses InvoiceCustomerContact::setAddress1()
     * @uses InvoiceCustomerContact::setAddress2()
     * @uses InvoiceCustomerContact::setZip()
     * @uses InvoiceCustomerContact::setCity()
     * @uses InvoiceCustomerContact::setPhone()
     * @uses InvoiceCustomerContact::setMobile()
     * @uses InvoiceCustomerContact::setFax()
     * @uses InvoiceCustomerContact::setEmail()
     * @uses InvoiceCustomerContact::setPosition()
     * @uses InvoiceCustomerContact::setLoginpass()
     * @uses InvoiceCustomerContact::setNotes()
     * @uses InvoiceCustomerContact::setCustomerGroupName()
     * @uses InvoiceCustomerContact::setCivicRegistrationNumber()
     * @uses InvoiceCustomerContact::setAttribute()
     * @param int $invoiceID
     * @param int $customerContactID
     * @param int $customerID
     * @param bool $publicGroup
     * @param bool $canLogin
     * @param string $purchaseOrderNumber
     * @param string $contactReference
     * @param string $country
     * @param string $contactNumber
     * @param string $contactName
     * @param string $address1
     * @param string $address2
     * @param string $zip
     * @param string $city
     * @param string $phone
     * @param string $mobile
     * @param string $fax
     * @param string $email
     * @param string $position
     * @param string $loginpass
     * @param string $notes
     * @param string $customerGroupName
     * @param string $civicRegistrationNumber
     * @param \StructType\Attribute[] $attribute
     */
    public function __construct($invoiceID = null, $customerContactID = null, $customerID = null, $publicGroup = null, $canLogin = null, $purchaseOrderNumber = null, $contactReference = null, $country = null, $contactNumber = null, $contactName = null, $address1 = null, $address2 = null, $zip = null, $city = null, $phone = null, $mobile = null, $fax = null, $email = null, $position = null, $loginpass = null, $notes = null, $customerGroupName = null, $civicRegistrationNumber = null, array $attribute = array())
    {
        $this
            ->setInvoiceID($invoiceID)
            ->setCustomerContactID($customerContactID)
            ->setCustomerID($customerID)
            ->setPublicGroup($publicGroup)
            ->setCanLogin($canLogin)
            ->setPurchaseOrderNumber($purchaseOrderNumber)
            ->setContactReference($contactReference)
            ->setCountry($country)
            ->setContactNumber($contactNumber)
            ->setContactName($contactName)
            ->setAddress1($address1)
            ->setAddress2($address2)
            ->setZip($zip)
            ->setCity($city)
            ->setPhone($phone)
            ->setMobile($mobile)
            ->setFax($fax)
            ->setEmail($email)
            ->setPosition($position)
            ->setLoginpass($loginpass)
            ->setNotes($notes)
            ->setCustomerGroupName($customerGroupName)
            ->setCivicRegistrationNumber($civicRegistrationNumber)
            ->setAttribute($attribute);
    }
    /**
     * Get InvoiceID value
     * @return int
     */
    public function getInvoiceID()
    {
        return $this->InvoiceID;
    }
    /**
     * Set InvoiceID value
     * @param int $invoiceID
     * @return \StructType\InvoiceCustomerContact
     */
    public function setInvoiceID($invoiceID = null)
    {
        // validation for constraint: int
        if (!is_null($invoiceID) && !(is_int($invoiceID) || ctype_digit($invoiceID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($invoiceID, true), gettype($invoiceID)), __LINE__);
        }
        $this->InvoiceID = $invoiceID;
        return $this;
    }
    /**
     * Get CustomerContactID value
     * @return int
     */
    public function getCustomerContactID()
    {
        return $this->CustomerContactID;
    }
    /**
     * Set CustomerContactID value
     * @param int $customerContactID
     * @return \StructType\InvoiceCustomerContact
     */
    public function setCustomerContactID($customerContactID = null)
    {
        // validation for constraint: int
        if (!is_null($customerContactID) && !(is_int($customerContactID) || ctype_digit($customerContactID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($customerContactID, true), gettype($customerContactID)), __LINE__);
        }
        $this->CustomerContactID = $customerContactID;
        return $this;
    }
    /**
     * Get CustomerID value
     * @return int
     */
    public function getCustomerID()
    {
        return $this->CustomerID;
    }
    /**
     * Set CustomerID value
     * @param int $customerID
     * @return \StructType\InvoiceCustomerContact
     */
    public function setCustomerID($customerID = null)
    {
        // validation for constraint: int
        if (!is_null($customerID) && !(is_int($customerID) || ctype_digit($customerID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($customerID, true), gettype($customerID)), __LINE__);
        }
        $this->CustomerID = $customerID;
        return $this;
    }
    /**
     * Get PublicGroup value
     * @return bool
     */
    public function getPublicGroup()
    {
        return $this->PublicGroup;
    }
    /**
     * Set PublicGroup value
     * @param bool $publicGroup
     * @return \StructType\InvoiceCustomerContact
     */
    public function setPublicGroup($publicGroup = null)
    {
        // validation for constraint: boolean
        if (!is_null($publicGroup) && !is_bool($publicGroup)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($publicGroup, true), gettype($publicGroup)), __LINE__);
        }
        $this->PublicGroup = $publicGroup;
        return $this;
    }
    /**
     * Get CanLogin value
     * @return bool
     */
    public function getCanLogin()
    {
        return $this->CanLogin;
    }
    /**
     * Set CanLogin value
     * @param bool $canLogin
     * @return \StructType\InvoiceCustomerContact
     */
    public function setCanLogin($canLogin = null)
    {
        // validation for constraint: boolean
        if (!is_null($canLogin) && !is_bool($canLogin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($canLogin, true), gettype($canLogin)), __LINE__);
        }
        $this->CanLogin = $canLogin;
        return $this;
    }
    /**
     * Get PurchaseOrderNumber value
     * @return string|null
     */
    public function getPurchaseOrderNumber()
    {
        return $this->PurchaseOrderNumber;
    }
    /**
     * Set PurchaseOrderNumber value
     * @param string $purchaseOrderNumber
     * @return \StructType\InvoiceCustomerContact
     */
    public function setPurchaseOrderNumber($purchaseOrderNumber = null)
    {
        // validation for constraint: string
        if (!is_null($purchaseOrderNumber) && !is_string($purchaseOrderNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($purchaseOrderNumber, true), gettype($purchaseOrderNumber)), __LINE__);
        }
        $this->PurchaseOrderNumber = $purchaseOrderNumber;
        return $this;
    }
    /**
     * Get ContactReference value
     * @return string|null
     */
    public function getContactReference()
    {
        return $this->ContactReference;
    }
    /**
     * Set ContactReference value
     * @param string $contactReference
     * @return \StructType\InvoiceCustomerContact
     */
    public function setContactReference($contactReference = null)
    {
        // validation for constraint: string
        if (!is_null($contactReference) && !is_string($contactReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contactReference, true), gettype($contactReference)), __LINE__);
        }
        $this->ContactReference = $contactReference;
        return $this;
    }
    /**
     * Get Country value
     * @return string|null
     */
    public function getCountry()
    {
        return $this->Country;
    }
    /**
     * Set Country value
     * @param string $country
     * @return \StructType\InvoiceCustomerContact
     */
    public function setCountry($country = null)
    {
        // validation for constraint: string
        if (!is_null($country) && !is_string($country)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($country, true), gettype($country)), __LINE__);
        }
        $this->Country = $country;
        return $this;
    }
    /**
     * Get ContactNumber value
     * @return string|null
     */
    public function getContactNumber()
    {
        return $this->ContactNumber;
    }
    /**
     * Set ContactNumber value
     * @param string $contactNumber
     * @return \StructType\InvoiceCustomerContact
     */
    public function setContactNumber($contactNumber = null)
    {
        // validation for constraint: string
        if (!is_null($contactNumber) && !is_string($contactNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contactNumber, true), gettype($contactNumber)), __LINE__);
        }
        $this->ContactNumber = $contactNumber;
        return $this;
    }
    /**
     * Get ContactName value
     * @return string|null
     */
    public function getContactName()
    {
        return $this->ContactName;
    }
    /**
     * Set ContactName value
     * @param string $contactName
     * @return \StructType\InvoiceCustomerContact
     */
    public function setContactName($contactName = null)
    {
        // validation for constraint: string
        if (!is_null($contactName) && !is_string($contactName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contactName, true), gettype($contactName)), __LINE__);
        }
        $this->ContactName = $contactName;
        return $this;
    }
    /**
     * Get Address1 value
     * @return string|null
     */
    public function getAddress1()
    {
        return $this->Address1;
    }
    /**
     * Set Address1 value
     * @param string $address1
     * @return \StructType\InvoiceCustomerContact
     */
    public function setAddress1($address1 = null)
    {
        // validation for constraint: string
        if (!is_null($address1) && !is_string($address1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($address1, true), gettype($address1)), __LINE__);
        }
        $this->Address1 = $address1;
        return $this;
    }
    /**
     * Get Address2 value
     * @return string|null
     */
    public function getAddress2()
    {
        return $this->Address2;
    }
    /**
     * Set Address2 value
     * @param string $address2
     * @return \StructType\InvoiceCustomerContact
     */
    public function setAddress2($address2 = null)
    {
        // validation for constraint: string
        if (!is_null($address2) && !is_string($address2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($address2, true), gettype($address2)), __LINE__);
        }
        $this->Address2 = $address2;
        return $this;
    }
    /**
     * Get Zip value
     * @return string|null
     */
    public function getZip()
    {
        return $this->Zip;
    }
    /**
     * Set Zip value
     * @param string $zip
     * @return \StructType\InvoiceCustomerContact
     */
    public function setZip($zip = null)
    {
        // validation for constraint: string
        if (!is_null($zip) && !is_string($zip)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($zip, true), gettype($zip)), __LINE__);
        }
        $this->Zip = $zip;
        return $this;
    }
    /**
     * Get City value
     * @return string|null
     */
    public function getCity()
    {
        return $this->City;
    }
    /**
     * Set City value
     * @param string $city
     * @return \StructType\InvoiceCustomerContact
     */
    public function setCity($city = null)
    {
        // validation for constraint: string
        if (!is_null($city) && !is_string($city)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($city, true), gettype($city)), __LINE__);
        }
        $this->City = $city;
        return $this;
    }
    /**
     * Get Phone value
     * @return string|null
     */
    public function getPhone()
    {
        return $this->Phone;
    }
    /**
     * Set Phone value
     * @param string $phone
     * @return \StructType\InvoiceCustomerContact
     */
    public function setPhone($phone = null)
    {
        // validation for constraint: string
        if (!is_null($phone) && !is_string($phone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($phone, true), gettype($phone)), __LINE__);
        }
        $this->Phone = $phone;
        return $this;
    }
    /**
     * Get Mobile value
     * @return string|null
     */
    public function getMobile()
    {
        return $this->Mobile;
    }
    /**
     * Set Mobile value
     * @param string $mobile
     * @return \StructType\InvoiceCustomerContact
     */
    public function setMobile($mobile = null)
    {
        // validation for constraint: string
        if (!is_null($mobile) && !is_string($mobile)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mobile, true), gettype($mobile)), __LINE__);
        }
        $this->Mobile = $mobile;
        return $this;
    }
    /**
     * Get Fax value
     * @return string|null
     */
    public function getFax()
    {
        return $this->Fax;
    }
    /**
     * Set Fax value
     * @param string $fax
     * @return \StructType\InvoiceCustomerContact
     */
    public function setFax($fax = null)
    {
        // validation for constraint: string
        if (!is_null($fax) && !is_string($fax)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fax, true), gettype($fax)), __LINE__);
        }
        $this->Fax = $fax;
        return $this;
    }
    /**
     * Get Email value
     * @return string|null
     */
    public function getEmail()
    {
        return $this->Email;
    }
    /**
     * Set Email value
     * @param string $email
     * @return \StructType\InvoiceCustomerContact
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($email, true), gettype($email)), __LINE__);
        }
        $this->Email = $email;
        return $this;
    }
    /**
     * Get Position value
     * @return string|null
     */
    public function getPosition()
    {
        return $this->Position;
    }
    /**
     * Set Position value
     * @param string $position
     * @return \StructType\InvoiceCustomerContact
     */
    public function setPosition($position = null)
    {
        // validation for constraint: string
        if (!is_null($position) && !is_string($position)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($position, true), gettype($position)), __LINE__);
        }
        $this->Position = $position;
        return $this;
    }
    /**
     * Get Loginpass value
     * @return string|null
     */
    public function getLoginpass()
    {
        return $this->Loginpass;
    }
    /**
     * Set Loginpass value
     * @param string $loginpass
     * @return \StructType\InvoiceCustomerContact
     */
    public function setLoginpass($loginpass = null)
    {
        // validation for constraint: string
        if (!is_null($loginpass) && !is_string($loginpass)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($loginpass, true), gettype($loginpass)), __LINE__);
        }
        $this->Loginpass = $loginpass;
        return $this;
    }
    /**
     * Get Notes value
     * @return string|null
     */
    public function getNotes()
    {
        return $this->Notes;
    }
    /**
     * Set Notes value
     * @param string $notes
     * @return \StructType\InvoiceCustomerContact
     */
    public function setNotes($notes = null)
    {
        // validation for constraint: string
        if (!is_null($notes) && !is_string($notes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($notes, true), gettype($notes)), __LINE__);
        }
        $this->Notes = $notes;
        return $this;
    }
    /**
     * Get CustomerGroupName value
     * @return string|null
     */
    public function getCustomerGroupName()
    {
        return $this->CustomerGroupName;
    }
    /**
     * Set CustomerGroupName value
     * @param string $customerGroupName
     * @return \StructType\InvoiceCustomerContact
     */
    public function setCustomerGroupName($customerGroupName = null)
    {
        // validation for constraint: string
        if (!is_null($customerGroupName) && !is_string($customerGroupName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerGroupName, true), gettype($customerGroupName)), __LINE__);
        }
        $this->CustomerGroupName = $customerGroupName;
        return $this;
    }
    /**
     * Get CivicRegistrationNumber value
     * @return string|null
     */
    public function getCivicRegistrationNumber()
    {
        return $this->CivicRegistrationNumber;
    }
    /**
     * Set CivicRegistrationNumber value
     * @param string $civicRegistrationNumber
     * @return \StructType\InvoiceCustomerContact
     */
    public function setCivicRegistrationNumber($civicRegistrationNumber = null)
    {
        // validation for constraint: string
        if (!is_null($civicRegistrationNumber) && !is_string($civicRegistrationNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($civicRegistrationNumber, true), gettype($civicRegistrationNumber)), __LINE__);
        }
        $this->CivicRegistrationNumber = $civicRegistrationNumber;
        return $this;
    }
    /**
     * Get Attribute value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Attribute[]|null
     */
    public function getAttribute()
    {
        return isset($this->Attribute) ? $this->Attribute : null;
    }
    /**
     * This method is responsible for validating the values passed to the setAttribute method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAttribute method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAttributeForArrayConstraintsFromSetAttribute(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $invoiceCustomerContactAttributeItem) {
            // validation for constraint: itemType
            if (!$invoiceCustomerContactAttributeItem instanceof \StructType\Attribute) {
                $invalidValues[] = is_object($invoiceCustomerContactAttributeItem) ? get_class($invoiceCustomerContactAttributeItem) : sprintf('%s(%s)', gettype($invoiceCustomerContactAttributeItem), var_export($invoiceCustomerContactAttributeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Attribute property can only contain items of type \StructType\Attribute, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Attribute value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Attribute[] $attribute
     * @return \StructType\InvoiceCustomerContact
     */
    public function setAttribute(array $attribute = array())
    {
        // validation for constraint: array
        if ('' !== ($attributeArrayErrorMessage = self::validateAttributeForArrayConstraintsFromSetAttribute($attribute))) {
            throw new \InvalidArgumentException($attributeArrayErrorMessage, __LINE__);
        }
        if (is_null($attribute) || (is_array($attribute) && empty($attribute))) {
            unset($this->Attribute);
        } else {
            $this->Attribute = $attribute;
        }
        return $this;
    }
    /**
     * Add item to Attribute value
     * @throws \InvalidArgumentException
     * @param \StructType\Attribute $item
     * @return \StructType\InvoiceCustomerContact
     */
    public function addToAttribute(\StructType\Attribute $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Attribute) {
            throw new \InvalidArgumentException(sprintf('The Attribute property can only contain items of type \StructType\Attribute, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Attribute[] = $item;
        return $this;
    }
}
