<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InvalidateInvoice StructType
 * @subpackage Structs
 */
class InvalidateInvoice extends AbstractStructBase
{
    /**
     * The invoiceID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $invoiceID;
    /**
     * The authToken
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $authToken;
    /**
     * The notes
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $notes;
    /**
     * Constructor method for InvalidateInvoice
     * @uses InvalidateInvoice::setInvoiceID()
     * @uses InvalidateInvoice::setAuthToken()
     * @uses InvalidateInvoice::setNotes()
     * @param int $invoiceID
     * @param string $authToken
     * @param string $notes
     */
    public function __construct($invoiceID = null, $authToken = null, $notes = null)
    {
        $this
            ->setInvoiceID($invoiceID)
            ->setAuthToken($authToken)
            ->setNotes($notes);
    }
    /**
     * Get invoiceID value
     * @return int
     */
    public function getInvoiceID()
    {
        return $this->invoiceID;
    }
    /**
     * Set invoiceID value
     * @param int $invoiceID
     * @return \StructType\InvalidateInvoice
     */
    public function setInvoiceID($invoiceID = null)
    {
        // validation for constraint: int
        if (!is_null($invoiceID) && !(is_int($invoiceID) || ctype_digit($invoiceID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($invoiceID, true), gettype($invoiceID)), __LINE__);
        }
        $this->invoiceID = $invoiceID;
        return $this;
    }
    /**
     * Get authToken value
     * @return string|null
     */
    public function getAuthToken()
    {
        return $this->authToken;
    }
    /**
     * Set authToken value
     * @param string $authToken
     * @return \StructType\InvalidateInvoice
     */
    public function setAuthToken($authToken = null)
    {
        // validation for constraint: string
        if (!is_null($authToken) && !is_string($authToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($authToken, true), gettype($authToken)), __LINE__);
        }
        $this->authToken = $authToken;
        return $this;
    }
    /**
     * Get notes value
     * @return string|null
     */
    public function getNotes()
    {
        return $this->notes;
    }
    /**
     * Set notes value
     * @param string $notes
     * @return \StructType\InvalidateInvoice
     */
    public function setNotes($notes = null)
    {
        // validation for constraint: string
        if (!is_null($notes) && !is_string($notes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($notes, true), gettype($notes)), __LINE__);
        }
        $this->notes = $notes;
        return $this;
    }
}
