<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomerV4 StructType
 * @subpackage Structs
 */
class CustomerV4 extends AbstractStructBase
{
    /**
     * The NoInvoiceFee
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $NoInvoiceFee;
    /**
     * The InvoiceDeliveryMethodID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $InvoiceDeliveryMethodID;
    /**
     * The CanLogin
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $CanLogin;
    /**
     * The DiscountPercent
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $DiscountPercent;
    /**
     * The ParticipantDiscountPercent
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $ParticipantDiscountPercent;
    /**
     * The NotCreditworthy
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $NotCreditworthy;
    /**
     * The CustomerID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CustomerID;
    /**
     * The CustomerGroupID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $CustomerGroupID;
    /**
     * The VatFree
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $VatFree;
    /**
     * The InvoiceEmail
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $InvoiceEmail;
    /**
     * The OurReference
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OurReference;
    /**
     * The EdiReference
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EdiReference;
    /**
     * The Notes
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Notes;
    /**
     * The CustomerNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CustomerNumber;
    /**
     * The CustomerName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CustomerName;
    /**
     * The Address1
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Address1;
    /**
     * The Address2
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Address2;
    /**
     * The Zip
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Zip;
    /**
     * The City
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $City;
    /**
     * The Country
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Country;
    /**
     * The Phone
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Phone;
    /**
     * The Mobile
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Mobile;
    /**
     * The Fax
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Fax;
    /**
     * The Email
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Email;
    /**
     * The Homepage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Homepage;
    /**
     * The InvoiceName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $InvoiceName;
    /**
     * The InvoiceAddress1
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $InvoiceAddress1;
    /**
     * The InvoiceAddress2
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $InvoiceAddress2;
    /**
     * The InvoiceZip
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $InvoiceZip;
    /**
     * The InvoiceCity
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $InvoiceCity;
    /**
     * The InvoiceCountry
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $InvoiceCountry;
    /**
     * The InvoiceOrgnr
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $InvoiceOrgnr;
    /**
     * The CustomerGroupName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CustomerGroupName;
    /**
     * The Password
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Password;
    /**
     * The InvoiceVatnr
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $InvoiceVatnr;
    /**
     * The CustomerReference
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CustomerReference;
    /**
     * The Attribute
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Attribute[]
     */
    public $Attribute;
    /**
     * Constructor method for CustomerV4
     * @uses CustomerV4::setNoInvoiceFee()
     * @uses CustomerV4::setInvoiceDeliveryMethodID()
     * @uses CustomerV4::setCanLogin()
     * @uses CustomerV4::setDiscountPercent()
     * @uses CustomerV4::setParticipantDiscountPercent()
     * @uses CustomerV4::setNotCreditworthy()
     * @uses CustomerV4::setCustomerID()
     * @uses CustomerV4::setCustomerGroupID()
     * @uses CustomerV4::setVatFree()
     * @uses CustomerV4::setInvoiceEmail()
     * @uses CustomerV4::setOurReference()
     * @uses CustomerV4::setEdiReference()
     * @uses CustomerV4::setNotes()
     * @uses CustomerV4::setCustomerNumber()
     * @uses CustomerV4::setCustomerName()
     * @uses CustomerV4::setAddress1()
     * @uses CustomerV4::setAddress2()
     * @uses CustomerV4::setZip()
     * @uses CustomerV4::setCity()
     * @uses CustomerV4::setCountry()
     * @uses CustomerV4::setPhone()
     * @uses CustomerV4::setMobile()
     * @uses CustomerV4::setFax()
     * @uses CustomerV4::setEmail()
     * @uses CustomerV4::setHomepage()
     * @uses CustomerV4::setInvoiceName()
     * @uses CustomerV4::setInvoiceAddress1()
     * @uses CustomerV4::setInvoiceAddress2()
     * @uses CustomerV4::setInvoiceZip()
     * @uses CustomerV4::setInvoiceCity()
     * @uses CustomerV4::setInvoiceCountry()
     * @uses CustomerV4::setInvoiceOrgnr()
     * @uses CustomerV4::setCustomerGroupName()
     * @uses CustomerV4::setPassword()
     * @uses CustomerV4::setInvoiceVatnr()
     * @uses CustomerV4::setCustomerReference()
     * @uses CustomerV4::setAttribute()
     * @param bool $noInvoiceFee
     * @param int $invoiceDeliveryMethodID
     * @param bool $canLogin
     * @param float $discountPercent
     * @param float $participantDiscountPercent
     * @param bool $notCreditworthy
     * @param int $customerID
     * @param int $customerGroupID
     * @param bool $vatFree
     * @param string $invoiceEmail
     * @param string $ourReference
     * @param string $ediReference
     * @param string $notes
     * @param string $customerNumber
     * @param string $customerName
     * @param string $address1
     * @param string $address2
     * @param string $zip
     * @param string $city
     * @param string $country
     * @param string $phone
     * @param string $mobile
     * @param string $fax
     * @param string $email
     * @param string $homepage
     * @param string $invoiceName
     * @param string $invoiceAddress1
     * @param string $invoiceAddress2
     * @param string $invoiceZip
     * @param string $invoiceCity
     * @param string $invoiceCountry
     * @param string $invoiceOrgnr
     * @param string $customerGroupName
     * @param string $password
     * @param string $invoiceVatnr
     * @param string $customerReference
     * @param \StructType\Attribute[] $attribute
     */
    public function __construct($noInvoiceFee = null, $invoiceDeliveryMethodID = null, $canLogin = null, $discountPercent = null, $participantDiscountPercent = null, $notCreditworthy = null, $customerID = null, $customerGroupID = null, $vatFree = null, $invoiceEmail = null, $ourReference = null, $ediReference = null, $notes = null, $customerNumber = null, $customerName = null, $address1 = null, $address2 = null, $zip = null, $city = null, $country = null, $phone = null, $mobile = null, $fax = null, $email = null, $homepage = null, $invoiceName = null, $invoiceAddress1 = null, $invoiceAddress2 = null, $invoiceZip = null, $invoiceCity = null, $invoiceCountry = null, $invoiceOrgnr = null, $customerGroupName = null, $password = null, $invoiceVatnr = null, $customerReference = null, array $attribute = array())
    {
        $this
            ->setNoInvoiceFee($noInvoiceFee)
            ->setInvoiceDeliveryMethodID($invoiceDeliveryMethodID)
            ->setCanLogin($canLogin)
            ->setDiscountPercent($discountPercent)
            ->setParticipantDiscountPercent($participantDiscountPercent)
            ->setNotCreditworthy($notCreditworthy)
            ->setCustomerID($customerID)
            ->setCustomerGroupID($customerGroupID)
            ->setVatFree($vatFree)
            ->setInvoiceEmail($invoiceEmail)
            ->setOurReference($ourReference)
            ->setEdiReference($ediReference)
            ->setNotes($notes)
            ->setCustomerNumber($customerNumber)
            ->setCustomerName($customerName)
            ->setAddress1($address1)
            ->setAddress2($address2)
            ->setZip($zip)
            ->setCity($city)
            ->setCountry($country)
            ->setPhone($phone)
            ->setMobile($mobile)
            ->setFax($fax)
            ->setEmail($email)
            ->setHomepage($homepage)
            ->setInvoiceName($invoiceName)
            ->setInvoiceAddress1($invoiceAddress1)
            ->setInvoiceAddress2($invoiceAddress2)
            ->setInvoiceZip($invoiceZip)
            ->setInvoiceCity($invoiceCity)
            ->setInvoiceCountry($invoiceCountry)
            ->setInvoiceOrgnr($invoiceOrgnr)
            ->setCustomerGroupName($customerGroupName)
            ->setPassword($password)
            ->setInvoiceVatnr($invoiceVatnr)
            ->setCustomerReference($customerReference)
            ->setAttribute($attribute);
    }
    /**
     * Get NoInvoiceFee value
     * @return bool
     */
    public function getNoInvoiceFee()
    {
        return $this->NoInvoiceFee;
    }
    /**
     * Set NoInvoiceFee value
     * @param bool $noInvoiceFee
     * @return \StructType\CustomerV4
     */
    public function setNoInvoiceFee($noInvoiceFee = null)
    {
        // validation for constraint: boolean
        if (!is_null($noInvoiceFee) && !is_bool($noInvoiceFee)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($noInvoiceFee, true), gettype($noInvoiceFee)), __LINE__);
        }
        $this->NoInvoiceFee = $noInvoiceFee;
        return $this;
    }
    /**
     * Get InvoiceDeliveryMethodID value
     * @return int
     */
    public function getInvoiceDeliveryMethodID()
    {
        return $this->InvoiceDeliveryMethodID;
    }
    /**
     * Set InvoiceDeliveryMethodID value
     * @param int $invoiceDeliveryMethodID
     * @return \StructType\CustomerV4
     */
    public function setInvoiceDeliveryMethodID($invoiceDeliveryMethodID = null)
    {
        // validation for constraint: int
        if (!is_null($invoiceDeliveryMethodID) && !(is_int($invoiceDeliveryMethodID) || ctype_digit($invoiceDeliveryMethodID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($invoiceDeliveryMethodID, true), gettype($invoiceDeliveryMethodID)), __LINE__);
        }
        $this->InvoiceDeliveryMethodID = $invoiceDeliveryMethodID;
        return $this;
    }
    /**
     * Get CanLogin value
     * @return bool
     */
    public function getCanLogin()
    {
        return $this->CanLogin;
    }
    /**
     * Set CanLogin value
     * @param bool $canLogin
     * @return \StructType\CustomerV4
     */
    public function setCanLogin($canLogin = null)
    {
        // validation for constraint: boolean
        if (!is_null($canLogin) && !is_bool($canLogin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($canLogin, true), gettype($canLogin)), __LINE__);
        }
        $this->CanLogin = $canLogin;
        return $this;
    }
    /**
     * Get DiscountPercent value
     * @return float
     */
    public function getDiscountPercent()
    {
        return $this->DiscountPercent;
    }
    /**
     * Set DiscountPercent value
     * @param float $discountPercent
     * @return \StructType\CustomerV4
     */
    public function setDiscountPercent($discountPercent = null)
    {
        // validation for constraint: float
        if (!is_null($discountPercent) && !(is_float($discountPercent) || is_numeric($discountPercent))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($discountPercent, true), gettype($discountPercent)), __LINE__);
        }
        $this->DiscountPercent = $discountPercent;
        return $this;
    }
    /**
     * Get ParticipantDiscountPercent value
     * @return float
     */
    public function getParticipantDiscountPercent()
    {
        return $this->ParticipantDiscountPercent;
    }
    /**
     * Set ParticipantDiscountPercent value
     * @param float $participantDiscountPercent
     * @return \StructType\CustomerV4
     */
    public function setParticipantDiscountPercent($participantDiscountPercent = null)
    {
        // validation for constraint: float
        if (!is_null($participantDiscountPercent) && !(is_float($participantDiscountPercent) || is_numeric($participantDiscountPercent))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($participantDiscountPercent, true), gettype($participantDiscountPercent)), __LINE__);
        }
        $this->ParticipantDiscountPercent = $participantDiscountPercent;
        return $this;
    }
    /**
     * Get NotCreditworthy value
     * @return bool
     */
    public function getNotCreditworthy()
    {
        return $this->NotCreditworthy;
    }
    /**
     * Set NotCreditworthy value
     * @param bool $notCreditworthy
     * @return \StructType\CustomerV4
     */
    public function setNotCreditworthy($notCreditworthy = null)
    {
        // validation for constraint: boolean
        if (!is_null($notCreditworthy) && !is_bool($notCreditworthy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($notCreditworthy, true), gettype($notCreditworthy)), __LINE__);
        }
        $this->NotCreditworthy = $notCreditworthy;
        return $this;
    }
    /**
     * Get CustomerID value
     * @return int
     */
    public function getCustomerID()
    {
        return $this->CustomerID;
    }
    /**
     * Set CustomerID value
     * @param int $customerID
     * @return \StructType\CustomerV4
     */
    public function setCustomerID($customerID = null)
    {
        // validation for constraint: int
        if (!is_null($customerID) && !(is_int($customerID) || ctype_digit($customerID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($customerID, true), gettype($customerID)), __LINE__);
        }
        $this->CustomerID = $customerID;
        return $this;
    }
    /**
     * Get CustomerGroupID value
     * @return int
     */
    public function getCustomerGroupID()
    {
        return $this->CustomerGroupID;
    }
    /**
     * Set CustomerGroupID value
     * @param int $customerGroupID
     * @return \StructType\CustomerV4
     */
    public function setCustomerGroupID($customerGroupID = null)
    {
        // validation for constraint: int
        if (!is_null($customerGroupID) && !(is_int($customerGroupID) || ctype_digit($customerGroupID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($customerGroupID, true), gettype($customerGroupID)), __LINE__);
        }
        $this->CustomerGroupID = $customerGroupID;
        return $this;
    }
    /**
     * Get VatFree value
     * @return bool
     */
    public function getVatFree()
    {
        return $this->VatFree;
    }
    /**
     * Set VatFree value
     * @param bool $vatFree
     * @return \StructType\CustomerV4
     */
    public function setVatFree($vatFree = null)
    {
        // validation for constraint: boolean
        if (!is_null($vatFree) && !is_bool($vatFree)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($vatFree, true), gettype($vatFree)), __LINE__);
        }
        $this->VatFree = $vatFree;
        return $this;
    }
    /**
     * Get InvoiceEmail value
     * @return string|null
     */
    public function getInvoiceEmail()
    {
        return $this->InvoiceEmail;
    }
    /**
     * Set InvoiceEmail value
     * @param string $invoiceEmail
     * @return \StructType\CustomerV4
     */
    public function setInvoiceEmail($invoiceEmail = null)
    {
        // validation for constraint: string
        if (!is_null($invoiceEmail) && !is_string($invoiceEmail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoiceEmail, true), gettype($invoiceEmail)), __LINE__);
        }
        $this->InvoiceEmail = $invoiceEmail;
        return $this;
    }
    /**
     * Get OurReference value
     * @return string|null
     */
    public function getOurReference()
    {
        return $this->OurReference;
    }
    /**
     * Set OurReference value
     * @param string $ourReference
     * @return \StructType\CustomerV4
     */
    public function setOurReference($ourReference = null)
    {
        // validation for constraint: string
        if (!is_null($ourReference) && !is_string($ourReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ourReference, true), gettype($ourReference)), __LINE__);
        }
        $this->OurReference = $ourReference;
        return $this;
    }
    /**
     * Get EdiReference value
     * @return string|null
     */
    public function getEdiReference()
    {
        return $this->EdiReference;
    }
    /**
     * Set EdiReference value
     * @param string $ediReference
     * @return \StructType\CustomerV4
     */
    public function setEdiReference($ediReference = null)
    {
        // validation for constraint: string
        if (!is_null($ediReference) && !is_string($ediReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ediReference, true), gettype($ediReference)), __LINE__);
        }
        $this->EdiReference = $ediReference;
        return $this;
    }
    /**
     * Get Notes value
     * @return string|null
     */
    public function getNotes()
    {
        return $this->Notes;
    }
    /**
     * Set Notes value
     * @param string $notes
     * @return \StructType\CustomerV4
     */
    public function setNotes($notes = null)
    {
        // validation for constraint: string
        if (!is_null($notes) && !is_string($notes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($notes, true), gettype($notes)), __LINE__);
        }
        $this->Notes = $notes;
        return $this;
    }
    /**
     * Get CustomerNumber value
     * @return string|null
     */
    public function getCustomerNumber()
    {
        return $this->CustomerNumber;
    }
    /**
     * Set CustomerNumber value
     * @param string $customerNumber
     * @return \StructType\CustomerV4
     */
    public function setCustomerNumber($customerNumber = null)
    {
        // validation for constraint: string
        if (!is_null($customerNumber) && !is_string($customerNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerNumber, true), gettype($customerNumber)), __LINE__);
        }
        $this->CustomerNumber = $customerNumber;
        return $this;
    }
    /**
     * Get CustomerName value
     * @return string|null
     */
    public function getCustomerName()
    {
        return $this->CustomerName;
    }
    /**
     * Set CustomerName value
     * @param string $customerName
     * @return \StructType\CustomerV4
     */
    public function setCustomerName($customerName = null)
    {
        // validation for constraint: string
        if (!is_null($customerName) && !is_string($customerName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerName, true), gettype($customerName)), __LINE__);
        }
        $this->CustomerName = $customerName;
        return $this;
    }
    /**
     * Get Address1 value
     * @return string|null
     */
    public function getAddress1()
    {
        return $this->Address1;
    }
    /**
     * Set Address1 value
     * @param string $address1
     * @return \StructType\CustomerV4
     */
    public function setAddress1($address1 = null)
    {
        // validation for constraint: string
        if (!is_null($address1) && !is_string($address1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($address1, true), gettype($address1)), __LINE__);
        }
        $this->Address1 = $address1;
        return $this;
    }
    /**
     * Get Address2 value
     * @return string|null
     */
    public function getAddress2()
    {
        return $this->Address2;
    }
    /**
     * Set Address2 value
     * @param string $address2
     * @return \StructType\CustomerV4
     */
    public function setAddress2($address2 = null)
    {
        // validation for constraint: string
        if (!is_null($address2) && !is_string($address2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($address2, true), gettype($address2)), __LINE__);
        }
        $this->Address2 = $address2;
        return $this;
    }
    /**
     * Get Zip value
     * @return string|null
     */
    public function getZip()
    {
        return $this->Zip;
    }
    /**
     * Set Zip value
     * @param string $zip
     * @return \StructType\CustomerV4
     */
    public function setZip($zip = null)
    {
        // validation for constraint: string
        if (!is_null($zip) && !is_string($zip)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($zip, true), gettype($zip)), __LINE__);
        }
        $this->Zip = $zip;
        return $this;
    }
    /**
     * Get City value
     * @return string|null
     */
    public function getCity()
    {
        return $this->City;
    }
    /**
     * Set City value
     * @param string $city
     * @return \StructType\CustomerV4
     */
    public function setCity($city = null)
    {
        // validation for constraint: string
        if (!is_null($city) && !is_string($city)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($city, true), gettype($city)), __LINE__);
        }
        $this->City = $city;
        return $this;
    }
    /**
     * Get Country value
     * @return string|null
     */
    public function getCountry()
    {
        return $this->Country;
    }
    /**
     * Set Country value
     * @param string $country
     * @return \StructType\CustomerV4
     */
    public function setCountry($country = null)
    {
        // validation for constraint: string
        if (!is_null($country) && !is_string($country)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($country, true), gettype($country)), __LINE__);
        }
        $this->Country = $country;
        return $this;
    }
    /**
     * Get Phone value
     * @return string|null
     */
    public function getPhone()
    {
        return $this->Phone;
    }
    /**
     * Set Phone value
     * @param string $phone
     * @return \StructType\CustomerV4
     */
    public function setPhone($phone = null)
    {
        // validation for constraint: string
        if (!is_null($phone) && !is_string($phone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($phone, true), gettype($phone)), __LINE__);
        }
        $this->Phone = $phone;
        return $this;
    }
    /**
     * Get Mobile value
     * @return string|null
     */
    public function getMobile()
    {
        return $this->Mobile;
    }
    /**
     * Set Mobile value
     * @param string $mobile
     * @return \StructType\CustomerV4
     */
    public function setMobile($mobile = null)
    {
        // validation for constraint: string
        if (!is_null($mobile) && !is_string($mobile)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mobile, true), gettype($mobile)), __LINE__);
        }
        $this->Mobile = $mobile;
        return $this;
    }
    /**
     * Get Fax value
     * @return string|null
     */
    public function getFax()
    {
        return $this->Fax;
    }
    /**
     * Set Fax value
     * @param string $fax
     * @return \StructType\CustomerV4
     */
    public function setFax($fax = null)
    {
        // validation for constraint: string
        if (!is_null($fax) && !is_string($fax)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fax, true), gettype($fax)), __LINE__);
        }
        $this->Fax = $fax;
        return $this;
    }
    /**
     * Get Email value
     * @return string|null
     */
    public function getEmail()
    {
        return $this->Email;
    }
    /**
     * Set Email value
     * @param string $email
     * @return \StructType\CustomerV4
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($email, true), gettype($email)), __LINE__);
        }
        $this->Email = $email;
        return $this;
    }
    /**
     * Get Homepage value
     * @return string|null
     */
    public function getHomepage()
    {
        return $this->Homepage;
    }
    /**
     * Set Homepage value
     * @param string $homepage
     * @return \StructType\CustomerV4
     */
    public function setHomepage($homepage = null)
    {
        // validation for constraint: string
        if (!is_null($homepage) && !is_string($homepage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($homepage, true), gettype($homepage)), __LINE__);
        }
        $this->Homepage = $homepage;
        return $this;
    }
    /**
     * Get InvoiceName value
     * @return string|null
     */
    public function getInvoiceName()
    {
        return $this->InvoiceName;
    }
    /**
     * Set InvoiceName value
     * @param string $invoiceName
     * @return \StructType\CustomerV4
     */
    public function setInvoiceName($invoiceName = null)
    {
        // validation for constraint: string
        if (!is_null($invoiceName) && !is_string($invoiceName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoiceName, true), gettype($invoiceName)), __LINE__);
        }
        $this->InvoiceName = $invoiceName;
        return $this;
    }
    /**
     * Get InvoiceAddress1 value
     * @return string|null
     */
    public function getInvoiceAddress1()
    {
        return $this->InvoiceAddress1;
    }
    /**
     * Set InvoiceAddress1 value
     * @param string $invoiceAddress1
     * @return \StructType\CustomerV4
     */
    public function setInvoiceAddress1($invoiceAddress1 = null)
    {
        // validation for constraint: string
        if (!is_null($invoiceAddress1) && !is_string($invoiceAddress1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoiceAddress1, true), gettype($invoiceAddress1)), __LINE__);
        }
        $this->InvoiceAddress1 = $invoiceAddress1;
        return $this;
    }
    /**
     * Get InvoiceAddress2 value
     * @return string|null
     */
    public function getInvoiceAddress2()
    {
        return $this->InvoiceAddress2;
    }
    /**
     * Set InvoiceAddress2 value
     * @param string $invoiceAddress2
     * @return \StructType\CustomerV4
     */
    public function setInvoiceAddress2($invoiceAddress2 = null)
    {
        // validation for constraint: string
        if (!is_null($invoiceAddress2) && !is_string($invoiceAddress2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoiceAddress2, true), gettype($invoiceAddress2)), __LINE__);
        }
        $this->InvoiceAddress2 = $invoiceAddress2;
        return $this;
    }
    /**
     * Get InvoiceZip value
     * @return string|null
     */
    public function getInvoiceZip()
    {
        return $this->InvoiceZip;
    }
    /**
     * Set InvoiceZip value
     * @param string $invoiceZip
     * @return \StructType\CustomerV4
     */
    public function setInvoiceZip($invoiceZip = null)
    {
        // validation for constraint: string
        if (!is_null($invoiceZip) && !is_string($invoiceZip)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoiceZip, true), gettype($invoiceZip)), __LINE__);
        }
        $this->InvoiceZip = $invoiceZip;
        return $this;
    }
    /**
     * Get InvoiceCity value
     * @return string|null
     */
    public function getInvoiceCity()
    {
        return $this->InvoiceCity;
    }
    /**
     * Set InvoiceCity value
     * @param string $invoiceCity
     * @return \StructType\CustomerV4
     */
    public function setInvoiceCity($invoiceCity = null)
    {
        // validation for constraint: string
        if (!is_null($invoiceCity) && !is_string($invoiceCity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoiceCity, true), gettype($invoiceCity)), __LINE__);
        }
        $this->InvoiceCity = $invoiceCity;
        return $this;
    }
    /**
     * Get InvoiceCountry value
     * @return string|null
     */
    public function getInvoiceCountry()
    {
        return $this->InvoiceCountry;
    }
    /**
     * Set InvoiceCountry value
     * @param string $invoiceCountry
     * @return \StructType\CustomerV4
     */
    public function setInvoiceCountry($invoiceCountry = null)
    {
        // validation for constraint: string
        if (!is_null($invoiceCountry) && !is_string($invoiceCountry)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoiceCountry, true), gettype($invoiceCountry)), __LINE__);
        }
        $this->InvoiceCountry = $invoiceCountry;
        return $this;
    }
    /**
     * Get InvoiceOrgnr value
     * @return string|null
     */
    public function getInvoiceOrgnr()
    {
        return $this->InvoiceOrgnr;
    }
    /**
     * Set InvoiceOrgnr value
     * @param string $invoiceOrgnr
     * @return \StructType\CustomerV4
     */
    public function setInvoiceOrgnr($invoiceOrgnr = null)
    {
        // validation for constraint: string
        if (!is_null($invoiceOrgnr) && !is_string($invoiceOrgnr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoiceOrgnr, true), gettype($invoiceOrgnr)), __LINE__);
        }
        $this->InvoiceOrgnr = $invoiceOrgnr;
        return $this;
    }
    /**
     * Get CustomerGroupName value
     * @return string|null
     */
    public function getCustomerGroupName()
    {
        return $this->CustomerGroupName;
    }
    /**
     * Set CustomerGroupName value
     * @param string $customerGroupName
     * @return \StructType\CustomerV4
     */
    public function setCustomerGroupName($customerGroupName = null)
    {
        // validation for constraint: string
        if (!is_null($customerGroupName) && !is_string($customerGroupName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerGroupName, true), gettype($customerGroupName)), __LINE__);
        }
        $this->CustomerGroupName = $customerGroupName;
        return $this;
    }
    /**
     * Get Password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->Password;
    }
    /**
     * Set Password value
     * @param string $password
     * @return \StructType\CustomerV4
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($password, true), gettype($password)), __LINE__);
        }
        $this->Password = $password;
        return $this;
    }
    /**
     * Get InvoiceVatnr value
     * @return string|null
     */
    public function getInvoiceVatnr()
    {
        return $this->InvoiceVatnr;
    }
    /**
     * Set InvoiceVatnr value
     * @param string $invoiceVatnr
     * @return \StructType\CustomerV4
     */
    public function setInvoiceVatnr($invoiceVatnr = null)
    {
        // validation for constraint: string
        if (!is_null($invoiceVatnr) && !is_string($invoiceVatnr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoiceVatnr, true), gettype($invoiceVatnr)), __LINE__);
        }
        $this->InvoiceVatnr = $invoiceVatnr;
        return $this;
    }
    /**
     * Get CustomerReference value
     * @return string|null
     */
    public function getCustomerReference()
    {
        return $this->CustomerReference;
    }
    /**
     * Set CustomerReference value
     * @param string $customerReference
     * @return \StructType\CustomerV4
     */
    public function setCustomerReference($customerReference = null)
    {
        // validation for constraint: string
        if (!is_null($customerReference) && !is_string($customerReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerReference, true), gettype($customerReference)), __LINE__);
        }
        $this->CustomerReference = $customerReference;
        return $this;
    }
    /**
     * Get Attribute value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Attribute[]|null
     */
    public function getAttribute()
    {
        return isset($this->Attribute) ? $this->Attribute : null;
    }
    /**
     * This method is responsible for validating the values passed to the setAttribute method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAttribute method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAttributeForArrayConstraintsFromSetAttribute(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $customerV4AttributeItem) {
            // validation for constraint: itemType
            if (!$customerV4AttributeItem instanceof \StructType\Attribute) {
                $invalidValues[] = is_object($customerV4AttributeItem) ? get_class($customerV4AttributeItem) : sprintf('%s(%s)', gettype($customerV4AttributeItem), var_export($customerV4AttributeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Attribute property can only contain items of type \StructType\Attribute, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Attribute value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Attribute[] $attribute
     * @return \StructType\CustomerV4
     */
    public function setAttribute(array $attribute = array())
    {
        // validation for constraint: array
        if ('' !== ($attributeArrayErrorMessage = self::validateAttributeForArrayConstraintsFromSetAttribute($attribute))) {
            throw new \InvalidArgumentException($attributeArrayErrorMessage, __LINE__);
        }
        if (is_null($attribute) || (is_array($attribute) && empty($attribute))) {
            unset($this->Attribute);
        } else {
            $this->Attribute = $attribute;
        }
        return $this;
    }
    /**
     * Add item to Attribute value
     * @throws \InvalidArgumentException
     * @param \StructType\Attribute $item
     * @return \StructType\CustomerV4
     */
    public function addToAttribute(\StructType\Attribute $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Attribute) {
            throw new \InvalidArgumentException(sprintf('The Attribute property can only contain items of type \StructType\Attribute, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Attribute[] = $item;
        return $this;
    }
}
