<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Customer StructType
 * @subpackage Structs
 */
class Customer extends AbstractStructBase
{
    /**
     * The CustomerID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CustomerID;
    /**
     * The CustomerGroupID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $CustomerGroupID;
    /**
     * The VatFree
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $VatFree;
    /**
     * The CustomerNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CustomerNumber;
    /**
     * The CustomerName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CustomerName;
    /**
     * The Address1
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Address1;
    /**
     * The Address2
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Address2;
    /**
     * The Zip
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Zip;
    /**
     * The City
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $City;
    /**
     * The Country
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Country;
    /**
     * The Phone
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Phone;
    /**
     * The Mobile
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Mobile;
    /**
     * The Fax
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Fax;
    /**
     * The Email
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Email;
    /**
     * The Homepage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Homepage;
    /**
     * The InvoiceName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $InvoiceName;
    /**
     * The InvoiceAddress1
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $InvoiceAddress1;
    /**
     * The InvoiceAddress2
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $InvoiceAddress2;
    /**
     * The InvoiceZip
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $InvoiceZip;
    /**
     * The InvoiceCity
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $InvoiceCity;
    /**
     * The InvoiceCountry
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $InvoiceCountry;
    /**
     * The InvoiceOrgnr
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $InvoiceOrgnr;
    /**
     * The CustomerGroupName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CustomerGroupName;
    /**
     * The Password
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Password;
    /**
     * The InvoiceVatnr
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $InvoiceVatnr;
    /**
     * The CustomerReference
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CustomerReference;
    /**
     * The Attribute
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Attribute[]
     */
    public $Attribute;
    /**
     * Constructor method for Customer
     * @uses Customer::setCustomerID()
     * @uses Customer::setCustomerGroupID()
     * @uses Customer::setVatFree()
     * @uses Customer::setCustomerNumber()
     * @uses Customer::setCustomerName()
     * @uses Customer::setAddress1()
     * @uses Customer::setAddress2()
     * @uses Customer::setZip()
     * @uses Customer::setCity()
     * @uses Customer::setCountry()
     * @uses Customer::setPhone()
     * @uses Customer::setMobile()
     * @uses Customer::setFax()
     * @uses Customer::setEmail()
     * @uses Customer::setHomepage()
     * @uses Customer::setInvoiceName()
     * @uses Customer::setInvoiceAddress1()
     * @uses Customer::setInvoiceAddress2()
     * @uses Customer::setInvoiceZip()
     * @uses Customer::setInvoiceCity()
     * @uses Customer::setInvoiceCountry()
     * @uses Customer::setInvoiceOrgnr()
     * @uses Customer::setCustomerGroupName()
     * @uses Customer::setPassword()
     * @uses Customer::setInvoiceVatnr()
     * @uses Customer::setCustomerReference()
     * @uses Customer::setAttribute()
     * @param int $customerID
     * @param int $customerGroupID
     * @param bool $vatFree
     * @param string $customerNumber
     * @param string $customerName
     * @param string $address1
     * @param string $address2
     * @param string $zip
     * @param string $city
     * @param string $country
     * @param string $phone
     * @param string $mobile
     * @param string $fax
     * @param string $email
     * @param string $homepage
     * @param string $invoiceName
     * @param string $invoiceAddress1
     * @param string $invoiceAddress2
     * @param string $invoiceZip
     * @param string $invoiceCity
     * @param string $invoiceCountry
     * @param string $invoiceOrgnr
     * @param string $customerGroupName
     * @param string $password
     * @param string $invoiceVatnr
     * @param string $customerReference
     * @param \StructType\Attribute[] $attribute
     */
    public function __construct($customerID = null, $customerGroupID = null, $vatFree = null, $customerNumber = null, $customerName = null, $address1 = null, $address2 = null, $zip = null, $city = null, $country = null, $phone = null, $mobile = null, $fax = null, $email = null, $homepage = null, $invoiceName = null, $invoiceAddress1 = null, $invoiceAddress2 = null, $invoiceZip = null, $invoiceCity = null, $invoiceCountry = null, $invoiceOrgnr = null, $customerGroupName = null, $password = null, $invoiceVatnr = null, $customerReference = null, array $attribute = array())
    {
        $this
            ->setCustomerID($customerID)
            ->setCustomerGroupID($customerGroupID)
            ->setVatFree($vatFree)
            ->setCustomerNumber($customerNumber)
            ->setCustomerName($customerName)
            ->setAddress1($address1)
            ->setAddress2($address2)
            ->setZip($zip)
            ->setCity($city)
            ->setCountry($country)
            ->setPhone($phone)
            ->setMobile($mobile)
            ->setFax($fax)
            ->setEmail($email)
            ->setHomepage($homepage)
            ->setInvoiceName($invoiceName)
            ->setInvoiceAddress1($invoiceAddress1)
            ->setInvoiceAddress2($invoiceAddress2)
            ->setInvoiceZip($invoiceZip)
            ->setInvoiceCity($invoiceCity)
            ->setInvoiceCountry($invoiceCountry)
            ->setInvoiceOrgnr($invoiceOrgnr)
            ->setCustomerGroupName($customerGroupName)
            ->setPassword($password)
            ->setInvoiceVatnr($invoiceVatnr)
            ->setCustomerReference($customerReference)
            ->setAttribute($attribute);
    }
    /**
     * Get CustomerID value
     * @return int
     */
    public function getCustomerID()
    {
        return $this->CustomerID;
    }
    /**
     * Set CustomerID value
     * @param int $customerID
     * @return \StructType\Customer
     */
    public function setCustomerID($customerID = null)
    {
        // validation for constraint: int
        if (!is_null($customerID) && !(is_int($customerID) || ctype_digit($customerID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($customerID, true), gettype($customerID)), __LINE__);
        }
        $this->CustomerID = $customerID;
        return $this;
    }
    /**
     * Get CustomerGroupID value
     * @return int
     */
    public function getCustomerGroupID()
    {
        return $this->CustomerGroupID;
    }
    /**
     * Set CustomerGroupID value
     * @param int $customerGroupID
     * @return \StructType\Customer
     */
    public function setCustomerGroupID($customerGroupID = null)
    {
        // validation for constraint: int
        if (!is_null($customerGroupID) && !(is_int($customerGroupID) || ctype_digit($customerGroupID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($customerGroupID, true), gettype($customerGroupID)), __LINE__);
        }
        $this->CustomerGroupID = $customerGroupID;
        return $this;
    }
    /**
     * Get VatFree value
     * @return bool
     */
    public function getVatFree()
    {
        return $this->VatFree;
    }
    /**
     * Set VatFree value
     * @param bool $vatFree
     * @return \StructType\Customer
     */
    public function setVatFree($vatFree = null)
    {
        // validation for constraint: boolean
        if (!is_null($vatFree) && !is_bool($vatFree)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($vatFree, true), gettype($vatFree)), __LINE__);
        }
        $this->VatFree = $vatFree;
        return $this;
    }
    /**
     * Get CustomerNumber value
     * @return string|null
     */
    public function getCustomerNumber()
    {
        return $this->CustomerNumber;
    }
    /**
     * Set CustomerNumber value
     * @param string $customerNumber
     * @return \StructType\Customer
     */
    public function setCustomerNumber($customerNumber = null)
    {
        // validation for constraint: string
        if (!is_null($customerNumber) && !is_string($customerNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerNumber, true), gettype($customerNumber)), __LINE__);
        }
        $this->CustomerNumber = $customerNumber;
        return $this;
    }
    /**
     * Get CustomerName value
     * @return string|null
     */
    public function getCustomerName()
    {
        return $this->CustomerName;
    }
    /**
     * Set CustomerName value
     * @param string $customerName
     * @return \StructType\Customer
     */
    public function setCustomerName($customerName = null)
    {
        // validation for constraint: string
        if (!is_null($customerName) && !is_string($customerName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerName, true), gettype($customerName)), __LINE__);
        }
        $this->CustomerName = $customerName;
        return $this;
    }
    /**
     * Get Address1 value
     * @return string|null
     */
    public function getAddress1()
    {
        return $this->Address1;
    }
    /**
     * Set Address1 value
     * @param string $address1
     * @return \StructType\Customer
     */
    public function setAddress1($address1 = null)
    {
        // validation for constraint: string
        if (!is_null($address1) && !is_string($address1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($address1, true), gettype($address1)), __LINE__);
        }
        $this->Address1 = $address1;
        return $this;
    }
    /**
     * Get Address2 value
     * @return string|null
     */
    public function getAddress2()
    {
        return $this->Address2;
    }
    /**
     * Set Address2 value
     * @param string $address2
     * @return \StructType\Customer
     */
    public function setAddress2($address2 = null)
    {
        // validation for constraint: string
        if (!is_null($address2) && !is_string($address2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($address2, true), gettype($address2)), __LINE__);
        }
        $this->Address2 = $address2;
        return $this;
    }
    /**
     * Get Zip value
     * @return string|null
     */
    public function getZip()
    {
        return $this->Zip;
    }
    /**
     * Set Zip value
     * @param string $zip
     * @return \StructType\Customer
     */
    public function setZip($zip = null)
    {
        // validation for constraint: string
        if (!is_null($zip) && !is_string($zip)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($zip, true), gettype($zip)), __LINE__);
        }
        $this->Zip = $zip;
        return $this;
    }
    /**
     * Get City value
     * @return string|null
     */
    public function getCity()
    {
        return $this->City;
    }
    /**
     * Set City value
     * @param string $city
     * @return \StructType\Customer
     */
    public function setCity($city = null)
    {
        // validation for constraint: string
        if (!is_null($city) && !is_string($city)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($city, true), gettype($city)), __LINE__);
        }
        $this->City = $city;
        return $this;
    }
    /**
     * Get Country value
     * @return string|null
     */
    public function getCountry()
    {
        return $this->Country;
    }
    /**
     * Set Country value
     * @param string $country
     * @return \StructType\Customer
     */
    public function setCountry($country = null)
    {
        // validation for constraint: string
        if (!is_null($country) && !is_string($country)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($country, true), gettype($country)), __LINE__);
        }
        $this->Country = $country;
        return $this;
    }
    /**
     * Get Phone value
     * @return string|null
     */
    public function getPhone()
    {
        return $this->Phone;
    }
    /**
     * Set Phone value
     * @param string $phone
     * @return \StructType\Customer
     */
    public function setPhone($phone = null)
    {
        // validation for constraint: string
        if (!is_null($phone) && !is_string($phone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($phone, true), gettype($phone)), __LINE__);
        }
        $this->Phone = $phone;
        return $this;
    }
    /**
     * Get Mobile value
     * @return string|null
     */
    public function getMobile()
    {
        return $this->Mobile;
    }
    /**
     * Set Mobile value
     * @param string $mobile
     * @return \StructType\Customer
     */
    public function setMobile($mobile = null)
    {
        // validation for constraint: string
        if (!is_null($mobile) && !is_string($mobile)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mobile, true), gettype($mobile)), __LINE__);
        }
        $this->Mobile = $mobile;
        return $this;
    }
    /**
     * Get Fax value
     * @return string|null
     */
    public function getFax()
    {
        return $this->Fax;
    }
    /**
     * Set Fax value
     * @param string $fax
     * @return \StructType\Customer
     */
    public function setFax($fax = null)
    {
        // validation for constraint: string
        if (!is_null($fax) && !is_string($fax)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fax, true), gettype($fax)), __LINE__);
        }
        $this->Fax = $fax;
        return $this;
    }
    /**
     * Get Email value
     * @return string|null
     */
    public function getEmail()
    {
        return $this->Email;
    }
    /**
     * Set Email value
     * @param string $email
     * @return \StructType\Customer
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($email, true), gettype($email)), __LINE__);
        }
        $this->Email = $email;
        return $this;
    }
    /**
     * Get Homepage value
     * @return string|null
     */
    public function getHomepage()
    {
        return $this->Homepage;
    }
    /**
     * Set Homepage value
     * @param string $homepage
     * @return \StructType\Customer
     */
    public function setHomepage($homepage = null)
    {
        // validation for constraint: string
        if (!is_null($homepage) && !is_string($homepage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($homepage, true), gettype($homepage)), __LINE__);
        }
        $this->Homepage = $homepage;
        return $this;
    }
    /**
     * Get InvoiceName value
     * @return string|null
     */
    public function getInvoiceName()
    {
        return $this->InvoiceName;
    }
    /**
     * Set InvoiceName value
     * @param string $invoiceName
     * @return \StructType\Customer
     */
    public function setInvoiceName($invoiceName = null)
    {
        // validation for constraint: string
        if (!is_null($invoiceName) && !is_string($invoiceName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoiceName, true), gettype($invoiceName)), __LINE__);
        }
        $this->InvoiceName = $invoiceName;
        return $this;
    }
    /**
     * Get InvoiceAddress1 value
     * @return string|null
     */
    public function getInvoiceAddress1()
    {
        return $this->InvoiceAddress1;
    }
    /**
     * Set InvoiceAddress1 value
     * @param string $invoiceAddress1
     * @return \StructType\Customer
     */
    public function setInvoiceAddress1($invoiceAddress1 = null)
    {
        // validation for constraint: string
        if (!is_null($invoiceAddress1) && !is_string($invoiceAddress1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoiceAddress1, true), gettype($invoiceAddress1)), __LINE__);
        }
        $this->InvoiceAddress1 = $invoiceAddress1;
        return $this;
    }
    /**
     * Get InvoiceAddress2 value
     * @return string|null
     */
    public function getInvoiceAddress2()
    {
        return $this->InvoiceAddress2;
    }
    /**
     * Set InvoiceAddress2 value
     * @param string $invoiceAddress2
     * @return \StructType\Customer
     */
    public function setInvoiceAddress2($invoiceAddress2 = null)
    {
        // validation for constraint: string
        if (!is_null($invoiceAddress2) && !is_string($invoiceAddress2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoiceAddress2, true), gettype($invoiceAddress2)), __LINE__);
        }
        $this->InvoiceAddress2 = $invoiceAddress2;
        return $this;
    }
    /**
     * Get InvoiceZip value
     * @return string|null
     */
    public function getInvoiceZip()
    {
        return $this->InvoiceZip;
    }
    /**
     * Set InvoiceZip value
     * @param string $invoiceZip
     * @return \StructType\Customer
     */
    public function setInvoiceZip($invoiceZip = null)
    {
        // validation for constraint: string
        if (!is_null($invoiceZip) && !is_string($invoiceZip)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoiceZip, true), gettype($invoiceZip)), __LINE__);
        }
        $this->InvoiceZip = $invoiceZip;
        return $this;
    }
    /**
     * Get InvoiceCity value
     * @return string|null
     */
    public function getInvoiceCity()
    {
        return $this->InvoiceCity;
    }
    /**
     * Set InvoiceCity value
     * @param string $invoiceCity
     * @return \StructType\Customer
     */
    public function setInvoiceCity($invoiceCity = null)
    {
        // validation for constraint: string
        if (!is_null($invoiceCity) && !is_string($invoiceCity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoiceCity, true), gettype($invoiceCity)), __LINE__);
        }
        $this->InvoiceCity = $invoiceCity;
        return $this;
    }
    /**
     * Get InvoiceCountry value
     * @return string|null
     */
    public function getInvoiceCountry()
    {
        return $this->InvoiceCountry;
    }
    /**
     * Set InvoiceCountry value
     * @param string $invoiceCountry
     * @return \StructType\Customer
     */
    public function setInvoiceCountry($invoiceCountry = null)
    {
        // validation for constraint: string
        if (!is_null($invoiceCountry) && !is_string($invoiceCountry)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoiceCountry, true), gettype($invoiceCountry)), __LINE__);
        }
        $this->InvoiceCountry = $invoiceCountry;
        return $this;
    }
    /**
     * Get InvoiceOrgnr value
     * @return string|null
     */
    public function getInvoiceOrgnr()
    {
        return $this->InvoiceOrgnr;
    }
    /**
     * Set InvoiceOrgnr value
     * @param string $invoiceOrgnr
     * @return \StructType\Customer
     */
    public function setInvoiceOrgnr($invoiceOrgnr = null)
    {
        // validation for constraint: string
        if (!is_null($invoiceOrgnr) && !is_string($invoiceOrgnr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoiceOrgnr, true), gettype($invoiceOrgnr)), __LINE__);
        }
        $this->InvoiceOrgnr = $invoiceOrgnr;
        return $this;
    }
    /**
     * Get CustomerGroupName value
     * @return string|null
     */
    public function getCustomerGroupName()
    {
        return $this->CustomerGroupName;
    }
    /**
     * Set CustomerGroupName value
     * @param string $customerGroupName
     * @return \StructType\Customer
     */
    public function setCustomerGroupName($customerGroupName = null)
    {
        // validation for constraint: string
        if (!is_null($customerGroupName) && !is_string($customerGroupName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerGroupName, true), gettype($customerGroupName)), __LINE__);
        }
        $this->CustomerGroupName = $customerGroupName;
        return $this;
    }
    /**
     * Get Password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->Password;
    }
    /**
     * Set Password value
     * @param string $password
     * @return \StructType\Customer
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($password, true), gettype($password)), __LINE__);
        }
        $this->Password = $password;
        return $this;
    }
    /**
     * Get InvoiceVatnr value
     * @return string|null
     */
    public function getInvoiceVatnr()
    {
        return $this->InvoiceVatnr;
    }
    /**
     * Set InvoiceVatnr value
     * @param string $invoiceVatnr
     * @return \StructType\Customer
     */
    public function setInvoiceVatnr($invoiceVatnr = null)
    {
        // validation for constraint: string
        if (!is_null($invoiceVatnr) && !is_string($invoiceVatnr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoiceVatnr, true), gettype($invoiceVatnr)), __LINE__);
        }
        $this->InvoiceVatnr = $invoiceVatnr;
        return $this;
    }
    /**
     * Get CustomerReference value
     * @return string|null
     */
    public function getCustomerReference()
    {
        return $this->CustomerReference;
    }
    /**
     * Set CustomerReference value
     * @param string $customerReference
     * @return \StructType\Customer
     */
    public function setCustomerReference($customerReference = null)
    {
        // validation for constraint: string
        if (!is_null($customerReference) && !is_string($customerReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerReference, true), gettype($customerReference)), __LINE__);
        }
        $this->CustomerReference = $customerReference;
        return $this;
    }
    /**
     * Get Attribute value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Attribute[]|null
     */
    public function getAttribute()
    {
        return isset($this->Attribute) ? $this->Attribute : null;
    }
    /**
     * This method is responsible for validating the values passed to the setAttribute method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAttribute method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAttributeForArrayConstraintsFromSetAttribute(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $customerAttributeItem) {
            // validation for constraint: itemType
            if (!$customerAttributeItem instanceof \StructType\Attribute) {
                $invalidValues[] = is_object($customerAttributeItem) ? get_class($customerAttributeItem) : sprintf('%s(%s)', gettype($customerAttributeItem), var_export($customerAttributeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Attribute property can only contain items of type \StructType\Attribute, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Attribute value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Attribute[] $attribute
     * @return \StructType\Customer
     */
    public function setAttribute(array $attribute = array())
    {
        // validation for constraint: array
        if ('' !== ($attributeArrayErrorMessage = self::validateAttributeForArrayConstraintsFromSetAttribute($attribute))) {
            throw new \InvalidArgumentException($attributeArrayErrorMessage, __LINE__);
        }
        if (is_null($attribute) || (is_array($attribute) && empty($attribute))) {
            unset($this->Attribute);
        } else {
            $this->Attribute = $attribute;
        }
        return $this;
    }
    /**
     * Add item to Attribute value
     * @throws \InvalidArgumentException
     * @param \StructType\Attribute $item
     * @return \StructType\Customer
     */
    public function addToAttribute(\StructType\Attribute $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Attribute) {
            throw new \InvalidArgumentException(sprintf('The Attribute property can only contain items of type \StructType\Attribute, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Attribute[] = $item;
        return $this;
    }
}
