<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Attribute StructType
 * @subpackage Structs
 */
class Attribute extends AbstractStructBase
{
    /**
     * The AttributeID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $AttributeID;
    /**
     * The AttributeTypeID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $AttributeTypeID;
    /**
     * The AttributeOwnerTypeID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $AttributeOwnerTypeID;
    /**
     * The AttributeTypeDescription
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AttributeTypeDescription;
    /**
     * The AttributeOwnerTypeDescription
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AttributeOwnerTypeDescription;
    /**
     * The AttributeDescription
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AttributeDescription;
    /**
     * The AttributeValue
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AttributeValue;
    /**
     * The AttributeAlternative
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\AttributeAlternative[]
     */
    public $AttributeAlternative;
    /**
     * Constructor method for Attribute
     * @uses Attribute::setAttributeID()
     * @uses Attribute::setAttributeTypeID()
     * @uses Attribute::setAttributeOwnerTypeID()
     * @uses Attribute::setAttributeTypeDescription()
     * @uses Attribute::setAttributeOwnerTypeDescription()
     * @uses Attribute::setAttributeDescription()
     * @uses Attribute::setAttributeValue()
     * @uses Attribute::setAttributeAlternative()
     * @param int $attributeID
     * @param int $attributeTypeID
     * @param int $attributeOwnerTypeID
     * @param string $attributeTypeDescription
     * @param string $attributeOwnerTypeDescription
     * @param string $attributeDescription
     * @param string $attributeValue
     * @param \StructType\AttributeAlternative[] $attributeAlternative
     */
    public function __construct($attributeID = null, $attributeTypeID = null, $attributeOwnerTypeID = null, $attributeTypeDescription = null, $attributeOwnerTypeDescription = null, $attributeDescription = null, $attributeValue = null, array $attributeAlternative = array())
    {
        $this
            ->setAttributeID($attributeID)
            ->setAttributeTypeID($attributeTypeID)
            ->setAttributeOwnerTypeID($attributeOwnerTypeID)
            ->setAttributeTypeDescription($attributeTypeDescription)
            ->setAttributeOwnerTypeDescription($attributeOwnerTypeDescription)
            ->setAttributeDescription($attributeDescription)
            ->setAttributeValue($attributeValue)
            ->setAttributeAlternative($attributeAlternative);
    }
    /**
     * Get AttributeID value
     * @return int
     */
    public function getAttributeID()
    {
        return $this->AttributeID;
    }
    /**
     * Set AttributeID value
     * @param int $attributeID
     * @return \StructType\Attribute
     */
    public function setAttributeID($attributeID = null)
    {
        // validation for constraint: int
        if (!is_null($attributeID) && !(is_int($attributeID) || ctype_digit($attributeID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($attributeID, true), gettype($attributeID)), __LINE__);
        }
        $this->AttributeID = $attributeID;
        return $this;
    }
    /**
     * Get AttributeTypeID value
     * @return int
     */
    public function getAttributeTypeID()
    {
        return $this->AttributeTypeID;
    }
    /**
     * Set AttributeTypeID value
     * @param int $attributeTypeID
     * @return \StructType\Attribute
     */
    public function setAttributeTypeID($attributeTypeID = null)
    {
        // validation for constraint: int
        if (!is_null($attributeTypeID) && !(is_int($attributeTypeID) || ctype_digit($attributeTypeID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($attributeTypeID, true), gettype($attributeTypeID)), __LINE__);
        }
        $this->AttributeTypeID = $attributeTypeID;
        return $this;
    }
    /**
     * Get AttributeOwnerTypeID value
     * @return int
     */
    public function getAttributeOwnerTypeID()
    {
        return $this->AttributeOwnerTypeID;
    }
    /**
     * Set AttributeOwnerTypeID value
     * @param int $attributeOwnerTypeID
     * @return \StructType\Attribute
     */
    public function setAttributeOwnerTypeID($attributeOwnerTypeID = null)
    {
        // validation for constraint: int
        if (!is_null($attributeOwnerTypeID) && !(is_int($attributeOwnerTypeID) || ctype_digit($attributeOwnerTypeID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($attributeOwnerTypeID, true), gettype($attributeOwnerTypeID)), __LINE__);
        }
        $this->AttributeOwnerTypeID = $attributeOwnerTypeID;
        return $this;
    }
    /**
     * Get AttributeTypeDescription value
     * @return string|null
     */
    public function getAttributeTypeDescription()
    {
        return $this->AttributeTypeDescription;
    }
    /**
     * Set AttributeTypeDescription value
     * @param string $attributeTypeDescription
     * @return \StructType\Attribute
     */
    public function setAttributeTypeDescription($attributeTypeDescription = null)
    {
        // validation for constraint: string
        if (!is_null($attributeTypeDescription) && !is_string($attributeTypeDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($attributeTypeDescription, true), gettype($attributeTypeDescription)), __LINE__);
        }
        $this->AttributeTypeDescription = $attributeTypeDescription;
        return $this;
    }
    /**
     * Get AttributeOwnerTypeDescription value
     * @return string|null
     */
    public function getAttributeOwnerTypeDescription()
    {
        return $this->AttributeOwnerTypeDescription;
    }
    /**
     * Set AttributeOwnerTypeDescription value
     * @param string $attributeOwnerTypeDescription
     * @return \StructType\Attribute
     */
    public function setAttributeOwnerTypeDescription($attributeOwnerTypeDescription = null)
    {
        // validation for constraint: string
        if (!is_null($attributeOwnerTypeDescription) && !is_string($attributeOwnerTypeDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($attributeOwnerTypeDescription, true), gettype($attributeOwnerTypeDescription)), __LINE__);
        }
        $this->AttributeOwnerTypeDescription = $attributeOwnerTypeDescription;
        return $this;
    }
    /**
     * Get AttributeDescription value
     * @return string|null
     */
    public function getAttributeDescription()
    {
        return $this->AttributeDescription;
    }
    /**
     * Set AttributeDescription value
     * @param string $attributeDescription
     * @return \StructType\Attribute
     */
    public function setAttributeDescription($attributeDescription = null)
    {
        // validation for constraint: string
        if (!is_null($attributeDescription) && !is_string($attributeDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($attributeDescription, true), gettype($attributeDescription)), __LINE__);
        }
        $this->AttributeDescription = $attributeDescription;
        return $this;
    }
    /**
     * Get AttributeValue value
     * @return string|null
     */
    public function getAttributeValue()
    {
        return $this->AttributeValue;
    }
    /**
     * Set AttributeValue value
     * @param string $attributeValue
     * @return \StructType\Attribute
     */
    public function setAttributeValue($attributeValue = null)
    {
        // validation for constraint: string
        if (!is_null($attributeValue) && !is_string($attributeValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($attributeValue, true), gettype($attributeValue)), __LINE__);
        }
        $this->AttributeValue = $attributeValue;
        return $this;
    }
    /**
     * Get AttributeAlternative value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\AttributeAlternative[]|null
     */
    public function getAttributeAlternative()
    {
        return isset($this->AttributeAlternative) ? $this->AttributeAlternative : null;
    }
    /**
     * This method is responsible for validating the values passed to the setAttributeAlternative method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAttributeAlternative method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAttributeAlternativeForArrayConstraintsFromSetAttributeAlternative(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $attributeAttributeAlternativeItem) {
            // validation for constraint: itemType
            if (!$attributeAttributeAlternativeItem instanceof \StructType\AttributeAlternative) {
                $invalidValues[] = is_object($attributeAttributeAlternativeItem) ? get_class($attributeAttributeAlternativeItem) : sprintf('%s(%s)', gettype($attributeAttributeAlternativeItem), var_export($attributeAttributeAlternativeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The AttributeAlternative property can only contain items of type \StructType\AttributeAlternative, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AttributeAlternative value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\AttributeAlternative[] $attributeAlternative
     * @return \StructType\Attribute
     */
    public function setAttributeAlternative(array $attributeAlternative = array())
    {
        // validation for constraint: array
        if ('' !== ($attributeAlternativeArrayErrorMessage = self::validateAttributeAlternativeForArrayConstraintsFromSetAttributeAlternative($attributeAlternative))) {
            throw new \InvalidArgumentException($attributeAlternativeArrayErrorMessage, __LINE__);
        }
        if (is_null($attributeAlternative) || (is_array($attributeAlternative) && empty($attributeAlternative))) {
            unset($this->AttributeAlternative);
        } else {
            $this->AttributeAlternative = $attributeAlternative;
        }
        return $this;
    }
    /**
     * Add item to AttributeAlternative value
     * @throws \InvalidArgumentException
     * @param \StructType\AttributeAlternative $item
     * @return \StructType\Attribute
     */
    public function addToAttributeAlternative(\StructType\AttributeAlternative $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AttributeAlternative) {
            throw new \InvalidArgumentException(sprintf('The AttributeAlternative property can only contain items of type \StructType\AttributeAlternative, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->AttributeAlternative[] = $item;
        return $this;
    }
}
