<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfInvoiceV7 ArrayType
 * @subpackage Arrays
 */
class ArrayOfInvoiceV7 extends AbstractStructArrayBase
{
    /**
     * The InvoiceV7
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\InvoiceV7[]
     */
    public $InvoiceV7;
    /**
     * Constructor method for ArrayOfInvoiceV7
     * @uses ArrayOfInvoiceV7::setInvoiceV7()
     * @param \StructType\InvoiceV7[] $invoiceV7
     */
    public function __construct(array $invoiceV7 = array())
    {
        $this
            ->setInvoiceV7($invoiceV7);
    }
    /**
     * Get InvoiceV7 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\InvoiceV7[]|null
     */
    public function getInvoiceV7()
    {
        return isset($this->InvoiceV7) ? $this->InvoiceV7 : null;
    }
    /**
     * This method is responsible for validating the values passed to the setInvoiceV7 method
     * This method is willingly generated in order to preserve the one-line inline validation within the setInvoiceV7 method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateInvoiceV7ForArrayConstraintsFromSetInvoiceV7(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfInvoiceV7InvoiceV7Item) {
            // validation for constraint: itemType
            if (!$arrayOfInvoiceV7InvoiceV7Item instanceof \StructType\InvoiceV7) {
                $invalidValues[] = is_object($arrayOfInvoiceV7InvoiceV7Item) ? get_class($arrayOfInvoiceV7InvoiceV7Item) : sprintf('%s(%s)', gettype($arrayOfInvoiceV7InvoiceV7Item), var_export($arrayOfInvoiceV7InvoiceV7Item, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The InvoiceV7 property can only contain items of type \StructType\InvoiceV7, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set InvoiceV7 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\InvoiceV7[] $invoiceV7
     * @return \ArrayType\ArrayOfInvoiceV7
     */
    public function setInvoiceV7(array $invoiceV7 = array())
    {
        // validation for constraint: array
        if ('' !== ($invoiceV7ArrayErrorMessage = self::validateInvoiceV7ForArrayConstraintsFromSetInvoiceV7($invoiceV7))) {
            throw new \InvalidArgumentException($invoiceV7ArrayErrorMessage, __LINE__);
        }
        if (is_null($invoiceV7) || (is_array($invoiceV7) && empty($invoiceV7))) {
            unset($this->InvoiceV7);
        } else {
            $this->InvoiceV7 = $invoiceV7;
        }
        return $this;
    }
    /**
     * Add item to InvoiceV7 value
     * @throws \InvalidArgumentException
     * @param \StructType\InvoiceV7 $item
     * @return \ArrayType\ArrayOfInvoiceV7
     */
    public function addToInvoiceV7(\StructType\InvoiceV7 $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\InvoiceV7) {
            throw new \InvalidArgumentException(sprintf('The InvoiceV7 property can only contain items of type \StructType\InvoiceV7, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->InvoiceV7[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\InvoiceV7|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\InvoiceV7|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\InvoiceV7|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\InvoiceV7|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\InvoiceV7|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string InvoiceV7
     */
    public function getAttributeName()
    {
        return 'InvoiceV7';
    }
}
