<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfInvoiceV5 ArrayType
 * @subpackage Arrays
 */
class ArrayOfInvoiceV5 extends AbstractStructArrayBase
{
    /**
     * The InvoiceV5
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\InvoiceV5[]
     */
    public $InvoiceV5;
    /**
     * Constructor method for ArrayOfInvoiceV5
     * @uses ArrayOfInvoiceV5::setInvoiceV5()
     * @param \StructType\InvoiceV5[] $invoiceV5
     */
    public function __construct(array $invoiceV5 = array())
    {
        $this
            ->setInvoiceV5($invoiceV5);
    }
    /**
     * Get InvoiceV5 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\InvoiceV5[]|null
     */
    public function getInvoiceV5()
    {
        return isset($this->InvoiceV5) ? $this->InvoiceV5 : null;
    }
    /**
     * This method is responsible for validating the values passed to the setInvoiceV5 method
     * This method is willingly generated in order to preserve the one-line inline validation within the setInvoiceV5 method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateInvoiceV5ForArrayConstraintsFromSetInvoiceV5(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfInvoiceV5InvoiceV5Item) {
            // validation for constraint: itemType
            if (!$arrayOfInvoiceV5InvoiceV5Item instanceof \StructType\InvoiceV5) {
                $invalidValues[] = is_object($arrayOfInvoiceV5InvoiceV5Item) ? get_class($arrayOfInvoiceV5InvoiceV5Item) : sprintf('%s(%s)', gettype($arrayOfInvoiceV5InvoiceV5Item), var_export($arrayOfInvoiceV5InvoiceV5Item, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The InvoiceV5 property can only contain items of type \StructType\InvoiceV5, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set InvoiceV5 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\InvoiceV5[] $invoiceV5
     * @return \ArrayType\ArrayOfInvoiceV5
     */
    public function setInvoiceV5(array $invoiceV5 = array())
    {
        // validation for constraint: array
        if ('' !== ($invoiceV5ArrayErrorMessage = self::validateInvoiceV5ForArrayConstraintsFromSetInvoiceV5($invoiceV5))) {
            throw new \InvalidArgumentException($invoiceV5ArrayErrorMessage, __LINE__);
        }
        if (is_null($invoiceV5) || (is_array($invoiceV5) && empty($invoiceV5))) {
            unset($this->InvoiceV5);
        } else {
            $this->InvoiceV5 = $invoiceV5;
        }
        return $this;
    }
    /**
     * Add item to InvoiceV5 value
     * @throws \InvalidArgumentException
     * @param \StructType\InvoiceV5 $item
     * @return \ArrayType\ArrayOfInvoiceV5
     */
    public function addToInvoiceV5(\StructType\InvoiceV5 $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\InvoiceV5) {
            throw new \InvalidArgumentException(sprintf('The InvoiceV5 property can only contain items of type \StructType\InvoiceV5, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->InvoiceV5[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\InvoiceV5|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\InvoiceV5|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\InvoiceV5|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\InvoiceV5|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\InvoiceV5|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string InvoiceV5
     */
    public function getAttributeName()
    {
        return 'InvoiceV5';
    }
}
