<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfInvoiceV4 ArrayType
 * @subpackage Arrays
 */
class ArrayOfInvoiceV4 extends AbstractStructArrayBase
{
    /**
     * The InvoiceV4
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\InvoiceV4[]
     */
    public $InvoiceV4;
    /**
     * Constructor method for ArrayOfInvoiceV4
     * @uses ArrayOfInvoiceV4::setInvoiceV4()
     * @param \StructType\InvoiceV4[] $invoiceV4
     */
    public function __construct(array $invoiceV4 = array())
    {
        $this
            ->setInvoiceV4($invoiceV4);
    }
    /**
     * Get InvoiceV4 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\InvoiceV4[]|null
     */
    public function getInvoiceV4()
    {
        return isset($this->InvoiceV4) ? $this->InvoiceV4 : null;
    }
    /**
     * This method is responsible for validating the values passed to the setInvoiceV4 method
     * This method is willingly generated in order to preserve the one-line inline validation within the setInvoiceV4 method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateInvoiceV4ForArrayConstraintsFromSetInvoiceV4(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfInvoiceV4InvoiceV4Item) {
            // validation for constraint: itemType
            if (!$arrayOfInvoiceV4InvoiceV4Item instanceof \StructType\InvoiceV4) {
                $invalidValues[] = is_object($arrayOfInvoiceV4InvoiceV4Item) ? get_class($arrayOfInvoiceV4InvoiceV4Item) : sprintf('%s(%s)', gettype($arrayOfInvoiceV4InvoiceV4Item), var_export($arrayOfInvoiceV4InvoiceV4Item, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The InvoiceV4 property can only contain items of type \StructType\InvoiceV4, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set InvoiceV4 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\InvoiceV4[] $invoiceV4
     * @return \ArrayType\ArrayOfInvoiceV4
     */
    public function setInvoiceV4(array $invoiceV4 = array())
    {
        // validation for constraint: array
        if ('' !== ($invoiceV4ArrayErrorMessage = self::validateInvoiceV4ForArrayConstraintsFromSetInvoiceV4($invoiceV4))) {
            throw new \InvalidArgumentException($invoiceV4ArrayErrorMessage, __LINE__);
        }
        if (is_null($invoiceV4) || (is_array($invoiceV4) && empty($invoiceV4))) {
            unset($this->InvoiceV4);
        } else {
            $this->InvoiceV4 = $invoiceV4;
        }
        return $this;
    }
    /**
     * Add item to InvoiceV4 value
     * @throws \InvalidArgumentException
     * @param \StructType\InvoiceV4 $item
     * @return \ArrayType\ArrayOfInvoiceV4
     */
    public function addToInvoiceV4(\StructType\InvoiceV4 $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\InvoiceV4) {
            throw new \InvalidArgumentException(sprintf('The InvoiceV4 property can only contain items of type \StructType\InvoiceV4, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->InvoiceV4[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\InvoiceV4|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\InvoiceV4|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\InvoiceV4|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\InvoiceV4|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\InvoiceV4|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string InvoiceV4
     */
    public function getAttributeName()
    {
        return 'InvoiceV4';
    }
}
