<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfCustomerV5 ArrayType
 * @subpackage Arrays
 */
class ArrayOfCustomerV5 extends AbstractStructArrayBase
{
    /**
     * The CustomerV5
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\CustomerV5[]
     */
    public $CustomerV5;
    /**
     * Constructor method for ArrayOfCustomerV5
     * @uses ArrayOfCustomerV5::setCustomerV5()
     * @param \StructType\CustomerV5[] $customerV5
     */
    public function __construct(array $customerV5 = array())
    {
        $this
            ->setCustomerV5($customerV5);
    }
    /**
     * Get CustomerV5 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\CustomerV5[]|null
     */
    public function getCustomerV5()
    {
        return isset($this->CustomerV5) ? $this->CustomerV5 : null;
    }
    /**
     * This method is responsible for validating the values passed to the setCustomerV5 method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCustomerV5 method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCustomerV5ForArrayConstraintsFromSetCustomerV5(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfCustomerV5CustomerV5Item) {
            // validation for constraint: itemType
            if (!$arrayOfCustomerV5CustomerV5Item instanceof \StructType\CustomerV5) {
                $invalidValues[] = is_object($arrayOfCustomerV5CustomerV5Item) ? get_class($arrayOfCustomerV5CustomerV5Item) : sprintf('%s(%s)', gettype($arrayOfCustomerV5CustomerV5Item), var_export($arrayOfCustomerV5CustomerV5Item, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The CustomerV5 property can only contain items of type \StructType\CustomerV5, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CustomerV5 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\CustomerV5[] $customerV5
     * @return \ArrayType\ArrayOfCustomerV5
     */
    public function setCustomerV5(array $customerV5 = array())
    {
        // validation for constraint: array
        if ('' !== ($customerV5ArrayErrorMessage = self::validateCustomerV5ForArrayConstraintsFromSetCustomerV5($customerV5))) {
            throw new \InvalidArgumentException($customerV5ArrayErrorMessage, __LINE__);
        }
        if (is_null($customerV5) || (is_array($customerV5) && empty($customerV5))) {
            unset($this->CustomerV5);
        } else {
            $this->CustomerV5 = $customerV5;
        }
        return $this;
    }
    /**
     * Add item to CustomerV5 value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomerV5 $item
     * @return \ArrayType\ArrayOfCustomerV5
     */
    public function addToCustomerV5(\StructType\CustomerV5 $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CustomerV5) {
            throw new \InvalidArgumentException(sprintf('The CustomerV5 property can only contain items of type \StructType\CustomerV5, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->CustomerV5[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\CustomerV5|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\CustomerV5|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\CustomerV5|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\CustomerV5|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\CustomerV5|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string CustomerV5
     */
    public function getAttributeName()
    {
        return 'CustomerV5';
    }
}
