<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfCustomerV3 ArrayType
 * @subpackage Arrays
 */
class ArrayOfCustomerV3 extends AbstractStructArrayBase
{
    /**
     * The CustomerV3
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\CustomerV3[]
     */
    public $CustomerV3;
    /**
     * Constructor method for ArrayOfCustomerV3
     * @uses ArrayOfCustomerV3::setCustomerV3()
     * @param \StructType\CustomerV3[] $customerV3
     */
    public function __construct(array $customerV3 = array())
    {
        $this
            ->setCustomerV3($customerV3);
    }
    /**
     * Get CustomerV3 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\CustomerV3[]|null
     */
    public function getCustomerV3()
    {
        return isset($this->CustomerV3) ? $this->CustomerV3 : null;
    }
    /**
     * This method is responsible for validating the values passed to the setCustomerV3 method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCustomerV3 method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCustomerV3ForArrayConstraintsFromSetCustomerV3(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfCustomerV3CustomerV3Item) {
            // validation for constraint: itemType
            if (!$arrayOfCustomerV3CustomerV3Item instanceof \StructType\CustomerV3) {
                $invalidValues[] = is_object($arrayOfCustomerV3CustomerV3Item) ? get_class($arrayOfCustomerV3CustomerV3Item) : sprintf('%s(%s)', gettype($arrayOfCustomerV3CustomerV3Item), var_export($arrayOfCustomerV3CustomerV3Item, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The CustomerV3 property can only contain items of type \StructType\CustomerV3, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CustomerV3 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\CustomerV3[] $customerV3
     * @return \ArrayType\ArrayOfCustomerV3
     */
    public function setCustomerV3(array $customerV3 = array())
    {
        // validation for constraint: array
        if ('' !== ($customerV3ArrayErrorMessage = self::validateCustomerV3ForArrayConstraintsFromSetCustomerV3($customerV3))) {
            throw new \InvalidArgumentException($customerV3ArrayErrorMessage, __LINE__);
        }
        if (is_null($customerV3) || (is_array($customerV3) && empty($customerV3))) {
            unset($this->CustomerV3);
        } else {
            $this->CustomerV3 = $customerV3;
        }
        return $this;
    }
    /**
     * Add item to CustomerV3 value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomerV3 $item
     * @return \ArrayType\ArrayOfCustomerV3
     */
    public function addToCustomerV3(\StructType\CustomerV3 $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CustomerV3) {
            throw new \InvalidArgumentException(sprintf('The CustomerV3 property can only contain items of type \StructType\CustomerV3, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->CustomerV3[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\CustomerV3|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\CustomerV3|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\CustomerV3|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\CustomerV3|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\CustomerV3|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string CustomerV3
     */
    public function getAttributeName()
    {
        return 'CustomerV3';
    }
}
