<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfCustomerV2 ArrayType
 * @subpackage Arrays
 */
class ArrayOfCustomerV2 extends AbstractStructArrayBase
{
    /**
     * The CustomerV2
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\CustomerV2[]
     */
    public $CustomerV2;
    /**
     * Constructor method for ArrayOfCustomerV2
     * @uses ArrayOfCustomerV2::setCustomerV2()
     * @param \StructType\CustomerV2[] $customerV2
     */
    public function __construct(array $customerV2 = array())
    {
        $this
            ->setCustomerV2($customerV2);
    }
    /**
     * Get CustomerV2 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\CustomerV2[]|null
     */
    public function getCustomerV2()
    {
        return isset($this->CustomerV2) ? $this->CustomerV2 : null;
    }
    /**
     * This method is responsible for validating the values passed to the setCustomerV2 method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCustomerV2 method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCustomerV2ForArrayConstraintsFromSetCustomerV2(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfCustomerV2CustomerV2Item) {
            // validation for constraint: itemType
            if (!$arrayOfCustomerV2CustomerV2Item instanceof \StructType\CustomerV2) {
                $invalidValues[] = is_object($arrayOfCustomerV2CustomerV2Item) ? get_class($arrayOfCustomerV2CustomerV2Item) : sprintf('%s(%s)', gettype($arrayOfCustomerV2CustomerV2Item), var_export($arrayOfCustomerV2CustomerV2Item, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The CustomerV2 property can only contain items of type \StructType\CustomerV2, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CustomerV2 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\CustomerV2[] $customerV2
     * @return \ArrayType\ArrayOfCustomerV2
     */
    public function setCustomerV2(array $customerV2 = array())
    {
        // validation for constraint: array
        if ('' !== ($customerV2ArrayErrorMessage = self::validateCustomerV2ForArrayConstraintsFromSetCustomerV2($customerV2))) {
            throw new \InvalidArgumentException($customerV2ArrayErrorMessage, __LINE__);
        }
        if (is_null($customerV2) || (is_array($customerV2) && empty($customerV2))) {
            unset($this->CustomerV2);
        } else {
            $this->CustomerV2 = $customerV2;
        }
        return $this;
    }
    /**
     * Add item to CustomerV2 value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomerV2 $item
     * @return \ArrayType\ArrayOfCustomerV2
     */
    public function addToCustomerV2(\StructType\CustomerV2 $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CustomerV2) {
            throw new \InvalidArgumentException(sprintf('The CustomerV2 property can only contain items of type \StructType\CustomerV2, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->CustomerV2[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\CustomerV2|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\CustomerV2|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\CustomerV2|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\CustomerV2|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\CustomerV2|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string CustomerV2
     */
    public function getAttributeName()
    {
        return 'CustomerV2';
    }
}
