<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SetEmptyAccountSetting StructType
 * @subpackage Structs
 */
class SetEmptyAccountSetting extends AbstractStructBase
{
    /**
     * The setting
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $setting;
    /**
     * The authToken
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $authToken;
    /**
     * The newValue
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $newValue;
    /**
     * Constructor method for SetEmptyAccountSetting
     * @uses SetEmptyAccountSetting::setSetting()
     * @uses SetEmptyAccountSetting::setAuthToken()
     * @uses SetEmptyAccountSetting::setNewValue()
     * @param string $setting
     * @param string $authToken
     * @param string $newValue
     */
    public function __construct($setting = null, $authToken = null, $newValue = null)
    {
        $this
            ->setSetting($setting)
            ->setAuthToken($authToken)
            ->setNewValue($newValue);
    }
    /**
     * Get setting value
     * @return string
     */
    public function getSetting()
    {
        return $this->setting;
    }
    /**
     * Set setting value
     * @uses \EnumType\AccountSetting::valueIsValid()
     * @uses \EnumType\AccountSetting::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $setting
     * @return \StructType\SetEmptyAccountSetting
     */
    public function setSetting($setting = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\AccountSetting::valueIsValid($setting)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\AccountSetting', is_array($setting) ? implode(', ', $setting) : var_export($setting, true), implode(', ', \EnumType\AccountSetting::getValidValues())), __LINE__);
        }
        $this->setting = $setting;
        return $this;
    }
    /**
     * Get authToken value
     * @return string|null
     */
    public function getAuthToken()
    {
        return $this->authToken;
    }
    /**
     * Set authToken value
     * @param string $authToken
     * @return \StructType\SetEmptyAccountSetting
     */
    public function setAuthToken($authToken = null)
    {
        // validation for constraint: string
        if (!is_null($authToken) && !is_string($authToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($authToken, true), gettype($authToken)), __LINE__);
        }
        $this->authToken = $authToken;
        return $this;
    }
    /**
     * Get newValue value
     * @return string|null
     */
    public function getNewValue()
    {
        return $this->newValue;
    }
    /**
     * Set newValue value
     * @param string $newValue
     * @return \StructType\SetEmptyAccountSetting
     */
    public function setNewValue($newValue = null)
    {
        // validation for constraint: string
        if (!is_null($newValue) && !is_string($newValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($newValue, true), gettype($newValue)), __LINE__);
        }
        $this->newValue = $newValue;
        return $this;
    }
}
