<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SetBalanceXml StructType
 * @subpackage Structs
 */
class SetBalanceXml extends AbstractStructBase
{
    /**
     * The authToken
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $authToken;
    /**
     * The payment
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $payment;
    /**
     * Constructor method for SetBalanceXml
     * @uses SetBalanceXml::setAuthToken()
     * @uses SetBalanceXml::setPayment()
     * @param string $authToken
     * @param string $payment
     */
    public function __construct($authToken = null, $payment = null)
    {
        $this
            ->setAuthToken($authToken)
            ->setPayment($payment);
    }
    /**
     * Get authToken value
     * @return string|null
     */
    public function getAuthToken()
    {
        return $this->authToken;
    }
    /**
     * Set authToken value
     * @param string $authToken
     * @return \StructType\SetBalanceXml
     */
    public function setAuthToken($authToken = null)
    {
        // validation for constraint: string
        if (!is_null($authToken) && !is_string($authToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($authToken, true), gettype($authToken)), __LINE__);
        }
        $this->authToken = $authToken;
        return $this;
    }
    /**
     * Get payment value
     * @return string|null
     */
    public function getPayment()
    {
        return $this->payment;
    }
    /**
     * Set payment value
     * @param string $payment
     * @return \StructType\SetBalanceXml
     */
    public function setPayment($payment = null)
    {
        // validation for constraint: string
        if (!is_null($payment) && !is_string($payment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($payment, true), gettype($payment)), __LINE__);
        }
        $this->payment = $payment;
        return $this;
    }
}
