<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Payment StructType
 * @subpackage Structs
 */
class Payment extends AbstractStructBase
{
    /**
     * The InvoiceID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $InvoiceID;
    /**
     * The Sum
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Sum;
    /**
     * The PaymentTypeID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PaymentTypeID;
    /**
     * Constructor method for Payment
     * @uses Payment::setInvoiceID()
     * @uses Payment::setSum()
     * @uses Payment::setPaymentTypeID()
     * @param int $invoiceID
     * @param float $sum
     * @param int $paymentTypeID
     */
    public function __construct($invoiceID = null, $sum = null, $paymentTypeID = null)
    {
        $this
            ->setInvoiceID($invoiceID)
            ->setSum($sum)
            ->setPaymentTypeID($paymentTypeID);
    }
    /**
     * Get InvoiceID value
     * @return int
     */
    public function getInvoiceID()
    {
        return $this->InvoiceID;
    }
    /**
     * Set InvoiceID value
     * @param int $invoiceID
     * @return \StructType\Payment
     */
    public function setInvoiceID($invoiceID = null)
    {
        // validation for constraint: int
        if (!is_null($invoiceID) && !(is_int($invoiceID) || ctype_digit($invoiceID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($invoiceID, true), gettype($invoiceID)), __LINE__);
        }
        $this->InvoiceID = $invoiceID;
        return $this;
    }
    /**
     * Get Sum value
     * @return float
     */
    public function getSum()
    {
        return $this->Sum;
    }
    /**
     * Set Sum value
     * @param float $sum
     * @return \StructType\Payment
     */
    public function setSum($sum = null)
    {
        // validation for constraint: float
        if (!is_null($sum) && !(is_float($sum) || is_numeric($sum))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($sum, true), gettype($sum)), __LINE__);
        }
        $this->Sum = $sum;
        return $this;
    }
    /**
     * Get PaymentTypeID value
     * @return int
     */
    public function getPaymentTypeID()
    {
        return $this->PaymentTypeID;
    }
    /**
     * Set PaymentTypeID value
     * @param int $paymentTypeID
     * @return \StructType\Payment
     */
    public function setPaymentTypeID($paymentTypeID = null)
    {
        // validation for constraint: int
        if (!is_null($paymentTypeID) && !(is_int($paymentTypeID) || ctype_digit($paymentTypeID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($paymentTypeID, true), gettype($paymentTypeID)), __LINE__);
        }
        $this->PaymentTypeID = $paymentTypeID;
        return $this;
    }
}
