<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InvoiceTransactionDataList StructType
 * @subpackage Structs
 */
class InvoiceTransactionDataList extends AbstractStructBase
{
    /**
     * The Invoices
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfInvoiceTransactionData
     */
    public $Invoices;
    /**
     * The Errors
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfString
     */
    public $Errors;
    /**
     * Constructor method for InvoiceTransactionDataList
     * @uses InvoiceTransactionDataList::setInvoices()
     * @uses InvoiceTransactionDataList::setErrors()
     * @param \ArrayType\ArrayOfInvoiceTransactionData $invoices
     * @param \ArrayType\ArrayOfString $errors
     */
    public function __construct(\ArrayType\ArrayOfInvoiceTransactionData $invoices = null, \ArrayType\ArrayOfString $errors = null)
    {
        $this
            ->setInvoices($invoices)
            ->setErrors($errors);
    }
    /**
     * Get Invoices value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfInvoiceTransactionData|null
     */
    public function getInvoices()
    {
        return isset($this->Invoices) ? $this->Invoices : null;
    }
    /**
     * Set Invoices value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfInvoiceTransactionData $invoices
     * @return \StructType\InvoiceTransactionDataList
     */
    public function setInvoices(\ArrayType\ArrayOfInvoiceTransactionData $invoices = null)
    {
        if (is_null($invoices) || (is_array($invoices) && empty($invoices))) {
            unset($this->Invoices);
        } else {
            $this->Invoices = $invoices;
        }
        return $this;
    }
    /**
     * Get Errors value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfString|null
     */
    public function getErrors()
    {
        return isset($this->Errors) ? $this->Errors : null;
    }
    /**
     * Set Errors value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfString $errors
     * @return \StructType\InvoiceTransactionDataList
     */
    public function setErrors(\ArrayType\ArrayOfString $errors = null)
    {
        if (is_null($errors) || (is_array($errors) && empty($errors))) {
            unset($this->Errors);
        } else {
            $this->Errors = $errors;
        }
        return $this;
    }
}
