<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomerGroup StructType
 * @subpackage Structs
 */
class CustomerGroup extends AbstractStructBase
{
    /**
     * The CustomerGroupID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CustomerGroupID;
    /**
     * The ParentCustomerGroupID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ParentCustomerGroupID;
    /**
     * The DiscountPercent
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $DiscountPercent;
    /**
     * The PublicGroup
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $PublicGroup;
    /**
     * The CustomerGroupName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CustomerGroupName;
    /**
     * The CustomerGroupCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CustomerGroupCode;
    /**
     * The PriceNameCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PriceNameCode;
    /**
     * Constructor method for CustomerGroup
     * @uses CustomerGroup::setCustomerGroupID()
     * @uses CustomerGroup::setParentCustomerGroupID()
     * @uses CustomerGroup::setDiscountPercent()
     * @uses CustomerGroup::setPublicGroup()
     * @uses CustomerGroup::setCustomerGroupName()
     * @uses CustomerGroup::setCustomerGroupCode()
     * @uses CustomerGroup::setPriceNameCode()
     * @param int $customerGroupID
     * @param int $parentCustomerGroupID
     * @param float $discountPercent
     * @param bool $publicGroup
     * @param string $customerGroupName
     * @param string $customerGroupCode
     * @param string $priceNameCode
     */
    public function __construct($customerGroupID = null, $parentCustomerGroupID = null, $discountPercent = null, $publicGroup = null, $customerGroupName = null, $customerGroupCode = null, $priceNameCode = null)
    {
        $this
            ->setCustomerGroupID($customerGroupID)
            ->setParentCustomerGroupID($parentCustomerGroupID)
            ->setDiscountPercent($discountPercent)
            ->setPublicGroup($publicGroup)
            ->setCustomerGroupName($customerGroupName)
            ->setCustomerGroupCode($customerGroupCode)
            ->setPriceNameCode($priceNameCode);
    }
    /**
     * Get CustomerGroupID value
     * @return int
     */
    public function getCustomerGroupID()
    {
        return $this->CustomerGroupID;
    }
    /**
     * Set CustomerGroupID value
     * @param int $customerGroupID
     * @return \StructType\CustomerGroup
     */
    public function setCustomerGroupID($customerGroupID = null)
    {
        // validation for constraint: int
        if (!is_null($customerGroupID) && !(is_int($customerGroupID) || ctype_digit($customerGroupID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($customerGroupID, true), gettype($customerGroupID)), __LINE__);
        }
        $this->CustomerGroupID = $customerGroupID;
        return $this;
    }
    /**
     * Get ParentCustomerGroupID value
     * @return int
     */
    public function getParentCustomerGroupID()
    {
        return $this->ParentCustomerGroupID;
    }
    /**
     * Set ParentCustomerGroupID value
     * @param int $parentCustomerGroupID
     * @return \StructType\CustomerGroup
     */
    public function setParentCustomerGroupID($parentCustomerGroupID = null)
    {
        // validation for constraint: int
        if (!is_null($parentCustomerGroupID) && !(is_int($parentCustomerGroupID) || ctype_digit($parentCustomerGroupID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($parentCustomerGroupID, true), gettype($parentCustomerGroupID)), __LINE__);
        }
        $this->ParentCustomerGroupID = $parentCustomerGroupID;
        return $this;
    }
    /**
     * Get DiscountPercent value
     * @return float
     */
    public function getDiscountPercent()
    {
        return $this->DiscountPercent;
    }
    /**
     * Set DiscountPercent value
     * @param float $discountPercent
     * @return \StructType\CustomerGroup
     */
    public function setDiscountPercent($discountPercent = null)
    {
        // validation for constraint: float
        if (!is_null($discountPercent) && !(is_float($discountPercent) || is_numeric($discountPercent))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($discountPercent, true), gettype($discountPercent)), __LINE__);
        }
        $this->DiscountPercent = $discountPercent;
        return $this;
    }
    /**
     * Get PublicGroup value
     * @return bool
     */
    public function getPublicGroup()
    {
        return $this->PublicGroup;
    }
    /**
     * Set PublicGroup value
     * @param bool $publicGroup
     * @return \StructType\CustomerGroup
     */
    public function setPublicGroup($publicGroup = null)
    {
        // validation for constraint: boolean
        if (!is_null($publicGroup) && !is_bool($publicGroup)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($publicGroup, true), gettype($publicGroup)), __LINE__);
        }
        $this->PublicGroup = $publicGroup;
        return $this;
    }
    /**
     * Get CustomerGroupName value
     * @return string|null
     */
    public function getCustomerGroupName()
    {
        return $this->CustomerGroupName;
    }
    /**
     * Set CustomerGroupName value
     * @param string $customerGroupName
     * @return \StructType\CustomerGroup
     */
    public function setCustomerGroupName($customerGroupName = null)
    {
        // validation for constraint: string
        if (!is_null($customerGroupName) && !is_string($customerGroupName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerGroupName, true), gettype($customerGroupName)), __LINE__);
        }
        $this->CustomerGroupName = $customerGroupName;
        return $this;
    }
    /**
     * Get CustomerGroupCode value
     * @return string|null
     */
    public function getCustomerGroupCode()
    {
        return $this->CustomerGroupCode;
    }
    /**
     * Set CustomerGroupCode value
     * @param string $customerGroupCode
     * @return \StructType\CustomerGroup
     */
    public function setCustomerGroupCode($customerGroupCode = null)
    {
        // validation for constraint: string
        if (!is_null($customerGroupCode) && !is_string($customerGroupCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerGroupCode, true), gettype($customerGroupCode)), __LINE__);
        }
        $this->CustomerGroupCode = $customerGroupCode;
        return $this;
    }
    /**
     * Get PriceNameCode value
     * @return string|null
     */
    public function getPriceNameCode()
    {
        return $this->PriceNameCode;
    }
    /**
     * Set PriceNameCode value
     * @param string $priceNameCode
     * @return \StructType\CustomerGroup
     */
    public function setPriceNameCode($priceNameCode = null)
    {
        // validation for constraint: string
        if (!is_null($priceNameCode) && !is_string($priceNameCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($priceNameCode, true), gettype($priceNameCode)), __LINE__);
        }
        $this->PriceNameCode = $priceNameCode;
        return $this;
    }
}
