<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Invalidate ServiceType
 * @subpackage Services
 */
class Invalidate extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named InvalidateInvoice
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\InvalidateInvoice $parameters
     * @return \StructType\InvalidateInvoiceResponse|bool
     */
    public function InvalidateInvoice(\StructType\InvalidateInvoice $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->InvalidateInvoice($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\InvalidateInvoiceResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
