<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Add ServiceType
 * @subpackage Services
 */
class Add extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named AddPayment
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddPayment $parameters
     * @return \StructType\AddPaymentResponse|bool
     */
    public function AddPayment(\StructType\AddPayment $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->AddPayment($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddPaymentXml
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddPaymentXml $parameters
     * @return \StructType\AddPaymentXmlResponse|bool
     */
    public function AddPaymentXml(\StructType\AddPaymentXml $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->AddPaymentXml($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\AddPaymentResponse|\StructType\AddPaymentXmlResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
