<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfInvoiceV2 ArrayType
 * @subpackage Arrays
 */
class ArrayOfInvoiceV2 extends AbstractStructArrayBase
{
    /**
     * The InvoiceV2
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\InvoiceV2[]
     */
    public $InvoiceV2;
    /**
     * Constructor method for ArrayOfInvoiceV2
     * @uses ArrayOfInvoiceV2::setInvoiceV2()
     * @param \StructType\InvoiceV2[] $invoiceV2
     */
    public function __construct(array $invoiceV2 = array())
    {
        $this
            ->setInvoiceV2($invoiceV2);
    }
    /**
     * Get InvoiceV2 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\InvoiceV2[]|null
     */
    public function getInvoiceV2()
    {
        return isset($this->InvoiceV2) ? $this->InvoiceV2 : null;
    }
    /**
     * This method is responsible for validating the values passed to the setInvoiceV2 method
     * This method is willingly generated in order to preserve the one-line inline validation within the setInvoiceV2 method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateInvoiceV2ForArrayConstraintsFromSetInvoiceV2(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfInvoiceV2InvoiceV2Item) {
            // validation for constraint: itemType
            if (!$arrayOfInvoiceV2InvoiceV2Item instanceof \StructType\InvoiceV2) {
                $invalidValues[] = is_object($arrayOfInvoiceV2InvoiceV2Item) ? get_class($arrayOfInvoiceV2InvoiceV2Item) : sprintf('%s(%s)', gettype($arrayOfInvoiceV2InvoiceV2Item), var_export($arrayOfInvoiceV2InvoiceV2Item, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The InvoiceV2 property can only contain items of type \StructType\InvoiceV2, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set InvoiceV2 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\InvoiceV2[] $invoiceV2
     * @return \ArrayType\ArrayOfInvoiceV2
     */
    public function setInvoiceV2(array $invoiceV2 = array())
    {
        // validation for constraint: array
        if ('' !== ($invoiceV2ArrayErrorMessage = self::validateInvoiceV2ForArrayConstraintsFromSetInvoiceV2($invoiceV2))) {
            throw new \InvalidArgumentException($invoiceV2ArrayErrorMessage, __LINE__);
        }
        if (is_null($invoiceV2) || (is_array($invoiceV2) && empty($invoiceV2))) {
            unset($this->InvoiceV2);
        } else {
            $this->InvoiceV2 = $invoiceV2;
        }
        return $this;
    }
    /**
     * Add item to InvoiceV2 value
     * @throws \InvalidArgumentException
     * @param \StructType\InvoiceV2 $item
     * @return \ArrayType\ArrayOfInvoiceV2
     */
    public function addToInvoiceV2(\StructType\InvoiceV2 $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\InvoiceV2) {
            throw new \InvalidArgumentException(sprintf('The InvoiceV2 property can only contain items of type \StructType\InvoiceV2, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->InvoiceV2[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\InvoiceV2|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\InvoiceV2|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\InvoiceV2|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\InvoiceV2|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\InvoiceV2|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string InvoiceV2
     */
    public function getAttributeName()
    {
        return 'InvoiceV2';
    }
}
