<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfCustomerV4 ArrayType
 * @subpackage Arrays
 */
class ArrayOfCustomerV4 extends AbstractStructArrayBase
{
    /**
     * The CustomerV4
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\CustomerV4[]
     */
    public $CustomerV4;
    /**
     * Constructor method for ArrayOfCustomerV4
     * @uses ArrayOfCustomerV4::setCustomerV4()
     * @param \StructType\CustomerV4[] $customerV4
     */
    public function __construct(array $customerV4 = array())
    {
        $this
            ->setCustomerV4($customerV4);
    }
    /**
     * Get CustomerV4 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\CustomerV4[]|null
     */
    public function getCustomerV4()
    {
        return isset($this->CustomerV4) ? $this->CustomerV4 : null;
    }
    /**
     * This method is responsible for validating the values passed to the setCustomerV4 method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCustomerV4 method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCustomerV4ForArrayConstraintsFromSetCustomerV4(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfCustomerV4CustomerV4Item) {
            // validation for constraint: itemType
            if (!$arrayOfCustomerV4CustomerV4Item instanceof \StructType\CustomerV4) {
                $invalidValues[] = is_object($arrayOfCustomerV4CustomerV4Item) ? get_class($arrayOfCustomerV4CustomerV4Item) : sprintf('%s(%s)', gettype($arrayOfCustomerV4CustomerV4Item), var_export($arrayOfCustomerV4CustomerV4Item, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The CustomerV4 property can only contain items of type \StructType\CustomerV4, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CustomerV4 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\CustomerV4[] $customerV4
     * @return \ArrayType\ArrayOfCustomerV4
     */
    public function setCustomerV4(array $customerV4 = array())
    {
        // validation for constraint: array
        if ('' !== ($customerV4ArrayErrorMessage = self::validateCustomerV4ForArrayConstraintsFromSetCustomerV4($customerV4))) {
            throw new \InvalidArgumentException($customerV4ArrayErrorMessage, __LINE__);
        }
        if (is_null($customerV4) || (is_array($customerV4) && empty($customerV4))) {
            unset($this->CustomerV4);
        } else {
            $this->CustomerV4 = $customerV4;
        }
        return $this;
    }
    /**
     * Add item to CustomerV4 value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomerV4 $item
     * @return \ArrayType\ArrayOfCustomerV4
     */
    public function addToCustomerV4(\StructType\CustomerV4 $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CustomerV4) {
            throw new \InvalidArgumentException(sprintf('The CustomerV4 property can only contain items of type \StructType\CustomerV4, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->CustomerV4[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\CustomerV4|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\CustomerV4|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\CustomerV4|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\CustomerV4|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\CustomerV4|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string CustomerV4
     */
    public function getAttributeName()
    {
        return 'CustomerV4';
    }
}
