<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for getPlacowkaPocztowa StructType
 * @subpackage Structs
 */
class GetPlacowkaPocztowa extends AbstractStructBase
{
    /**
     * The pni
     * Meta information extracted from the WSDL
     * - maxOccurs: 5000
     * - minOccurs: 1
     * @var int[]
     */
    public $pni;
    /**
     * Constructor method for getPlacowkaPocztowa
     * @uses GetPlacowkaPocztowa::setPni()
     * @param int[] $pni
     */
    public function __construct(array $pni = array())
    {
        $this
            ->setPni($pni);
    }
    /**
     * Get pni value
     * @return int[]
     */
    public function getPni()
    {
        return $this->pni;
    }
    /**
     * This method is responsible for validating the values passed to the setPni method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPni method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePniForArrayConstraintsFromSetPni(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $getPlacowkaPocztowaPniItem) {
            // validation for constraint: itemType
            if (!(is_int($getPlacowkaPocztowaPniItem) || ctype_digit($getPlacowkaPocztowaPniItem))) {
                $invalidValues[] = is_object($getPlacowkaPocztowaPniItem) ? get_class($getPlacowkaPocztowaPniItem) : sprintf('%s(%s)', gettype($getPlacowkaPocztowaPniItem), var_export($getPlacowkaPocztowaPniItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The pni property can only contain items of type int, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set pni value
     * @throws \InvalidArgumentException
     * @param int[] $pni
     * @return \StructType\GetPlacowkaPocztowa
     */
    public function setPni(array $pni = array())
    {
        // validation for constraint: array
        if ('' !== ($pniArrayErrorMessage = self::validatePniForArrayConstraintsFromSetPni($pni))) {
            throw new \InvalidArgumentException($pniArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(5000)
        if (is_array($pni) && count($pni) > 5000) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 5000', count($pni)), __LINE__);
        }
        $this->pni = $pni;
        return $this;
    }
    /**
     * Add item to pni value
     * @throws \InvalidArgumentException
     * @param int $item
     * @return \StructType\GetPlacowkaPocztowa
     */
    public function addToPni($item)
    {
        // validation for constraint: itemType
        if (!(is_int($item) || ctype_digit($item))) {
            throw new \InvalidArgumentException(sprintf('The pni property can only contain items of type int, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(5000)
        if (is_array($this->pni) && count($this->pni) >= 5000) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 5000', count($this->pni)), __LINE__);
        }
        $this->pni[] = $item;
        return $this;
    }
}
