<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for deleteReturnDocumentsProfileResponse StructType
 * @subpackage Structs
 */
class DeleteReturnDocumentsProfileResponse extends AbstractStructBase
{
    /**
     * The result
     * @var bool
     */
    public $result;
    /**
     * The idProfile
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $idProfile;
    /**
     * The error
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ErrorType[]
     */
    public $error;
    /**
     * Constructor method for deleteReturnDocumentsProfileResponse
     * @uses DeleteReturnDocumentsProfileResponse::setResult()
     * @uses DeleteReturnDocumentsProfileResponse::setIdProfile()
     * @uses DeleteReturnDocumentsProfileResponse::setError()
     * @param bool $result
     * @param int $idProfile
     * @param \StructType\ErrorType[] $error
     */
    public function __construct($result = null, $idProfile = null, array $error = array())
    {
        $this
            ->setResult($result)
            ->setIdProfile($idProfile)
            ->setError($error);
    }
    /**
     * Get result value
     * @return bool|null
     */
    public function getResult()
    {
        return $this->result;
    }
    /**
     * Set result value
     * @param bool $result
     * @return \StructType\DeleteReturnDocumentsProfileResponse
     */
    public function setResult($result = null)
    {
        // validation for constraint: boolean
        if (!is_null($result) && !is_bool($result)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($result, true), gettype($result)), __LINE__);
        }
        $this->result = $result;
        return $this;
    }
    /**
     * Get idProfile value
     * @return int|null
     */
    public function getIdProfile()
    {
        return $this->idProfile;
    }
    /**
     * Set idProfile value
     * @param int $idProfile
     * @return \StructType\DeleteReturnDocumentsProfileResponse
     */
    public function setIdProfile($idProfile = null)
    {
        // validation for constraint: int
        if (!is_null($idProfile) && !(is_int($idProfile) || ctype_digit($idProfile))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($idProfile, true), gettype($idProfile)), __LINE__);
        }
        $this->idProfile = $idProfile;
        return $this;
    }
    /**
     * Get error value
     * @return \StructType\ErrorType[]|null
     */
    public function getError()
    {
        return $this->error;
    }
    /**
     * This method is responsible for validating the values passed to the setError method
     * This method is willingly generated in order to preserve the one-line inline validation within the setError method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateErrorForArrayConstraintsFromSetError(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $deleteReturnDocumentsProfileResponseErrorItem) {
            // validation for constraint: itemType
            if (!$deleteReturnDocumentsProfileResponseErrorItem instanceof \StructType\ErrorType) {
                $invalidValues[] = is_object($deleteReturnDocumentsProfileResponseErrorItem) ? get_class($deleteReturnDocumentsProfileResponseErrorItem) : sprintf('%s(%s)', gettype($deleteReturnDocumentsProfileResponseErrorItem), var_export($deleteReturnDocumentsProfileResponseErrorItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The error property can only contain items of type \StructType\ErrorType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set error value
     * @throws \InvalidArgumentException
     * @param \StructType\ErrorType[] $error
     * @return \StructType\DeleteReturnDocumentsProfileResponse
     */
    public function setError(array $error = array())
    {
        // validation for constraint: array
        if ('' !== ($errorArrayErrorMessage = self::validateErrorForArrayConstraintsFromSetError($error))) {
            throw new \InvalidArgumentException($errorArrayErrorMessage, __LINE__);
        }
        $this->error = $error;
        return $this;
    }
    /**
     * Add item to error value
     * @throws \InvalidArgumentException
     * @param \StructType\ErrorType $item
     * @return \StructType\DeleteReturnDocumentsProfileResponse
     */
    public function addToError(\StructType\ErrorType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ErrorType) {
            throw new \InvalidArgumentException(sprintf('The error property can only contain items of type \StructType\ErrorType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->error[] = $item;
        return $this;
    }
}
