<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Create ServiceType
 * @subpackage Services
 */
class Create extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named createEnvelopeBufor
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CreateEnvelopeBufor $parameters
     * @return \StructType\CreateEnvelopeBuforResponse|bool
     */
    public function createEnvelopeBufor(\StructType\CreateEnvelopeBufor $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->createEnvelopeBufor($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named createAccount
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CreateAccount $parameters
     * @return \StructType\CreateAccountResponse|bool
     */
    public function createAccount(\StructType\CreateAccount $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->createAccount($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named createProfil
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CreateProfil $parameters
     * @return \StructType\CreateProfilResponse|bool
     */
    public function createProfil(\StructType\CreateProfil $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->createProfil($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named createShopEZwroty
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CreateShopEZwroty $parameters
     * @return \StructType\CreateShopEZwrotyResponse|bool
     */
    public function createShopEZwroty(\StructType\CreateShopEZwroty $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->createShopEZwroty($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named createParcelContent
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CreateParcelContent $parameters
     * @return \StructType\CreateParcelContentResponse|bool
     */
    public function createParcelContent(\StructType\CreateParcelContent $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->createParcelContent($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named createReturnDocumentsProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CreateReturnDocumentsProfile $parameters
     * @return \StructType\CreateReturnDocumentsProfileResponse|bool
     */
    public function createReturnDocumentsProfile(\StructType\CreateReturnDocumentsProfile $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->createReturnDocumentsProfile($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named createChecklistTemplate
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CreateChecklistTemplate $parameters
     * @return \StructType\CreateChecklistTemplateResponse|bool
     */
    public function createChecklistTemplate(\StructType\CreateChecklistTemplate $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->createChecklistTemplate($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\CreateAccountResponse|\StructType\CreateChecklistTemplateResponse|\StructType\CreateEnvelopeBuforResponse|\StructType\CreateParcelContentResponse|\StructType\CreateProfilResponse|\StructType\CreateReturnDocumentsProfileResponse|\StructType\CreateShopEZwrotyResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
