<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for przesylkaType StructType
 * @subpackage Structs
 */
abstract class PrzesylkaType extends AbstractStructBase
{
    /**
     * The guid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - length: 32
     * - use: required
     * - whiteSpace: collapse
     * @var string
     */
    public $guid;
    /**
     * The oplacaOdbiorca
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OplacaOdbiorcaType
     */
    public $oplacaOdbiorca;
    /**
     * The mpk
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $mpk;
    /**
     * The pakietGuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - length: 32
     * - whiteSpace: collapse
     * @var string
     */
    public $pakietGuid;
    /**
     * The opakowanieGuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - length: 32
     * - whiteSpace: collapse
     * @var string
     */
    public $opakowanieGuid;
    /**
     * The opis
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 500
     * - whiteSpace: collapse
     * @var string
     */
    public $opis;
    /**
     * The planowanaDataNadania
     * @var string
     */
    public $planowanaDataNadania;
    /**
     * Constructor method for przesylkaType
     * @uses PrzesylkaType::setGuid()
     * @uses PrzesylkaType::setOplacaOdbiorca()
     * @uses PrzesylkaType::setMpk()
     * @uses PrzesylkaType::setPakietGuid()
     * @uses PrzesylkaType::setOpakowanieGuid()
     * @uses PrzesylkaType::setOpis()
     * @uses PrzesylkaType::setPlanowanaDataNadania()
     * @param string $guid
     * @param \StructType\OplacaOdbiorcaType $oplacaOdbiorca
     * @param string $mpk
     * @param string $pakietGuid
     * @param string $opakowanieGuid
     * @param string $opis
     * @param string $planowanaDataNadania
     */
    public function __construct($guid = null, \StructType\OplacaOdbiorcaType $oplacaOdbiorca = null, $mpk = null, $pakietGuid = null, $opakowanieGuid = null, $opis = null, $planowanaDataNadania = null)
    {
        $this
            ->setGuid($guid)
            ->setOplacaOdbiorca($oplacaOdbiorca)
            ->setMpk($mpk)
            ->setPakietGuid($pakietGuid)
            ->setOpakowanieGuid($opakowanieGuid)
            ->setOpis($opis)
            ->setPlanowanaDataNadania($planowanaDataNadania);
    }
    /**
     * Get guid value
     * @return string
     */
    public function getGuid()
    {
        return $this->guid;
    }
    /**
     * Set guid value
     * @param string $guid
     * @return \StructType\PrzesylkaType
     */
    public function setGuid($guid = null)
    {
        // validation for constraint: string
        if (!is_null($guid) && !is_string($guid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($guid, true), gettype($guid)), __LINE__);
        }
        // validation for constraint: length(32)
        if (!is_null($guid) && mb_strlen($guid) !== 32) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 32', mb_strlen($guid)), __LINE__);
        }
        $this->guid = $guid;
        return $this;
    }
    /**
     * Get oplacaOdbiorca value
     * @return \StructType\OplacaOdbiorcaType|null
     */
    public function getOplacaOdbiorca()
    {
        return $this->oplacaOdbiorca;
    }
    /**
     * Set oplacaOdbiorca value
     * @param \StructType\OplacaOdbiorcaType $oplacaOdbiorca
     * @return \StructType\PrzesylkaType
     */
    public function setOplacaOdbiorca(\StructType\OplacaOdbiorcaType $oplacaOdbiorca = null)
    {
        $this->oplacaOdbiorca = $oplacaOdbiorca;
        return $this;
    }
    /**
     * Get mpk value
     * @return string|null
     */
    public function getMpk()
    {
        return $this->mpk;
    }
    /**
     * Set mpk value
     * @param string $mpk
     * @return \StructType\PrzesylkaType
     */
    public function setMpk($mpk = null)
    {
        // validation for constraint: string
        if (!is_null($mpk) && !is_string($mpk)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mpk, true), gettype($mpk)), __LINE__);
        }
        $this->mpk = $mpk;
        return $this;
    }
    /**
     * Get pakietGuid value
     * @return string|null
     */
    public function getPakietGuid()
    {
        return $this->pakietGuid;
    }
    /**
     * Set pakietGuid value
     * @param string $pakietGuid
     * @return \StructType\PrzesylkaType
     */
    public function setPakietGuid($pakietGuid = null)
    {
        // validation for constraint: string
        if (!is_null($pakietGuid) && !is_string($pakietGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pakietGuid, true), gettype($pakietGuid)), __LINE__);
        }
        // validation for constraint: length(32)
        if (!is_null($pakietGuid) && mb_strlen($pakietGuid) !== 32) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 32', mb_strlen($pakietGuid)), __LINE__);
        }
        $this->pakietGuid = $pakietGuid;
        return $this;
    }
    /**
     * Get opakowanieGuid value
     * @return string|null
     */
    public function getOpakowanieGuid()
    {
        return $this->opakowanieGuid;
    }
    /**
     * Set opakowanieGuid value
     * @param string $opakowanieGuid
     * @return \StructType\PrzesylkaType
     */
    public function setOpakowanieGuid($opakowanieGuid = null)
    {
        // validation for constraint: string
        if (!is_null($opakowanieGuid) && !is_string($opakowanieGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($opakowanieGuid, true), gettype($opakowanieGuid)), __LINE__);
        }
        // validation for constraint: length(32)
        if (!is_null($opakowanieGuid) && mb_strlen($opakowanieGuid) !== 32) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 32', mb_strlen($opakowanieGuid)), __LINE__);
        }
        $this->opakowanieGuid = $opakowanieGuid;
        return $this;
    }
    /**
     * Get opis value
     * @return string|null
     */
    public function getOpis()
    {
        return $this->opis;
    }
    /**
     * Set opis value
     * @param string $opis
     * @return \StructType\PrzesylkaType
     */
    public function setOpis($opis = null)
    {
        // validation for constraint: string
        if (!is_null($opis) && !is_string($opis)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($opis, true), gettype($opis)), __LINE__);
        }
        // validation for constraint: maxLength(500)
        if (!is_null($opis) && mb_strlen($opis) > 500) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 500', mb_strlen($opis)), __LINE__);
        }
        $this->opis = $opis;
        return $this;
    }
    /**
     * Get planowanaDataNadania value
     * @return string|null
     */
    public function getPlanowanaDataNadania()
    {
        return $this->planowanaDataNadania;
    }
    /**
     * Set planowanaDataNadania value
     * @param string $planowanaDataNadania
     * @return \StructType\PrzesylkaType
     */
    public function setPlanowanaDataNadania($planowanaDataNadania = null)
    {
        // validation for constraint: string
        if (!is_null($planowanaDataNadania) && !is_string($planowanaDataNadania)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($planowanaDataNadania, true), gettype($planowanaDataNadania)), __LINE__);
        }
        $this->planowanaDataNadania = $planowanaDataNadania;
        return $this;
    }
}
