<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for przesylkaProceduralnaType StructType
 * @subpackage Structs
 */
class PrzesylkaProceduralnaType extends PrzesylkaRejestrowanaType
{
    /**
     * The ubezpieczenie
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\UbezpieczenieType
     */
    public $ubezpieczenie;
    /**
     * The epo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\EPOType
     */
    public $epo;
    /**
     * The urzadWydaniaEPrzesylki
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\UrzadWydaniaEPrzesylkiType
     */
    public $urzadWydaniaEPrzesylki;
    /**
     * The pobranie
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PobranieType
     */
    public $pobranie;
    /**
     * The serwis
     * @var string
     */
    public $serwis;
    /**
     * The numerNadaniaPowrot1
     * @var string
     */
    public $numerNadaniaPowrot1;
    /**
     * The numerNadaniaPowrot2
     * @var string
     */
    public $numerNadaniaPowrot2;
    /**
     * The idPrzesylkaZawartosc
     * @var int
     */
    public $idPrzesylkaZawartosc;
    /**
     * The idListaCzynnosci
     * @var int
     */
    public $idListaCzynnosci;
    /**
     * The masa
     * Meta information extracted from the WSDL
     * - documentation: masa przesyłki podana w gramach
     * - base: xsd:int
     * - maxInclusive: 9999999
     * - minInclusive: 1
     * @var int
     */
    public $masa;
    /**
     * The opakowanie
     * @var string
     */
    public $opakowanie;
    /**
     * The numerPrzesylkiKlienta
     * @var string
     */
    public $numerPrzesylkiKlienta;
    /**
     * The wartosc
     * Meta information extracted from the WSDL
     * - documentation: zadeklarowana wartość przesyłki w groszach
     * - base: xsd:int
     * - maxInclusive: 9999999
     * - minInclusive: 0
     * @var int
     */
    public $wartosc;
    /**
     * The idAdresPrzesylkaPowrot
     * @var int
     */
    public $idAdresPrzesylkaPowrot;
    /**
     * Constructor method for przesylkaProceduralnaType
     * @uses PrzesylkaProceduralnaType::setUbezpieczenie()
     * @uses PrzesylkaProceduralnaType::setEpo()
     * @uses PrzesylkaProceduralnaType::setUrzadWydaniaEPrzesylki()
     * @uses PrzesylkaProceduralnaType::setPobranie()
     * @uses PrzesylkaProceduralnaType::setSerwis()
     * @uses PrzesylkaProceduralnaType::setNumerNadaniaPowrot1()
     * @uses PrzesylkaProceduralnaType::setNumerNadaniaPowrot2()
     * @uses PrzesylkaProceduralnaType::setIdPrzesylkaZawartosc()
     * @uses PrzesylkaProceduralnaType::setIdListaCzynnosci()
     * @uses PrzesylkaProceduralnaType::setMasa()
     * @uses PrzesylkaProceduralnaType::setOpakowanie()
     * @uses PrzesylkaProceduralnaType::setNumerPrzesylkiKlienta()
     * @uses PrzesylkaProceduralnaType::setWartosc()
     * @uses PrzesylkaProceduralnaType::setIdAdresPrzesylkaPowrot()
     * @param \StructType\UbezpieczenieType $ubezpieczenie
     * @param \StructType\EPOType $epo
     * @param \StructType\UrzadWydaniaEPrzesylkiType $urzadWydaniaEPrzesylki
     * @param \StructType\PobranieType $pobranie
     * @param string $serwis
     * @param string $numerNadaniaPowrot1
     * @param string $numerNadaniaPowrot2
     * @param int $idPrzesylkaZawartosc
     * @param int $idListaCzynnosci
     * @param int $masa
     * @param string $opakowanie
     * @param string $numerPrzesylkiKlienta
     * @param int $wartosc
     * @param int $idAdresPrzesylkaPowrot
     */
    public function __construct(\StructType\UbezpieczenieType $ubezpieczenie = null, \StructType\EPOType $epo = null, \StructType\UrzadWydaniaEPrzesylkiType $urzadWydaniaEPrzesylki = null, \StructType\PobranieType $pobranie = null, $serwis = null, $numerNadaniaPowrot1 = null, $numerNadaniaPowrot2 = null, $idPrzesylkaZawartosc = null, $idListaCzynnosci = null, $masa = null, $opakowanie = null, $numerPrzesylkiKlienta = null, $wartosc = null, $idAdresPrzesylkaPowrot = null)
    {
        $this
            ->setUbezpieczenie($ubezpieczenie)
            ->setEpo($epo)
            ->setUrzadWydaniaEPrzesylki($urzadWydaniaEPrzesylki)
            ->setPobranie($pobranie)
            ->setSerwis($serwis)
            ->setNumerNadaniaPowrot1($numerNadaniaPowrot1)
            ->setNumerNadaniaPowrot2($numerNadaniaPowrot2)
            ->setIdPrzesylkaZawartosc($idPrzesylkaZawartosc)
            ->setIdListaCzynnosci($idListaCzynnosci)
            ->setMasa($masa)
            ->setOpakowanie($opakowanie)
            ->setNumerPrzesylkiKlienta($numerPrzesylkiKlienta)
            ->setWartosc($wartosc)
            ->setIdAdresPrzesylkaPowrot($idAdresPrzesylkaPowrot);
    }
    /**
     * Get ubezpieczenie value
     * @return \StructType\UbezpieczenieType|null
     */
    public function getUbezpieczenie()
    {
        return $this->ubezpieczenie;
    }
    /**
     * Set ubezpieczenie value
     * @param \StructType\UbezpieczenieType $ubezpieczenie
     * @return \StructType\PrzesylkaProceduralnaType
     */
    public function setUbezpieczenie(\StructType\UbezpieczenieType $ubezpieczenie = null)
    {
        $this->ubezpieczenie = $ubezpieczenie;
        return $this;
    }
    /**
     * Get epo value
     * @return \StructType\EPOType|null
     */
    public function getEpo()
    {
        return $this->epo;
    }
    /**
     * Set epo value
     * @param \StructType\EPOType $epo
     * @return \StructType\PrzesylkaProceduralnaType
     */
    public function setEpo(\StructType\EPOType $epo = null)
    {
        $this->epo = $epo;
        return $this;
    }
    /**
     * Get urzadWydaniaEPrzesylki value
     * @return \StructType\UrzadWydaniaEPrzesylkiType|null
     */
    public function getUrzadWydaniaEPrzesylki()
    {
        return $this->urzadWydaniaEPrzesylki;
    }
    /**
     * Set urzadWydaniaEPrzesylki value
     * @param \StructType\UrzadWydaniaEPrzesylkiType $urzadWydaniaEPrzesylki
     * @return \StructType\PrzesylkaProceduralnaType
     */
    public function setUrzadWydaniaEPrzesylki(\StructType\UrzadWydaniaEPrzesylkiType $urzadWydaniaEPrzesylki = null)
    {
        $this->urzadWydaniaEPrzesylki = $urzadWydaniaEPrzesylki;
        return $this;
    }
    /**
     * Get pobranie value
     * @return \StructType\PobranieType|null
     */
    public function getPobranie()
    {
        return $this->pobranie;
    }
    /**
     * Set pobranie value
     * @param \StructType\PobranieType $pobranie
     * @return \StructType\PrzesylkaProceduralnaType
     */
    public function setPobranie(\StructType\PobranieType $pobranie = null)
    {
        $this->pobranie = $pobranie;
        return $this;
    }
    /**
     * Get serwis value
     * @return string|null
     */
    public function getSerwis()
    {
        return $this->serwis;
    }
    /**
     * Set serwis value
     * @uses \EnumType\SerwisPrzesylkaProceduralnaType::valueIsValid()
     * @uses \EnumType\SerwisPrzesylkaProceduralnaType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $serwis
     * @return \StructType\PrzesylkaProceduralnaType
     */
    public function setSerwis($serwis = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\SerwisPrzesylkaProceduralnaType::valueIsValid($serwis)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\SerwisPrzesylkaProceduralnaType', is_array($serwis) ? implode(', ', $serwis) : var_export($serwis, true), implode(', ', \EnumType\SerwisPrzesylkaProceduralnaType::getValidValues())), __LINE__);
        }
        $this->serwis = $serwis;
        return $this;
    }
    /**
     * Get numerNadaniaPowrot1 value
     * @return string|null
     */
    public function getNumerNadaniaPowrot1()
    {
        return $this->numerNadaniaPowrot1;
    }
    /**
     * Set numerNadaniaPowrot1 value
     * @param string $numerNadaniaPowrot1
     * @return \StructType\PrzesylkaProceduralnaType
     */
    public function setNumerNadaniaPowrot1($numerNadaniaPowrot1 = null)
    {
        // validation for constraint: string
        if (!is_null($numerNadaniaPowrot1) && !is_string($numerNadaniaPowrot1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($numerNadaniaPowrot1, true), gettype($numerNadaniaPowrot1)), __LINE__);
        }
        $this->numerNadaniaPowrot1 = $numerNadaniaPowrot1;
        return $this;
    }
    /**
     * Get numerNadaniaPowrot2 value
     * @return string|null
     */
    public function getNumerNadaniaPowrot2()
    {
        return $this->numerNadaniaPowrot2;
    }
    /**
     * Set numerNadaniaPowrot2 value
     * @param string $numerNadaniaPowrot2
     * @return \StructType\PrzesylkaProceduralnaType
     */
    public function setNumerNadaniaPowrot2($numerNadaniaPowrot2 = null)
    {
        // validation for constraint: string
        if (!is_null($numerNadaniaPowrot2) && !is_string($numerNadaniaPowrot2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($numerNadaniaPowrot2, true), gettype($numerNadaniaPowrot2)), __LINE__);
        }
        $this->numerNadaniaPowrot2 = $numerNadaniaPowrot2;
        return $this;
    }
    /**
     * Get idPrzesylkaZawartosc value
     * @return int|null
     */
    public function getIdPrzesylkaZawartosc()
    {
        return $this->idPrzesylkaZawartosc;
    }
    /**
     * Set idPrzesylkaZawartosc value
     * @param int $idPrzesylkaZawartosc
     * @return \StructType\PrzesylkaProceduralnaType
     */
    public function setIdPrzesylkaZawartosc($idPrzesylkaZawartosc = null)
    {
        // validation for constraint: int
        if (!is_null($idPrzesylkaZawartosc) && !(is_int($idPrzesylkaZawartosc) || ctype_digit($idPrzesylkaZawartosc))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($idPrzesylkaZawartosc, true), gettype($idPrzesylkaZawartosc)), __LINE__);
        }
        $this->idPrzesylkaZawartosc = $idPrzesylkaZawartosc;
        return $this;
    }
    /**
     * Get idListaCzynnosci value
     * @return int|null
     */
    public function getIdListaCzynnosci()
    {
        return $this->idListaCzynnosci;
    }
    /**
     * Set idListaCzynnosci value
     * @param int $idListaCzynnosci
     * @return \StructType\PrzesylkaProceduralnaType
     */
    public function setIdListaCzynnosci($idListaCzynnosci = null)
    {
        // validation for constraint: int
        if (!is_null($idListaCzynnosci) && !(is_int($idListaCzynnosci) || ctype_digit($idListaCzynnosci))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($idListaCzynnosci, true), gettype($idListaCzynnosci)), __LINE__);
        }
        $this->idListaCzynnosci = $idListaCzynnosci;
        return $this;
    }
    /**
     * Get masa value
     * @return int|null
     */
    public function getMasa()
    {
        return $this->masa;
    }
    /**
     * Set masa value
     * @param int $masa
     * @return \StructType\PrzesylkaProceduralnaType
     */
    public function setMasa($masa = null)
    {
        // validation for constraint: int
        if (!is_null($masa) && !(is_int($masa) || ctype_digit($masa))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($masa, true), gettype($masa)), __LINE__);
        }
        // validation for constraint: maxInclusive(9999999)
        if (!is_null($masa) && $masa > 9999999) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 9999999', var_export($masa, true)), __LINE__);
        }
        // validation for constraint: minInclusive(1)
        if (!is_null($masa) && $masa < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 1', var_export($masa, true)), __LINE__);
        }
        $this->masa = $masa;
        return $this;
    }
    /**
     * Get opakowanie value
     * @return string|null
     */
    public function getOpakowanie()
    {
        return $this->opakowanie;
    }
    /**
     * Set opakowanie value
     * @uses \EnumType\OpakowaniePrzesylkaProceduralnaType::valueIsValid()
     * @uses \EnumType\OpakowaniePrzesylkaProceduralnaType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $opakowanie
     * @return \StructType\PrzesylkaProceduralnaType
     */
    public function setOpakowanie($opakowanie = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\OpakowaniePrzesylkaProceduralnaType::valueIsValid($opakowanie)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\OpakowaniePrzesylkaProceduralnaType', is_array($opakowanie) ? implode(', ', $opakowanie) : var_export($opakowanie, true), implode(', ', \EnumType\OpakowaniePrzesylkaProceduralnaType::getValidValues())), __LINE__);
        }
        $this->opakowanie = $opakowanie;
        return $this;
    }
    /**
     * Get numerPrzesylkiKlienta value
     * @return string|null
     */
    public function getNumerPrzesylkiKlienta()
    {
        return $this->numerPrzesylkiKlienta;
    }
    /**
     * Set numerPrzesylkiKlienta value
     * @param string $numerPrzesylkiKlienta
     * @return \StructType\PrzesylkaProceduralnaType
     */
    public function setNumerPrzesylkiKlienta($numerPrzesylkiKlienta = null)
    {
        // validation for constraint: string
        if (!is_null($numerPrzesylkiKlienta) && !is_string($numerPrzesylkiKlienta)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($numerPrzesylkiKlienta, true), gettype($numerPrzesylkiKlienta)), __LINE__);
        }
        $this->numerPrzesylkiKlienta = $numerPrzesylkiKlienta;
        return $this;
    }
    /**
     * Get wartosc value
     * @return int|null
     */
    public function getWartosc()
    {
        return $this->wartosc;
    }
    /**
     * Set wartosc value
     * @param int $wartosc
     * @return \StructType\PrzesylkaProceduralnaType
     */
    public function setWartosc($wartosc = null)
    {
        // validation for constraint: int
        if (!is_null($wartosc) && !(is_int($wartosc) || ctype_digit($wartosc))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($wartosc, true), gettype($wartosc)), __LINE__);
        }
        // validation for constraint: maxInclusive(9999999)
        if (!is_null($wartosc) && $wartosc > 9999999) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 9999999', var_export($wartosc, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($wartosc) && $wartosc < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($wartosc, true)), __LINE__);
        }
        $this->wartosc = $wartosc;
        return $this;
    }
    /**
     * Get idAdresPrzesylkaPowrot value
     * @return int|null
     */
    public function getIdAdresPrzesylkaPowrot()
    {
        return $this->idAdresPrzesylkaPowrot;
    }
    /**
     * Set idAdresPrzesylkaPowrot value
     * @param int $idAdresPrzesylkaPowrot
     * @return \StructType\PrzesylkaProceduralnaType
     */
    public function setIdAdresPrzesylkaPowrot($idAdresPrzesylkaPowrot = null)
    {
        // validation for constraint: int
        if (!is_null($idAdresPrzesylkaPowrot) && !(is_int($idAdresPrzesylkaPowrot) || ctype_digit($idAdresPrzesylkaPowrot))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($idAdresPrzesylkaPowrot, true), gettype($idAdresPrzesylkaPowrot)), __LINE__);
        }
        $this->idAdresPrzesylkaPowrot = $idAdresPrzesylkaPowrot;
        return $this;
    }
}
