<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PrintType StructType
 * @subpackage Structs
 */
class PrintType extends AbstractStructBase
{
    /**
     * The kind
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $kind;
    /**
     * The method
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $method;
    /**
     * The format
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $format;
    /**
     * The resolution
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $resolution;
    /**
     * Constructor method for PrintType
     * @uses PrintType::setKind()
     * @uses PrintType::setMethod()
     * @uses PrintType::setFormat()
     * @uses PrintType::setResolution()
     * @param string $kind
     * @param string $method
     * @param string $format
     * @param string $resolution
     */
    public function __construct($kind = null, $method = null, $format = null, $resolution = null)
    {
        $this
            ->setKind($kind)
            ->setMethod($method)
            ->setFormat($format)
            ->setResolution($resolution);
    }
    /**
     * Get kind value
     * @return string
     */
    public function getKind()
    {
        return $this->kind;
    }
    /**
     * Set kind value
     * @uses \EnumType\PrintKindEnum::valueIsValid()
     * @uses \EnumType\PrintKindEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $kind
     * @return \StructType\PrintType
     */
    public function setKind($kind = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\PrintKindEnum::valueIsValid($kind)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\PrintKindEnum', is_array($kind) ? implode(', ', $kind) : var_export($kind, true), implode(', ', \EnumType\PrintKindEnum::getValidValues())), __LINE__);
        }
        $this->kind = $kind;
        return $this;
    }
    /**
     * Get method value
     * @return string
     */
    public function getMethod()
    {
        return $this->method;
    }
    /**
     * Set method value
     * @uses \EnumType\PrintMethodEnum::valueIsValid()
     * @uses \EnumType\PrintMethodEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $method
     * @return \StructType\PrintType
     */
    public function setMethod($method = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\PrintMethodEnum::valueIsValid($method)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\PrintMethodEnum', is_array($method) ? implode(', ', $method) : var_export($method, true), implode(', ', \EnumType\PrintMethodEnum::getValidValues())), __LINE__);
        }
        $this->method = $method;
        return $this;
    }
    /**
     * Get format value
     * @return string|null
     */
    public function getFormat()
    {
        return $this->format;
    }
    /**
     * Set format value
     * @uses \EnumType\PrintFormatEnum::valueIsValid()
     * @uses \EnumType\PrintFormatEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $format
     * @return \StructType\PrintType
     */
    public function setFormat($format = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\PrintFormatEnum::valueIsValid($format)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\PrintFormatEnum', is_array($format) ? implode(', ', $format) : var_export($format, true), implode(', ', \EnumType\PrintFormatEnum::getValidValues())), __LINE__);
        }
        $this->format = $format;
        return $this;
    }
    /**
     * Get resolution value
     * @return string|null
     */
    public function getResolution()
    {
        return $this->resolution;
    }
    /**
     * Set resolution value
     * @uses \EnumType\PrintResolutionEnum::valueIsValid()
     * @uses \EnumType\PrintResolutionEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $resolution
     * @return \StructType\PrintType
     */
    public function setResolution($resolution = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\PrintResolutionEnum::valueIsValid($resolution)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\PrintResolutionEnum', is_array($resolution) ? implode(', ', $resolution) : var_export($resolution, true), implode(', ', \EnumType\PrintResolutionEnum::getValidValues())), __LINE__);
        }
        $this->resolution = $resolution;
        return $this;
    }
}
