<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for createParcelContentResponse StructType
 * @subpackage Structs
 */
class CreateParcelContentResponse extends AbstractStructBase
{
    /**
     * The parcelContent
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ParcelContentType[]
     */
    public $parcelContent;
    /**
     * The error
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ErrorType[]
     */
    public $error;
    /**
     * Constructor method for createParcelContentResponse
     * @uses CreateParcelContentResponse::setParcelContent()
     * @uses CreateParcelContentResponse::setError()
     * @param \StructType\ParcelContentType[] $parcelContent
     * @param \StructType\ErrorType[] $error
     */
    public function __construct(array $parcelContent = array(), array $error = array())
    {
        $this
            ->setParcelContent($parcelContent)
            ->setError($error);
    }
    /**
     * Get parcelContent value
     * @return \StructType\ParcelContentType[]|null
     */
    public function getParcelContent()
    {
        return $this->parcelContent;
    }
    /**
     * This method is responsible for validating the values passed to the setParcelContent method
     * This method is willingly generated in order to preserve the one-line inline validation within the setParcelContent method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateParcelContentForArrayConstraintsFromSetParcelContent(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $createParcelContentResponseParcelContentItem) {
            // validation for constraint: itemType
            if (!$createParcelContentResponseParcelContentItem instanceof \StructType\ParcelContentType) {
                $invalidValues[] = is_object($createParcelContentResponseParcelContentItem) ? get_class($createParcelContentResponseParcelContentItem) : sprintf('%s(%s)', gettype($createParcelContentResponseParcelContentItem), var_export($createParcelContentResponseParcelContentItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The parcelContent property can only contain items of type \StructType\ParcelContentType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set parcelContent value
     * @throws \InvalidArgumentException
     * @param \StructType\ParcelContentType[] $parcelContent
     * @return \StructType\CreateParcelContentResponse
     */
    public function setParcelContent(array $parcelContent = array())
    {
        // validation for constraint: array
        if ('' !== ($parcelContentArrayErrorMessage = self::validateParcelContentForArrayConstraintsFromSetParcelContent($parcelContent))) {
            throw new \InvalidArgumentException($parcelContentArrayErrorMessage, __LINE__);
        }
        $this->parcelContent = $parcelContent;
        return $this;
    }
    /**
     * Add item to parcelContent value
     * @throws \InvalidArgumentException
     * @param \StructType\ParcelContentType $item
     * @return \StructType\CreateParcelContentResponse
     */
    public function addToParcelContent(\StructType\ParcelContentType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ParcelContentType) {
            throw new \InvalidArgumentException(sprintf('The parcelContent property can only contain items of type \StructType\ParcelContentType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->parcelContent[] = $item;
        return $this;
    }
    /**
     * Get error value
     * @return \StructType\ErrorType[]|null
     */
    public function getError()
    {
        return $this->error;
    }
    /**
     * This method is responsible for validating the values passed to the setError method
     * This method is willingly generated in order to preserve the one-line inline validation within the setError method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateErrorForArrayConstraintsFromSetError(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $createParcelContentResponseErrorItem) {
            // validation for constraint: itemType
            if (!$createParcelContentResponseErrorItem instanceof \StructType\ErrorType) {
                $invalidValues[] = is_object($createParcelContentResponseErrorItem) ? get_class($createParcelContentResponseErrorItem) : sprintf('%s(%s)', gettype($createParcelContentResponseErrorItem), var_export($createParcelContentResponseErrorItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The error property can only contain items of type \StructType\ErrorType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set error value
     * @throws \InvalidArgumentException
     * @param \StructType\ErrorType[] $error
     * @return \StructType\CreateParcelContentResponse
     */
    public function setError(array $error = array())
    {
        // validation for constraint: array
        if ('' !== ($errorArrayErrorMessage = self::validateErrorForArrayConstraintsFromSetError($error))) {
            throw new \InvalidArgumentException($errorArrayErrorMessage, __LINE__);
        }
        $this->error = $error;
        return $this;
    }
    /**
     * Add item to error value
     * @throws \InvalidArgumentException
     * @param \StructType\ErrorType $item
     * @return \StructType\CreateParcelContentResponse
     */
    public function addToError(\StructType\ErrorType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ErrorType) {
            throw new \InvalidArgumentException(sprintf('The error property can only contain items of type \StructType\ErrorType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->error[] = $item;
        return $this;
    }
}
