<?php

namespace Dpd\Services\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for parcelsAppendV2 StructType
 * @subpackage Structs
 */
class ParcelsAppendV2 extends AbstractStructBase
{
    /**
     * The packagesearchCriteria
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Dpd\Services\StructType\ParcelsAppendSearchCriteriaPAV1
     */
    public $packagesearchCriteria;
    /**
     * The parcels
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \Dpd\Services\StructType\ParcelAppendPAV2[]
     */
    public $parcels;
    /**
     * Constructor method for parcelsAppendV2
     * @uses ParcelsAppendV2::setPackagesearchCriteria()
     * @uses ParcelsAppendV2::setParcels()
     * @param \Dpd\Services\StructType\ParcelsAppendSearchCriteriaPAV1 $packagesearchCriteria
     * @param \Dpd\Services\StructType\ParcelAppendPAV2[] $parcels
     */
    public function __construct(\Dpd\Services\StructType\ParcelsAppendSearchCriteriaPAV1 $packagesearchCriteria = null, array $parcels = array())
    {
        $this
            ->setPackagesearchCriteria($packagesearchCriteria)
            ->setParcels($parcels);
    }
    /**
     * Get packagesearchCriteria value
     * @return \Dpd\Services\StructType\ParcelsAppendSearchCriteriaPAV1|null
     */
    public function getPackagesearchCriteria()
    {
        return $this->packagesearchCriteria;
    }
    /**
     * Set packagesearchCriteria value
     * @param \Dpd\Services\StructType\ParcelsAppendSearchCriteriaPAV1 $packagesearchCriteria
     * @return \Dpd\Services\StructType\ParcelsAppendV2
     */
    public function setPackagesearchCriteria(\Dpd\Services\StructType\ParcelsAppendSearchCriteriaPAV1 $packagesearchCriteria = null)
    {
        $this->packagesearchCriteria = $packagesearchCriteria;
        return $this;
    }
    /**
     * Get parcels value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Dpd\Services\StructType\ParcelAppendPAV2[]|null
     */
    public function getParcels()
    {
        return isset($this->parcels) ? $this->parcels : null;
    }
    /**
     * Set parcels value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Dpd\Services\StructType\ParcelAppendPAV2[] $parcels
     * @return \Dpd\Services\StructType\ParcelsAppendV2
     */
    public function setParcels(array $parcels = array())
    {
        if (is_null($parcels) || (is_array($parcels) && empty($parcels))) {
            unset($this->parcels);
        } else {
            $this->parcels = $parcels;
        }
        return $this;
    }
    /**
     * Add item to parcels value
     * @throws \InvalidArgumentException
     * @param \Dpd\Services\StructType\ParcelAppendPAV2 $item
     * @return \Dpd\Services\StructType\ParcelsAppendV2
     */
    public function addToParcels(\Dpd\Services\StructType\ParcelAppendPAV2 $item)
    {
        $this->parcels[] = $item;
        return $this;
    }
}
