<?php

namespace Dpd\Services\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for authDataV1 StructType
 * @subpackage Structs
 */
class AuthDataV1 extends AbstractStructBase
{
    /**
     * The login
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $login;
    /**
     * The masterFid
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $masterFid;
    /**
     * The password
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $password;
    /**
     * Constructor method for authDataV1
     * @uses AuthDataV1::setLogin()
     * @uses AuthDataV1::setMasterFid()
     * @uses AuthDataV1::setPassword()
     * @param string $login
     * @param int $masterFid
     * @param string $password
     */
    public function __construct($login = null, $masterFid = null, $password = null)
    {
        $this
            ->setLogin($login)
            ->setMasterFid($masterFid)
            ->setPassword($password);
    }
    /**
     * Get login value
     * @return string|null
     */
    public function getLogin()
    {
        return $this->login;
    }
    /**
     * Set login value
     * @param string $login
     * @return \Dpd\Services\StructType\AuthDataV1
     */
    public function setLogin($login = null)
    {
        $this->login = $login;
        return $this;
    }
    /**
     * Get masterFid value
     * @return int|null
     */
    public function getMasterFid()
    {
        return $this->masterFid;
    }
    /**
     * Set masterFid value
     * @param int $masterFid
     * @return \Dpd\Services\StructType\AuthDataV1
     */
    public function setMasterFid($masterFid = null)
    {
        $this->masterFid = $masterFid;
        return $this;
    }
    /**
     * Get password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->password;
    }
    /**
     * Set password value
     * @param string $password
     * @return \Dpd\Services\StructType\AuthDataV1
     */
    public function setPassword($password = null)
    {
        $this->password = $password;
        return $this;
    }
}
