<?php

namespace Dpd\Services\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for parcelPGRV2 StructType
 * @subpackage Structs
 */
class ParcelPGRV2 extends AbstractStructBase
{
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Status;
    /**
     * The ParcelId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ParcelId;
    /**
     * The Reference
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Reference;
    /**
     * The Waybill
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Waybill;
    /**
     * The ValidationDetails
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Dpd\Services\StructType\ValidationDetails
     */
    public $ValidationDetails;
    /**
     * Constructor method for parcelPGRV2
     * @uses ParcelPGRV2::setStatus()
     * @uses ParcelPGRV2::setParcelId()
     * @uses ParcelPGRV2::setReference()
     * @uses ParcelPGRV2::setWaybill()
     * @uses ParcelPGRV2::setValidationDetails()
     * @param string $status
     * @param int $parcelId
     * @param string $reference
     * @param string $waybill
     * @param \Dpd\Services\StructType\ValidationDetails $validationDetails
     */
    public function __construct($status = null, $parcelId = null, $reference = null, $waybill = null, \Dpd\Services\StructType\ValidationDetails $validationDetails = null)
    {
        $this
            ->setStatus($status)
            ->setParcelId($parcelId)
            ->setReference($reference)
            ->setWaybill($waybill)
            ->setValidationDetails($validationDetails);
    }
    /**
     * Get Status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param string $status
     * @return \Dpd\Services\StructType\ParcelPGRV2
     */
    public function setStatus($status = null)
    {
        $this->Status = $status;
        return $this;
    }
    /**
     * Get ParcelId value
     * @return int|null
     */
    public function getParcelId()
    {
        return $this->ParcelId;
    }
    /**
     * Set ParcelId value
     * @param int $parcelId
     * @return \Dpd\Services\StructType\ParcelPGRV2
     */
    public function setParcelId($parcelId = null)
    {
        $this->ParcelId = $parcelId;
        return $this;
    }
    /**
     * Get Reference value
     * @return string|null
     */
    public function getReference()
    {
        return $this->Reference;
    }
    /**
     * Set Reference value
     * @param string $reference
     * @return \Dpd\Services\StructType\ParcelPGRV2
     */
    public function setReference($reference = null)
    {
        $this->Reference = $reference;
        return $this;
    }
    /**
     * Get Waybill value
     * @return string|null
     */
    public function getWaybill()
    {
        return $this->Waybill;
    }
    /**
     * Set Waybill value
     * @param string $waybill
     * @return \Dpd\Services\StructType\ParcelPGRV2
     */
    public function setWaybill($waybill = null)
    {
        $this->Waybill = $waybill;
        return $this;
    }
    /**
     * Get ValidationDetails value
     * @return \Dpd\Services\StructType\ValidationDetails|null
     */
    public function getValidationDetails()
    {
        return $this->ValidationDetails;
    }
    /**
     * Set ValidationDetails value
     * @param \Dpd\Services\StructType\ValidationDetails $validationDetails
     * @return \Dpd\Services\StructType\ParcelPGRV2
     */
    public function setValidationDetails(\Dpd\Services\StructType\ValidationDetails $validationDetails = null)
    {
        $this->ValidationDetails = $validationDetails;
        return $this;
    }
}
