<?php

namespace Dpd\Services\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for packagesPickupCallResponseV1 StructType
 * @subpackage Structs
 */
class PackagesPickupCallResponseV1 extends AbstractStructBase
{
    /**
     * The orderNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $orderNumber;
    /**
     * The prototocols
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \Dpd\Services\StructType\ProtocolPCRV1[]
     */
    public $prototocols;
    /**
     * Constructor method for packagesPickupCallResponseV1
     * @uses PackagesPickupCallResponseV1::setOrderNumber()
     * @uses PackagesPickupCallResponseV1::setPrototocols()
     * @param string $orderNumber
     * @param \Dpd\Services\StructType\ProtocolPCRV1[] $prototocols
     */
    public function __construct($orderNumber = null, array $prototocols = array())
    {
        $this
            ->setOrderNumber($orderNumber)
            ->setPrototocols($prototocols);
    }
    /**
     * Get orderNumber value
     * @return string|null
     */
    public function getOrderNumber()
    {
        return $this->orderNumber;
    }
    /**
     * Set orderNumber value
     * @param string $orderNumber
     * @return \Dpd\Services\StructType\PackagesPickupCallResponseV1
     */
    public function setOrderNumber($orderNumber = null)
    {
        $this->orderNumber = $orderNumber;
        return $this;
    }
    /**
     * Get prototocols value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Dpd\Services\StructType\ProtocolPCRV1[]|null
     */
    public function getPrototocols()
    {
        return isset($this->prototocols) ? $this->prototocols : null;
    }
    /**
     * Set prototocols value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Dpd\Services\StructType\ProtocolPCRV1[] $prototocols
     * @return \Dpd\Services\StructType\PackagesPickupCallResponseV1
     */
    public function setPrototocols(array $prototocols = array())
    {
        if (is_null($prototocols) || (is_array($prototocols) && empty($prototocols))) {
            unset($this->prototocols);
        } else {
            $this->prototocols = $prototocols;
        }
        return $this;
    }
    /**
     * Add item to prototocols value
     * @throws \InvalidArgumentException
     * @param \Dpd\Services\StructType\ProtocolPCRV1 $item
     * @return \Dpd\Services\StructType\PackagesPickupCallResponseV1
     */
    public function addToPrototocols(\Dpd\Services\StructType\ProtocolPCRV1 $item)
    {
        $this->prototocols[] = $item;
        return $this;
    }
}
