<?php

namespace Dpd\Services\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for dpdPickupCallParamsV1 StructType
 * @subpackage Structs
 */
class DpdPickupCallParamsV1 extends AbstractStructBase
{
    /**
     * The contactInfo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Dpd\Services\StructType\ContactInfoDPPV1
     */
    public $contactInfo;
    /**
     * The pickupAddress
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Dpd\Services\StructType\PickupAddressDSPV1
     */
    public $pickupAddress;
    /**
     * The pickupDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $pickupDate;
    /**
     * The pickupTimeFrom
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $pickupTimeFrom;
    /**
     * The pickupTimeTo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $pickupTimeTo;
    /**
     * The policy
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $policy;
    /**
     * The protocols
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \Dpd\Services\StructType\ProtocolDPPV1[]
     */
    public $protocols;
    /**
     * Constructor method for dpdPickupCallParamsV1
     * @uses DpdPickupCallParamsV1::setContactInfo()
     * @uses DpdPickupCallParamsV1::setPickupAddress()
     * @uses DpdPickupCallParamsV1::setPickupDate()
     * @uses DpdPickupCallParamsV1::setPickupTimeFrom()
     * @uses DpdPickupCallParamsV1::setPickupTimeTo()
     * @uses DpdPickupCallParamsV1::setPolicy()
     * @uses DpdPickupCallParamsV1::setProtocols()
     * @param \Dpd\Services\StructType\ContactInfoDPPV1 $contactInfo
     * @param \Dpd\Services\StructType\PickupAddressDSPV1 $pickupAddress
     * @param string $pickupDate
     * @param string $pickupTimeFrom
     * @param string $pickupTimeTo
     * @param string $policy
     * @param \Dpd\Services\StructType\ProtocolDPPV1[] $protocols
     */
    public function __construct(\Dpd\Services\StructType\ContactInfoDPPV1 $contactInfo = null, \Dpd\Services\StructType\PickupAddressDSPV1 $pickupAddress = null, $pickupDate = null, $pickupTimeFrom = null, $pickupTimeTo = null, $policy = null, array $protocols = array())
    {
        $this
            ->setContactInfo($contactInfo)
            ->setPickupAddress($pickupAddress)
            ->setPickupDate($pickupDate)
            ->setPickupTimeFrom($pickupTimeFrom)
            ->setPickupTimeTo($pickupTimeTo)
            ->setPolicy($policy)
            ->setProtocols($protocols);
    }
    /**
     * Get contactInfo value
     * @return \Dpd\Services\StructType\ContactInfoDPPV1|null
     */
    public function getContactInfo()
    {
        return $this->contactInfo;
    }
    /**
     * Set contactInfo value
     * @param \Dpd\Services\StructType\ContactInfoDPPV1 $contactInfo
     * @return \Dpd\Services\StructType\DpdPickupCallParamsV1
     */
    public function setContactInfo(\Dpd\Services\StructType\ContactInfoDPPV1 $contactInfo = null)
    {
        $this->contactInfo = $contactInfo;
        return $this;
    }
    /**
     * Get pickupAddress value
     * @return \Dpd\Services\StructType\PickupAddressDSPV1|null
     */
    public function getPickupAddress()
    {
        return $this->pickupAddress;
    }
    /**
     * Set pickupAddress value
     * @param \Dpd\Services\StructType\PickupAddressDSPV1 $pickupAddress
     * @return \Dpd\Services\StructType\DpdPickupCallParamsV1
     */
    public function setPickupAddress(\Dpd\Services\StructType\PickupAddressDSPV1 $pickupAddress = null)
    {
        $this->pickupAddress = $pickupAddress;
        return $this;
    }
    /**
     * Get pickupDate value
     * @return string|null
     */
    public function getPickupDate()
    {
        return $this->pickupDate;
    }
    /**
     * Set pickupDate value
     * @param string $pickupDate
     * @return \Dpd\Services\StructType\DpdPickupCallParamsV1
     */
    public function setPickupDate($pickupDate = null)
    {
        $this->pickupDate = $pickupDate;
        return $this;
    }
    /**
     * Get pickupTimeFrom value
     * @return string|null
     */
    public function getPickupTimeFrom()
    {
        return $this->pickupTimeFrom;
    }
    /**
     * Set pickupTimeFrom value
     * @param string $pickupTimeFrom
     * @return \Dpd\Services\StructType\DpdPickupCallParamsV1
     */
    public function setPickupTimeFrom($pickupTimeFrom = null)
    {
        $this->pickupTimeFrom = $pickupTimeFrom;
        return $this;
    }
    /**
     * Get pickupTimeTo value
     * @return string|null
     */
    public function getPickupTimeTo()
    {
        return $this->pickupTimeTo;
    }
    /**
     * Set pickupTimeTo value
     * @param string $pickupTimeTo
     * @return \Dpd\Services\StructType\DpdPickupCallParamsV1
     */
    public function setPickupTimeTo($pickupTimeTo = null)
    {
        $this->pickupTimeTo = $pickupTimeTo;
        return $this;
    }
    /**
     * Get policy value
     * @return string|null
     */
    public function getPolicy()
    {
        return $this->policy;
    }
    /**
     * Set policy value
     * @param string $policy
     * @return \Dpd\Services\StructType\DpdPickupCallParamsV1
     */
    public function setPolicy($policy = null)
    {
        $this->policy = $policy;
        return $this;
    }
    /**
     * Get protocols value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Dpd\Services\StructType\ProtocolDPPV1[]|null
     */
    public function getProtocols()
    {
        return isset($this->protocols) ? $this->protocols : null;
    }
    /**
     * Set protocols value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Dpd\Services\StructType\ProtocolDPPV1[] $protocols
     * @return \Dpd\Services\StructType\DpdPickupCallParamsV1
     */
    public function setProtocols(array $protocols = array())
    {
        if (is_null($protocols) || (is_array($protocols) && empty($protocols))) {
            unset($this->protocols);
        } else {
            $this->protocols = $protocols;
        }
        return $this;
    }
    /**
     * Add item to protocols value
     * @throws \InvalidArgumentException
     * @param \Dpd\Services\StructType\ProtocolDPPV1 $item
     * @return \Dpd\Services\StructType\DpdPickupCallParamsV1
     */
    public function addToProtocols(\Dpd\Services\StructType\ProtocolDPPV1 $item)
    {
        $this->protocols[] = $item;
        return $this;
    }
}
