<?php

namespace Dpd\Services\Service;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Append Service
 * @subpackage Services
 */
class Append extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named appendParcelsToPackageV1
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Dpd\Services\StructType\AppendParcelsToPackageV1 $parameters
     * @return \Dpd\Services\StructType\AppendParcelsToPackageV1Response|bool
     */
    public function appendParcelsToPackageV1(\Dpd\Services\StructType\AppendParcelsToPackageV1 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->appendParcelsToPackageV1($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named appendParcelsToPackageV2
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Dpd\Services\StructType\AppendParcelsToPackageV2 $parameters
     * @return \Dpd\Services\StructType\AppendParcelsToPackageV2Response|bool
     */
    public function appendParcelsToPackageV2(\Dpd\Services\StructType\AppendParcelsToPackageV2 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->appendParcelsToPackageV2($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Dpd\Services\StructType\AppendParcelsToPackageV1Response|\Dpd\Services\StructType\AppendParcelsToPackageV2Response
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
