<?php

namespace Dpd\Services\EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for shipmentDocumentGenerationStatusEnumV1 EnumType
 * @subpackage Enumerations
 */
class ShipmentDocumentGenerationStatusEnumV1 extends AbstractStructEnumBase
{
    /**
     * Constant for value 'OK'
     * @return string 'OK'
     */
    const VALUE_OK = 'OK';
    /**
     * Constant for value 'NOT_FOUND'
     * @return string 'NOT_FOUND'
     */
    const VALUE_NOT_FOUND = 'NOT_FOUND';
    /**
     * Constant for value 'NOT_PROCESSED'
     * @return string 'NOT_PROCESSED'
     */
    const VALUE_NOT_PROCESSED = 'NOT_PROCESSED';
    /**
     * Constant for value 'INCORRECT_PKGS_FOR_SESSION_TYPE'
     * @return string 'INCORRECT_PKGS_FOR_SESSION_TYPE'
     */
    const VALUE_INCORRECT_PKGS_FOR_SESSION_TYPE = 'INCORRECT_PKGS_FOR_SESSION_TYPE';
    /**
     * Constant for value 'INCORRECT_PICKUP_ADDRESS_FID'
     * @return string 'INCORRECT_PICKUP_ADDRESS_FID'
     */
    const VALUE_INCORRECT_PICKUP_ADDRESS_FID = 'INCORRECT_PICKUP_ADDRESS_FID';
    /**
     * Constant for value 'INCORRECT_PICKUP_ADDRESS_NAME'
     * @return string 'INCORRECT_PICKUP_ADDRESS_NAME'
     */
    const VALUE_INCORRECT_PICKUP_ADDRESS_NAME = 'INCORRECT_PICKUP_ADDRESS_NAME';
    /**
     * Constant for value 'INCORRECT_PICKUP_ADDRESS_COMPANY'
     * @return string 'INCORRECT_PICKUP_ADDRESS_COMPANY'
     */
    const VALUE_INCORRECT_PICKUP_ADDRESS_COMPANY = 'INCORRECT_PICKUP_ADDRESS_COMPANY';
    /**
     * Constant for value 'INCORRECT_PICKUP_ADDRESS_ADDRESS'
     * @return string 'INCORRECT_PICKUP_ADDRESS_ADDRESS'
     */
    const VALUE_INCORRECT_PICKUP_ADDRESS_ADDRESS = 'INCORRECT_PICKUP_ADDRESS_ADDRESS';
    /**
     * Constant for value 'INCORRECT_PICKUP_ADDRESS_CITY'
     * @return string 'INCORRECT_PICKUP_ADDRESS_CITY'
     */
    const VALUE_INCORRECT_PICKUP_ADDRESS_CITY = 'INCORRECT_PICKUP_ADDRESS_CITY';
    /**
     * Constant for value 'INCORRECT_PICKUP_ADDRESS_COUNTRY'
     * @return string 'INCORRECT_PICKUP_ADDRESS_COUNTRY'
     */
    const VALUE_INCORRECT_PICKUP_ADDRESS_COUNTRY = 'INCORRECT_PICKUP_ADDRESS_COUNTRY';
    /**
     * Constant for value 'INCORRECT_PICKUP_ADDRESS_POSTAL_CODE'
     * @return string 'INCORRECT_PICKUP_ADDRESS_POSTAL_CODE'
     */
    const VALUE_INCORRECT_PICKUP_ADDRESS_POSTAL_CODE = 'INCORRECT_PICKUP_ADDRESS_POSTAL_CODE';
    /**
     * Constant for value 'INCORRECT_PICKUP_ADDRESS_EMAIL'
     * @return string 'INCORRECT_PICKUP_ADDRESS_EMAIL'
     */
    const VALUE_INCORRECT_PICKUP_ADDRESS_EMAIL = 'INCORRECT_PICKUP_ADDRESS_EMAIL';
    /**
     * Constant for value 'INCORRECT_PICKUP_ADDRESS_PHONE'
     * @return string 'INCORRECT_PICKUP_ADDRESS_PHONE'
     */
    const VALUE_INCORRECT_PICKUP_ADDRESS_PHONE = 'INCORRECT_PICKUP_ADDRESS_PHONE';
    /**
     * Constant for value 'PARCEL_LIMIT_EXCEEDED'
     * @return string 'PARCEL_LIMIT_EXCEEDED'
     */
    const VALUE_PARCEL_LIMIT_EXCEEDED = 'PARCEL_LIMIT_EXCEEDED';
    /**
     * Constant for value 'ACCESS_DENIED_FOR_FID'
     * @return string 'ACCESS_DENIED_FOR_FID'
     */
    const VALUE_ACCESS_DENIED_FOR_FID = 'ACCESS_DENIED_FOR_FID';
    /**
     * Constant for value 'UNKNOWN_ERROR'
     * @return string 'UNKNOWN_ERROR'
     */
    const VALUE_UNKNOWN_ERROR = 'UNKNOWN_ERROR';
    /**
     * Constant for value 'ALREADY_ADVICED'
     * @return string 'ALREADY_ADVICED'
     */
    const VALUE_ALREADY_ADVICED = 'ALREADY_ADVICED';
    /**
     * Constant for value 'ADVICE_ERROR'
     * @return string 'ADVICE_ERROR'
     */
    const VALUE_ADVICE_ERROR = 'ADVICE_ERROR';
    /**
     * Constant for value 'DB_ERROR'
     * @return string 'DB_ERROR'
     */
    const VALUE_DB_ERROR = 'DB_ERROR';
    /**
     * Constant for value 'ERROR_NO_FID_PERMISSION'
     * @return string 'ERROR_NO_FID_PERMISSION'
     */
    const VALUE_ERROR_NO_FID_PERMISSION = 'ERROR_NO_FID_PERMISSION';
    /**
     * Constant for value 'WAYBILL_NUMBER_OUTSIDE_THE_ALLOWED_RANGE'
     * @return string 'WAYBILL_NUMBER_OUTSIDE_THE_ALLOWED_RANGE'
     */
    const VALUE_WAYBILL_NUMBER_OUTSIDE_THE_ALLOWED_RANGE = 'WAYBILL_NUMBER_OUTSIDE_THE_ALLOWED_RANGE';
    /**
     * Constant for value 'DUPLICATE_WAYBILL_NUMBER'
     * @return string 'DUPLICATE_WAYBILL_NUMBER'
     */
    const VALUE_DUPLICATE_WAYBILL_NUMBER = 'DUPLICATE_WAYBILL_NUMBER';
    /**
     * Constant for value 'DUPLICATED_PACKAGE_SEARCH_KEY'
     * @return string 'DUPLICATED_PACKAGE_SEARCH_KEY'
     */
    const VALUE_DUPLICATED_PACKAGE_SEARCH_KEY = 'DUPLICATED_PACKAGE_SEARCH_KEY';
    /**
     * Constant for value 'DUPLICATED_PARCEL_SEARCH_KEY'
     * @return string 'DUPLICATED_PARCEL_SEARCH_KEY'
     */
    const VALUE_DUPLICATED_PARCEL_SEARCH_KEY = 'DUPLICATED_PARCEL_SEARCH_KEY';
    /**
     * Return allowed values
     * @uses self::VALUE_OK
     * @uses self::VALUE_NOT_FOUND
     * @uses self::VALUE_NOT_PROCESSED
     * @uses self::VALUE_INCORRECT_PKGS_FOR_SESSION_TYPE
     * @uses self::VALUE_INCORRECT_PICKUP_ADDRESS_FID
     * @uses self::VALUE_INCORRECT_PICKUP_ADDRESS_NAME
     * @uses self::VALUE_INCORRECT_PICKUP_ADDRESS_COMPANY
     * @uses self::VALUE_INCORRECT_PICKUP_ADDRESS_ADDRESS
     * @uses self::VALUE_INCORRECT_PICKUP_ADDRESS_CITY
     * @uses self::VALUE_INCORRECT_PICKUP_ADDRESS_COUNTRY
     * @uses self::VALUE_INCORRECT_PICKUP_ADDRESS_POSTAL_CODE
     * @uses self::VALUE_INCORRECT_PICKUP_ADDRESS_EMAIL
     * @uses self::VALUE_INCORRECT_PICKUP_ADDRESS_PHONE
     * @uses self::VALUE_PARCEL_LIMIT_EXCEEDED
     * @uses self::VALUE_ACCESS_DENIED_FOR_FID
     * @uses self::VALUE_UNKNOWN_ERROR
     * @uses self::VALUE_ALREADY_ADVICED
     * @uses self::VALUE_ADVICE_ERROR
     * @uses self::VALUE_DB_ERROR
     * @uses self::VALUE_ERROR_NO_FID_PERMISSION
     * @uses self::VALUE_WAYBILL_NUMBER_OUTSIDE_THE_ALLOWED_RANGE
     * @uses self::VALUE_DUPLICATE_WAYBILL_NUMBER
     * @uses self::VALUE_DUPLICATED_PACKAGE_SEARCH_KEY
     * @uses self::VALUE_DUPLICATED_PARCEL_SEARCH_KEY
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_OK,
            self::VALUE_NOT_FOUND,
            self::VALUE_NOT_PROCESSED,
            self::VALUE_INCORRECT_PKGS_FOR_SESSION_TYPE,
            self::VALUE_INCORRECT_PICKUP_ADDRESS_FID,
            self::VALUE_INCORRECT_PICKUP_ADDRESS_NAME,
            self::VALUE_INCORRECT_PICKUP_ADDRESS_COMPANY,
            self::VALUE_INCORRECT_PICKUP_ADDRESS_ADDRESS,
            self::VALUE_INCORRECT_PICKUP_ADDRESS_CITY,
            self::VALUE_INCORRECT_PICKUP_ADDRESS_COUNTRY,
            self::VALUE_INCORRECT_PICKUP_ADDRESS_POSTAL_CODE,
            self::VALUE_INCORRECT_PICKUP_ADDRESS_EMAIL,
            self::VALUE_INCORRECT_PICKUP_ADDRESS_PHONE,
            self::VALUE_PARCEL_LIMIT_EXCEEDED,
            self::VALUE_ACCESS_DENIED_FOR_FID,
            self::VALUE_UNKNOWN_ERROR,
            self::VALUE_ALREADY_ADVICED,
            self::VALUE_ADVICE_ERROR,
            self::VALUE_DB_ERROR,
            self::VALUE_ERROR_NO_FID_PERMISSION,
            self::VALUE_WAYBILL_NUMBER_OUTSIDE_THE_ALLOWED_RANGE,
            self::VALUE_DUPLICATE_WAYBILL_NUMBER,
            self::VALUE_DUPLICATED_PACKAGE_SEARCH_KEY,
            self::VALUE_DUPLICATED_PARCEL_SEARCH_KEY,
        );
    }
}
