<?php

namespace Dpd\Services\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for sessionDSPV1 StructType
 * @subpackage Structs
 */
class SessionDSPV1 extends AbstractStructBase
{
    /**
     * The packages
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \Dpd\Services\StructType\PackageDSPV1[]
     */
    public $packages;
    /**
     * The sessionId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $sessionId;
    /**
     * The sessionType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $sessionType;
    /**
     * Constructor method for sessionDSPV1
     * @uses SessionDSPV1::setPackages()
     * @uses SessionDSPV1::setSessionId()
     * @uses SessionDSPV1::setSessionType()
     * @param \Dpd\Services\StructType\PackageDSPV1[] $packages
     * @param int $sessionId
     * @param string $sessionType
     */
    public function __construct(array $packages = array(), $sessionId = null, $sessionType = null)
    {
        $this
            ->setPackages($packages)
            ->setSessionId($sessionId)
            ->setSessionType($sessionType);
    }
    /**
     * Get packages value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Dpd\Services\StructType\PackageDSPV1[]|null
     */
    public function getPackages()
    {
        return isset($this->packages) ? $this->packages : null;
    }
    /**
     * Set packages value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Dpd\Services\StructType\PackageDSPV1[] $packages
     * @return \Dpd\Services\StructType\SessionDSPV1
     */
    public function setPackages(array $packages = array())
    {
        if (is_null($packages) || (is_array($packages) && empty($packages))) {
            unset($this->packages);
        } else {
            $this->packages = $packages;
        }
        return $this;
    }
    /**
     * Add item to packages value
     * @throws \InvalidArgumentException
     * @param \Dpd\Services\StructType\PackageDSPV1 $item
     * @return \Dpd\Services\StructType\SessionDSPV1
     */
    public function addToPackages(\Dpd\Services\StructType\PackageDSPV1 $item)
    {
        $this->packages[] = $item;
        return $this;
    }
    /**
     * Get sessionId value
     * @return int|null
     */
    public function getSessionId()
    {
        return $this->sessionId;
    }
    /**
     * Set sessionId value
     * @param int $sessionId
     * @return \Dpd\Services\StructType\SessionDSPV1
     */
    public function setSessionId($sessionId = null)
    {
        $this->sessionId = $sessionId;
        return $this;
    }
    /**
     * Get sessionType value
     * @return string|null
     */
    public function getSessionType()
    {
        return $this->sessionType;
    }
    /**
     * Set sessionType value
     * @param string $sessionType
     * @return \Dpd\Services\StructType\SessionDSPV1
     */
    public function setSessionType($sessionType = null)
    {
        $this->sessionType = $sessionType;
        return $this;
    }
}
