<?php

namespace Dpd\Services\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for parcelDSPV1 StructType
 * @subpackage Structs
 */
class ParcelDSPV1 extends AbstractStructBase
{
    /**
     * The parcelId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $parcelId;
    /**
     * The reference
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $reference;
    /**
     * The waybill
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $waybill;
    /**
     * Constructor method for parcelDSPV1
     * @uses ParcelDSPV1::setParcelId()
     * @uses ParcelDSPV1::setReference()
     * @uses ParcelDSPV1::setWaybill()
     * @param int $parcelId
     * @param string $reference
     * @param string $waybill
     */
    public function __construct($parcelId = null, $reference = null, $waybill = null)
    {
        $this
            ->setParcelId($parcelId)
            ->setReference($reference)
            ->setWaybill($waybill);
    }
    /**
     * Get parcelId value
     * @return int|null
     */
    public function getParcelId()
    {
        return $this->parcelId;
    }
    /**
     * Set parcelId value
     * @param int $parcelId
     * @return \Dpd\Services\StructType\ParcelDSPV1
     */
    public function setParcelId($parcelId = null)
    {
        $this->parcelId = $parcelId;
        return $this;
    }
    /**
     * Get reference value
     * @return string|null
     */
    public function getReference()
    {
        return $this->reference;
    }
    /**
     * Set reference value
     * @param string $reference
     * @return \Dpd\Services\StructType\ParcelDSPV1
     */
    public function setReference($reference = null)
    {
        $this->reference = $reference;
        return $this;
    }
    /**
     * Get waybill value
     * @return string|null
     */
    public function getWaybill()
    {
        return $this->waybill;
    }
    /**
     * Set waybill value
     * @param string $waybill
     * @return \Dpd\Services\StructType\ParcelDSPV1
     */
    public function setWaybill($waybill = null)
    {
        $this->waybill = $waybill;
        return $this;
    }
}
