<?php

namespace Dpd\Services\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for packageOpenUMLFeV3 StructType
 * @subpackage Structs
 */
class PackageOpenUMLFeV3 extends AbstractStructBase
{
    /**
     * The parcels
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \Dpd\Services\StructType\ParcelOpenUMLFeV1[]
     */
    public $parcels;
    /**
     * The payerType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $payerType;
    /**
     * The receiver
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Dpd\Services\StructType\PackageAddressOpenUMLFeV1
     */
    public $receiver;
    /**
     * The ref1
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ref1;
    /**
     * The ref2
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ref2;
    /**
     * The ref3
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ref3;
    /**
     * The reference
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $reference;
    /**
     * The sender
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Dpd\Services\StructType\PackageAddressOpenUMLFeV1
     */
    public $sender;
    /**
     * The services
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Dpd\Services\StructType\ServicesOpenUMLFeV4
     */
    public $services;
    /**
     * The thirdPartyFID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $thirdPartyFID;
    /**
     * Constructor method for packageOpenUMLFeV3
     * @uses PackageOpenUMLFeV3::setParcels()
     * @uses PackageOpenUMLFeV3::setPayerType()
     * @uses PackageOpenUMLFeV3::setReceiver()
     * @uses PackageOpenUMLFeV3::setRef1()
     * @uses PackageOpenUMLFeV3::setRef2()
     * @uses PackageOpenUMLFeV3::setRef3()
     * @uses PackageOpenUMLFeV3::setReference()
     * @uses PackageOpenUMLFeV3::setSender()
     * @uses PackageOpenUMLFeV3::setServices()
     * @uses PackageOpenUMLFeV3::setThirdPartyFID()
     * @param \Dpd\Services\StructType\ParcelOpenUMLFeV1[] $parcels
     * @param string $payerType
     * @param \Dpd\Services\StructType\PackageAddressOpenUMLFeV1 $receiver
     * @param string $ref1
     * @param string $ref2
     * @param string $ref3
     * @param string $reference
     * @param \Dpd\Services\StructType\PackageAddressOpenUMLFeV1 $sender
     * @param \Dpd\Services\StructType\ServicesOpenUMLFeV4 $services
     * @param int $thirdPartyFID
     */
    public function __construct(array $parcels = array(), $payerType = null, \Dpd\Services\StructType\PackageAddressOpenUMLFeV1 $receiver = null, $ref1 = null, $ref2 = null, $ref3 = null, $reference = null, \Dpd\Services\StructType\PackageAddressOpenUMLFeV1 $sender = null, \Dpd\Services\StructType\ServicesOpenUMLFeV4 $services = null, $thirdPartyFID = null)
    {
        $this
            ->setParcels($parcels)
            ->setPayerType($payerType)
            ->setReceiver($receiver)
            ->setRef1($ref1)
            ->setRef2($ref2)
            ->setRef3($ref3)
            ->setReference($reference)
            ->setSender($sender)
            ->setServices($services)
            ->setThirdPartyFID($thirdPartyFID);
    }
    /**
     * Get parcels value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Dpd\Services\StructType\ParcelOpenUMLFeV1[]|null
     */
    public function getParcels()
    {
        return isset($this->parcels) ? $this->parcels : null;
    }
    /**
     * Set parcels value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Dpd\Services\StructType\ParcelOpenUMLFeV1[] $parcels
     * @return \Dpd\Services\StructType\PackageOpenUMLFeV3
     */
    public function setParcels(array $parcels = array())
    {
        if (is_null($parcels) || (is_array($parcels) && empty($parcels))) {
            unset($this->parcels);
        } else {
            $this->parcels = $parcels;
        }
        return $this;
    }
    /**
     * Add item to parcels value
     * @throws \InvalidArgumentException
     * @param \Dpd\Services\StructType\ParcelOpenUMLFeV1 $item
     * @return \Dpd\Services\StructType\PackageOpenUMLFeV3
     */
    public function addToParcels(\Dpd\Services\StructType\ParcelOpenUMLFeV1 $item)
    {
        $this->parcels[] = $item;
        return $this;
    }
    /**
     * Get payerType value
     * @return string|null
     */
    public function getPayerType()
    {
        return $this->payerType;
    }
    /**
     * Set payerType value
     * @param string $payerType
     * @return \Dpd\Services\StructType\PackageOpenUMLFeV3
     */
    public function setPayerType($payerType = null)
    {
        $this->payerType = $payerType;
        return $this;
    }
    /**
     * Get receiver value
     * @return \Dpd\Services\StructType\PackageAddressOpenUMLFeV1|null
     */
    public function getReceiver()
    {
        return $this->receiver;
    }
    /**
     * Set receiver value
     * @param \Dpd\Services\StructType\PackageAddressOpenUMLFeV1 $receiver
     * @return \Dpd\Services\StructType\PackageOpenUMLFeV3
     */
    public function setReceiver(\Dpd\Services\StructType\PackageAddressOpenUMLFeV1 $receiver = null)
    {
        $this->receiver = $receiver;
        return $this;
    }
    /**
     * Get ref1 value
     * @return string|null
     */
    public function getRef1()
    {
        return $this->ref1;
    }
    /**
     * Set ref1 value
     * @param string $ref1
     * @return \Dpd\Services\StructType\PackageOpenUMLFeV3
     */
    public function setRef1($ref1 = null)
    {
        $this->ref1 = $ref1;
        return $this;
    }
    /**
     * Get ref2 value
     * @return string|null
     */
    public function getRef2()
    {
        return $this->ref2;
    }
    /**
     * Set ref2 value
     * @param string $ref2
     * @return \Dpd\Services\StructType\PackageOpenUMLFeV3
     */
    public function setRef2($ref2 = null)
    {
        $this->ref2 = $ref2;
        return $this;
    }
    /**
     * Get ref3 value
     * @return string|null
     */
    public function getRef3()
    {
        return $this->ref3;
    }
    /**
     * Set ref3 value
     * @param string $ref3
     * @return \Dpd\Services\StructType\PackageOpenUMLFeV3
     */
    public function setRef3($ref3 = null)
    {
        $this->ref3 = $ref3;
        return $this;
    }
    /**
     * Get reference value
     * @return string|null
     */
    public function getReference()
    {
        return $this->reference;
    }
    /**
     * Set reference value
     * @param string $reference
     * @return \Dpd\Services\StructType\PackageOpenUMLFeV3
     */
    public function setReference($reference = null)
    {
        $this->reference = $reference;
        return $this;
    }
    /**
     * Get sender value
     * @return \Dpd\Services\StructType\PackageAddressOpenUMLFeV1|null
     */
    public function getSender()
    {
        return $this->sender;
    }
    /**
     * Set sender value
     * @param \Dpd\Services\StructType\PackageAddressOpenUMLFeV1 $sender
     * @return \Dpd\Services\StructType\PackageOpenUMLFeV3
     */
    public function setSender(\Dpd\Services\StructType\PackageAddressOpenUMLFeV1 $sender = null)
    {
        $this->sender = $sender;
        return $this;
    }
    /**
     * Get services value
     * @return \Dpd\Services\StructType\ServicesOpenUMLFeV4|null
     */
    public function getServices()
    {
        return $this->services;
    }
    /**
     * Set services value
     * @param \Dpd\Services\StructType\ServicesOpenUMLFeV4 $services
     * @return \Dpd\Services\StructType\PackageOpenUMLFeV3
     */
    public function setServices(\Dpd\Services\StructType\ServicesOpenUMLFeV4 $services = null)
    {
        $this->services = $services;
        return $this;
    }
    /**
     * Get thirdPartyFID value
     * @return int|null
     */
    public function getThirdPartyFID()
    {
        return $this->thirdPartyFID;
    }
    /**
     * Set thirdPartyFID value
     * @param int $thirdPartyFID
     * @return \Dpd\Services\StructType\PackageOpenUMLFeV3
     */
    public function setThirdPartyFID($thirdPartyFID = null)
    {
        $this->thirdPartyFID = $thirdPartyFID;
        return $this;
    }
}
