<?php

namespace Dpd\Services\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for dpdPickupCallParamsV2 StructType
 * @subpackage Structs
 */
class DpdPickupCallParamsV2 extends AbstractStructBase
{
    /**
     * The operationType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $operationType;
    /**
     * The orderNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $orderNumber;
    /**
     * The orderType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $orderType;
    /**
     * The pickupCallSimplifiedDetails
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Dpd\Services\StructType\PickupCallSimplifiedDetailsDPPV1
     */
    public $pickupCallSimplifiedDetails;
    /**
     * The pickupDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $pickupDate;
    /**
     * The pickupTimeFrom
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $pickupTimeFrom;
    /**
     * The pickupTimeTo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $pickupTimeTo;
    /**
     * The updateMode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $updateMode;
    /**
     * The waybillsReady
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $waybillsReady;
    /**
     * Constructor method for dpdPickupCallParamsV2
     * @uses DpdPickupCallParamsV2::setOperationType()
     * @uses DpdPickupCallParamsV2::setOrderNumber()
     * @uses DpdPickupCallParamsV2::setOrderType()
     * @uses DpdPickupCallParamsV2::setPickupCallSimplifiedDetails()
     * @uses DpdPickupCallParamsV2::setPickupDate()
     * @uses DpdPickupCallParamsV2::setPickupTimeFrom()
     * @uses DpdPickupCallParamsV2::setPickupTimeTo()
     * @uses DpdPickupCallParamsV2::setUpdateMode()
     * @uses DpdPickupCallParamsV2::setWaybillsReady()
     * @param string $operationType
     * @param string $orderNumber
     * @param string $orderType
     * @param \Dpd\Services\StructType\PickupCallSimplifiedDetailsDPPV1 $pickupCallSimplifiedDetails
     * @param string $pickupDate
     * @param string $pickupTimeFrom
     * @param string $pickupTimeTo
     * @param string $updateMode
     * @param bool $waybillsReady
     */
    public function __construct($operationType = null, $orderNumber = null, $orderType = null, \Dpd\Services\StructType\PickupCallSimplifiedDetailsDPPV1 $pickupCallSimplifiedDetails = null, $pickupDate = null, $pickupTimeFrom = null, $pickupTimeTo = null, $updateMode = null, $waybillsReady = null)
    {
        $this
            ->setOperationType($operationType)
            ->setOrderNumber($orderNumber)
            ->setOrderType($orderType)
            ->setPickupCallSimplifiedDetails($pickupCallSimplifiedDetails)
            ->setPickupDate($pickupDate)
            ->setPickupTimeFrom($pickupTimeFrom)
            ->setPickupTimeTo($pickupTimeTo)
            ->setUpdateMode($updateMode)
            ->setWaybillsReady($waybillsReady);
    }
    /**
     * Get operationType value
     * @return string|null
     */
    public function getOperationType()
    {
        return $this->operationType;
    }
    /**
     * Set operationType value
     * @param string $operationType
     * @return \Dpd\Services\StructType\DpdPickupCallParamsV2
     */
    public function setOperationType($operationType = null)
    {
        $this->operationType = $operationType;
        return $this;
    }
    /**
     * Get orderNumber value
     * @return string|null
     */
    public function getOrderNumber()
    {
        return $this->orderNumber;
    }
    /**
     * Set orderNumber value
     * @param string $orderNumber
     * @return \Dpd\Services\StructType\DpdPickupCallParamsV2
     */
    public function setOrderNumber($orderNumber = null)
    {
        $this->orderNumber = $orderNumber;
        return $this;
    }
    /**
     * Get orderType value
     * @return string|null
     */
    public function getOrderType()
    {
        return $this->orderType;
    }
    /**
     * Set orderType value
     * @param string $orderType
     * @return \Dpd\Services\StructType\DpdPickupCallParamsV2
     */
    public function setOrderType($orderType = null)
    {
        $this->orderType = $orderType;
        return $this;
    }
    /**
     * Get pickupCallSimplifiedDetails value
     * @return \Dpd\Services\StructType\PickupCallSimplifiedDetailsDPPV1|null
     */
    public function getPickupCallSimplifiedDetails()
    {
        return $this->pickupCallSimplifiedDetails;
    }
    /**
     * Set pickupCallSimplifiedDetails value
     * @param \Dpd\Services\StructType\PickupCallSimplifiedDetailsDPPV1 $pickupCallSimplifiedDetails
     * @return \Dpd\Services\StructType\DpdPickupCallParamsV2
     */
    public function setPickupCallSimplifiedDetails(\Dpd\Services\StructType\PickupCallSimplifiedDetailsDPPV1 $pickupCallSimplifiedDetails = null)
    {
        $this->pickupCallSimplifiedDetails = $pickupCallSimplifiedDetails;
        return $this;
    }
    /**
     * Get pickupDate value
     * @return string|null
     */
    public function getPickupDate()
    {
        return $this->pickupDate;
    }
    /**
     * Set pickupDate value
     * @param string $pickupDate
     * @return \Dpd\Services\StructType\DpdPickupCallParamsV2
     */
    public function setPickupDate($pickupDate = null)
    {
        $this->pickupDate = $pickupDate;
        return $this;
    }
    /**
     * Get pickupTimeFrom value
     * @return string|null
     */
    public function getPickupTimeFrom()
    {
        return $this->pickupTimeFrom;
    }
    /**
     * Set pickupTimeFrom value
     * @param string $pickupTimeFrom
     * @return \Dpd\Services\StructType\DpdPickupCallParamsV2
     */
    public function setPickupTimeFrom($pickupTimeFrom = null)
    {
        $this->pickupTimeFrom = $pickupTimeFrom;
        return $this;
    }
    /**
     * Get pickupTimeTo value
     * @return string|null
     */
    public function getPickupTimeTo()
    {
        return $this->pickupTimeTo;
    }
    /**
     * Set pickupTimeTo value
     * @param string $pickupTimeTo
     * @return \Dpd\Services\StructType\DpdPickupCallParamsV2
     */
    public function setPickupTimeTo($pickupTimeTo = null)
    {
        $this->pickupTimeTo = $pickupTimeTo;
        return $this;
    }
    /**
     * Get updateMode value
     * @return string|null
     */
    public function getUpdateMode()
    {
        return $this->updateMode;
    }
    /**
     * Set updateMode value
     * @param string $updateMode
     * @return \Dpd\Services\StructType\DpdPickupCallParamsV2
     */
    public function setUpdateMode($updateMode = null)
    {
        $this->updateMode = $updateMode;
        return $this;
    }
    /**
     * Get waybillsReady value
     * @return bool|null
     */
    public function getWaybillsReady()
    {
        return $this->waybillsReady;
    }
    /**
     * Set waybillsReady value
     * @param bool $waybillsReady
     * @return \Dpd\Services\StructType\DpdPickupCallParamsV2
     */
    public function setWaybillsReady($waybillsReady = null)
    {
        $this->waybillsReady = $waybillsReady;
        return $this;
    }
}
