<?php

namespace Dpd\Services\Service;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Import Service
 * @subpackage Services
 */
class Import extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named importDeliveryBusinessEventV1
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Dpd\Services\StructType\ImportDeliveryBusinessEventV1 $parameters
     * @return \Dpd\Services\StructType\ImportDeliveryBusinessEventV1Response|bool
     */
    public function importDeliveryBusinessEventV1(\Dpd\Services\StructType\ImportDeliveryBusinessEventV1 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->importDeliveryBusinessEventV1($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Dpd\Services\StructType\ImportDeliveryBusinessEventV1Response
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
