<?php

namespace Dpd\Services\EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for serviceCurrencyEnum EnumType
 * @subpackage Enumerations
 */
class ServiceCurrencyEnum extends AbstractStructEnumBase
{
    /**
     * Constant for value 'PLN'
     * @return string 'PLN'
     */
    const VALUE_PLN = 'PLN';
    /**
     * Constant for value 'EUR'
     * @return string 'EUR'
     */
    const VALUE_EUR = 'EUR';
    /**
     * Constant for value 'USD'
     * @return string 'USD'
     */
    const VALUE_USD = 'USD';
    /**
     * Constant for value 'CHF'
     * @return string 'CHF'
     */
    const VALUE_CHF = 'CHF';
    /**
     * Constant for value 'SEK'
     * @return string 'SEK'
     */
    const VALUE_SEK = 'SEK';
    /**
     * Constant for value 'NOK'
     * @return string 'NOK'
     */
    const VALUE_NOK = 'NOK';
    /**
     * Constant for value 'CZK'
     * @return string 'CZK'
     */
    const VALUE_CZK = 'CZK';
    /**
     * Constant for value 'RON'
     * @return string 'RON'
     */
    const VALUE_RON = 'RON';
    /**
     * Constant for value 'HUF'
     * @return string 'HUF'
     */
    const VALUE_HUF = 'HUF';
    /**
     * Constant for value 'HRK'
     * @return string 'HRK'
     */
    const VALUE_HRK = 'HRK';
    /**
     * Constant for value 'BGN'
     * @return string 'BGN'
     */
    const VALUE_BGN = 'BGN';
    /**
     * Constant for value 'DKK'
     * @return string 'DKK'
     */
    const VALUE_DKK = 'DKK';
    /**
     * Constant for value 'GBP'
     * @return string 'GBP'
     */
    const VALUE_GBP = 'GBP';
    /**
     * Constant for value 'RSD'
     * @return string 'RSD'
     */
    const VALUE_RSD = 'RSD';
    /**
     * Constant for value 'RUB'
     * @return string 'RUB'
     */
    const VALUE_RUB = 'RUB';
    /**
     * Constant for value 'TRY'
     * @return string 'TRY'
     */
    const VALUE_TRY = 'TRY';
    /**
     * Constant for value 'UNKNOWN'
     * @return string 'UNKNOWN'
     */
    const VALUE_UNKNOWN = 'UNKNOWN';
    /**
     * Return allowed values
     * @uses self::VALUE_PLN
     * @uses self::VALUE_EUR
     * @uses self::VALUE_USD
     * @uses self::VALUE_CHF
     * @uses self::VALUE_SEK
     * @uses self::VALUE_NOK
     * @uses self::VALUE_CZK
     * @uses self::VALUE_RON
     * @uses self::VALUE_HUF
     * @uses self::VALUE_HRK
     * @uses self::VALUE_BGN
     * @uses self::VALUE_DKK
     * @uses self::VALUE_GBP
     * @uses self::VALUE_RSD
     * @uses self::VALUE_RUB
     * @uses self::VALUE_TRY
     * @uses self::VALUE_UNKNOWN
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_PLN,
            self::VALUE_EUR,
            self::VALUE_USD,
            self::VALUE_CHF,
            self::VALUE_SEK,
            self::VALUE_NOK,
            self::VALUE_CZK,
            self::VALUE_RON,
            self::VALUE_HUF,
            self::VALUE_HRK,
            self::VALUE_BGN,
            self::VALUE_DKK,
            self::VALUE_GBP,
            self::VALUE_RSD,
            self::VALUE_RUB,
            self::VALUE_TRY,
            self::VALUE_UNKNOWN,
        );
    }
}
